/**
 * @(#)CsActivityInventoryQueryDto.java 1.0 2022/01/17 10:06
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsActivityInventoryQueryDto
*
* @author jingran
* @Date: 2022/01/17 10:06
* @since 1.0.0
*/
@ApiModel(value = "csActivityInventoryQueryDto", description = "查询Dto")
public class CsActivityInventoryQueryDto implements Serializable {

    /** 活动ID */
    @ApiModelProperty(name="activityId",value = "活动ID")
    private Long activityId;
    /** 活动编码 */
    @ApiModelProperty(name="activityCode",value = "活动编码")
    private String activityCode;
    /** 活动名称 */
    @ApiModelProperty(name="activityName",value = "活动名称")
    private String activityName;
    /** 活动类型 */
    @ApiModelProperty(name="activityType",value = "活动类型")
    private String activityType;
    /** 活动套数 */
    @ApiModelProperty(name="activityNum",value = "活动套数")
    private Integer activityNum;
    /** 套装名称 */
    @ApiModelProperty(name="suitName",value = "套装名称")
    private String suitName;
    /** 店铺ID */
    @ApiModelProperty(name="shopId",value = "店铺ID")
    private Long shopId;
    /** 店铺名称 */
    @ApiModelProperty(name="shopName",value = "店铺名称")
    private Long shopName;
    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 比例,此活动在此活动里占的比例,此货品活动总库存 = 活动套数 x 此货品比例 */
    @ApiModelProperty(name="cargoProportion",value = "比例,此活动在此活动里占的比例,此货品活动总库存 = 活动套数 x 此货品比例")
    private BigDecimal cargoProportion;
    /** 活动总库存 */
    @ApiModelProperty(name="balance",value = "活动总库存")
    private BigDecimal balance;
    /** 活动预占库存 */
    @ApiModelProperty(name="preempt",value = "活动预占库存")
    private BigDecimal preempt;
    /** 活动已完成库存 */
    @ApiModelProperty(name="completed",value = "活动已完成库存")
    private BigDecimal completed;
    /** 活动可用库存 = 活动总库存 - 活动预占库存 - 活动已完成库存 */
    @ApiModelProperty(name="available",value = "活动可用库存 = 活动总库存 - 活动预占库存 - 活动已完成库存")
    private BigDecimal available;
    /** 活动是否已结束  ongoing-进行中  terminate-已结束 */
    @ApiModelProperty(name="finishFlag",value = "活动是否已结束  ongoing-进行中  terminate-已结束")
    private String finishFlag;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityNum() {
        return activityNum;
    }

    public void setActivityNum(Integer activityNum) {
        this.activityNum = activityNum;
    }

    public String getSuitName() {
        return suitName;
    }

    public void setSuitName(String suitName) {
        this.suitName = suitName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getShopName() {
        return shopName;
    }

    public void setShopName(Long shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public BigDecimal getCargoProportion() {
        return cargoProportion;
    }

    public void setCargoProportion(BigDecimal cargoProportion) {
        this.cargoProportion = cargoProportion;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getCompleted() {
        return completed;
    }

    public void setCompleted(BigDecimal completed) {
        this.completed = completed;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(String finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}