package com.dtyunxi.yundt.cube.center.inventory.dto.base.req;

import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventorySubItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class TcbjResGenItemReqDto {
    @ApiModelProperty(name = "batch")
    private String batch;
    @ApiModelProperty(name = "cargoCode")
    private String cargoCode;
    @ApiModelProperty(name = "num")
    private Integer num = 0;

    /**
     * 过期日期
     */
    @ApiModelProperty(name = "expireTime")
    private Date expireTime;

    /**
     * 生产日期
     */
    @ApiModelProperty(name = "produceTime")
    private Date produceTime;

    /**
     * 过期日期
     */
    @ApiModelProperty(name = "expireDate")
    private Date expireDate;

    /**
     * 生产日期
     */
    @ApiModelProperty(name = "productDate")
    private Date productDate;

    @ApiModelProperty(name = "orderNo")
    private String orderNo;

    @ApiModelProperty(name = "自定义json串，对应对象com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.MqContentOtherFieldDto")
    private String OtherField1;

    /**
     * 是否礼盒产品
     */
    @ApiModelProperty(name = "isGift", value = "是否礼盒；0：否；1：是")
    private Integer isGift = YesNoEnum.NO.getValue();

    /**
     * 子产品信息
     */
    @ApiModelProperty(name = "subItemList")
    private List<InventorySubItemReqDto> subItemList;
}