/**
 * @(#)ICsInventoryYxyDailyApi.java 1.0 2022/04/13 14:52
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.log;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryYxyDailyAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* ICsInventoryYxyDailyApi
*
* @author wenyi
* @Date: 2022/04/13 14:52
* @since 1.0.0
*/
@Api(tags = {"ICsInventoryYxyDailyApi"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryYxyDaily", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryYxyDailyApi {

    /**
     * 添加营销云和库存中心库存对比数据
     * @param list
     * @return
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Void> add(@RequestBody List<CsInventoryYxyDailyAddReqDto> list);

}