package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 逻辑仓仓库状态,仓库状态 initial-初始,enable-启用,disable-停用
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:56 下午
 */
public enum CsLogicWarehouseStatusEnum {
    /** 初始 **/
    INITIAL("initial","初始"),

    /** 启用 **/
    ENABLE("enable","启用"),

    /** 停用 **/
    DISABLE("disable","停用"),
    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsLogicWarehouseStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsLogicWarehouseStatusEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsLogicWarehouseStatusEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
