/**
 * @(#)CsLogicWarehouseRespDto.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

//

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
@ApiModel(value = "csLogicWarehouseRespDto", description = "返回信息Dto")
public class CsLogicSupplyWarehouseRespDto extends BaseRespDto {

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库类型,待定
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型,待定")
    private String warehouseType;
    /**
     * 仓库状态 initial-初始,enable-启用,disable-停用
     */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-启用,disable-停用")
    private String warehouseStatus;

    /**
     * 是否主仓：1.是，0否
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：1.是，0否")
    private Integer mainWarehouse;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "isDefault", value = "是否默认:0.否,1.是")
    private Integer isDefault = 1;

    /**
     * spa工厂
     */
    @ApiModelProperty(name = "sapFactory", value = "spa工厂")
    private String sapFactory;

    /**
     * sap库位
     */
    @ApiModelProperty(name = "sapStorageLocation", value = "sap库位")
    private String sapStorageLocation;

    /**
     * 是否允许负库存 0-不允许 1-允许
     */
    @ApiModelProperty(name = "negative_flag", value = "是否允许负库存 0-不允许 1-允许")
    private Integer negativeFlag;

    /**
     * 是否允许负库存 0-不允许 1-允许
     */
    @ApiModelProperty(name = "warehouseIsNegative", value = "是否允许负库存 0-不允许 1-允许")
    private Integer warehouseIsNegative;

    /**
     * 渠道类型
     */
    @ApiModelProperty(name = "channel_type", value = "渠道类型")
    private String channelType;

    @ApiModelProperty(name = "warehouseAddress", value = "地址信息")
    private CsWarehouseAddressRespDto warehouseAddress;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contact", value = "联系人")
    private String contact;
    /**
     * 联系电话
     */
    @ApiModelProperty(name = "phone", value = "联系电话")
    private String phone;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

}
