package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 供货模式配置表服务接口
*
* @author Ghosn
* @since 2024-11-05
*/
@Api(tags = {"供货模式配置表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IWarehouseSupplyConfigApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/warehouse/supply/config",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IWarehouseSupplyConfigApi {

    /**
    * 新增供货模式配置表
    *
    * @param addReqDto 供货模式配置表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增供货模式配置表", notes = "新增供货模式配置表")
    RestResponse<Long> addWarehouseSupplyConfig(@RequestBody WarehouseSupplyConfigReqDto addReqDto);

    /**
    * 修改供货模式配置表
    *
    * @param modifyReqDto 供货模式配置表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改供货模式配置表", notes = "修改供货模式配置表")
    RestResponse<Void> modifyWarehouseSupplyConfig(@RequestBody WarehouseSupplyConfigReqDto modifyReqDto);

    /**
    * 删除供货模式配置表
    *
    * @param ids        供货模式配置表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除供货模式配置表", notes = "删除供货模式配置表")
    RestResponse<Void> removeWarehouseSupplyConfig(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
