package com.dtyunxi.yundt.cube.center.inventory.constant;

/**
 * <p> 幂等校验前缀维护 </p>
 *
 * @author jinger
 * @since 1.0
 */
public interface IdempotentCheckKeyPre {
    /**
     * 发货通知单幂等校验前缀
     */
    public final String DeliveryNotice = "DeliveryNotice:";

    /**
     * 发货结果单幂等校验前缀
     */
    public final String DeliveryResult = "DeliveryResult:";

    /**
     * 收货通知单幂等校验前缀
     */
    public final String ReceiveNotice = "ReceiveNotice:";

    /**
     * 收货结果单幂等校验前缀
     */
    public final String ReceiveResult = "ReceiveResult:";

    /**
     * 入库通知单幂等校验前缀
     */
    public final String InNotice = "InNotice:";

    /**
     * 入库结果幂等校验前缀
     */
    public final String InResult = "InResult:";

    /**
     * 出库通知单幂等校验前缀
     */
    public final String OutNotice = "OutNotice:";

    /**
     * 出库结果幂等校验前缀
     */
    public final String OutResult = "OutResult:";

    /**
     * 发货批量审核通过幂等校验前缀
     */
    public final String BatchUpdateOrderStatusPass = "BatchUpdateOrderStatusPass:";

    /**
     * 发货批量审核不通过幂等校验前缀
     */
    public final String BatchUpdateOrderStatusNoPass = "BatchUpdateOrderStatusNoPass:";

    /**
     * 调整单批量审核幂等校验前缀
     */
    public final String BatchAdjustDocument = "BatchAdjustDocument:";

    /**
     *  库存预占幂等校验前缀
     */
    public final String PREEMPT_INVENTORY = "PREEMPT_INVENTORY:";

    /**
     *  库存释放等校验前缀
     */
    public final String RELEASE_INVENTORY = "RELEASE_INVENTORY:";

    /**
     *  发货库存扣减幂等校验前缀
     */
    public final String DEDUCTION_INVENTORY = "DEDUCTION_INVENTORY:";

    /**
     * 幂等后缀
     */
    public final String SUFFIX = "suffix";

}
