package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 退货入库复核请求DTO
 *
 * @author jingran
 */
public class TcbjReCheckReqDto implements Serializable {

    /**
     * 订单号
     */
    @ApiModelProperty(name = "refundOrderNo", value = "退货单号")
    private String refundOrderNo;

    /** 外部单号 */
    @ApiModelProperty(name="externalOrderNo",value = "外部单号")
    private String externalOrderNo;

    @ApiModelProperty(name = "warehouseCode", value = "退货仓库编码")
    private String warehouseCode;

    /**
     * 货品明细信息
     */
    @ApiModelProperty(name = "退货单号", value = "订单号")
    private List<TcbjReCheckDetailReqDto> reCheckDetailReqDtoList;

    public TcbjReCheckReqDto() {
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public List<TcbjReCheckDetailReqDto> getReCheckDetailReqDtoList() {
        return reCheckDetailReqDtoList;
    }

    public void setReCheckDetailReqDtoList(List<TcbjReCheckDetailReqDto> reCheckDetailReqDtoList) {
        this.reCheckDetailReqDtoList = reCheckDetailReqDtoList;
    }
}
