/**
 * @(#)CsPhysicsWarehouseQueryApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseExposedAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* 逻辑仓暴露给PCP应用层的相关操作接口
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@Api(tags = {"逻辑仓暴露给PCP应用层的相关操作接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csLogicWarehouseExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicWarehouseExposedApi {

    /**
     * 新增逻辑仓仓库
     *
     * @param csPhysicsWarehouseExposedAddReqDto
     * @return
     */
    @GetMapping(value = "/addLogicWarehouse", produces = "application/json")
    @ApiOperation(value = "新增逻辑仓仓库", notes = "新增逻辑仓仓库")
    RestResponse<Long> addLogicWarehouse(@RequestBody CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto);

    /**
     * 编辑物理仓仓库
     *
     * @param csPhysicsWarehouseExposedAddReqDto
     * @return
     */
    @GetMapping(value = "/updatePhysicsWarehouse", produces = "application/json")
    @ApiOperation(value = "编辑物理仓仓库", notes = "编辑物理仓仓库")
    RestResponse<Boolean> updatePhysicsWarehouse(@RequestBody CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto);

}