/**
 * @(#)CsInventoryLogQueryDto.java 1.0 2022/01/10 10:47
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsInventoryLogQueryDto
*
* @author jingran
* @Date: 2022/01/10 10:47
* @since 1.0.0
*/
@ApiModel(value = "csInventoryLogQueryDto", description = "查询Dto")
public class CsInventoryLogQueryDto implements Serializable {

    /** 版本号 */
    @ApiModelProperty(name="version",value = "版本号")
    private String version;
    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库对应于不同层级仓库的类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 批次类型 common-正常,defective-残次品,其他类型待定 */
    @ApiModelProperty(name="batchType",value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /** 变动前总库存 */
    @ApiModelProperty(name="beforeBalance",value = "变动前总库存")
    private BigDecimal beforeBalance;
    /** 变动总库存 */
    @ApiModelProperty(name="changeBalance",value = "变动总库存")
    private BigDecimal changeBalance;
    /** 变动后总库存 */
    @ApiModelProperty(name="afterBalance",value = "变动后总库存")
    private BigDecimal afterBalance;
    /** 变动前预占库存 */
    @ApiModelProperty(name="beforePreempt",value = "变动前预占库存")
    private BigDecimal beforePreempt;
    /** 变动预占库存 */
    @ApiModelProperty(name="changePreempt",value = "变动预占库存")
    private BigDecimal changePreempt;
    /** 变动后预占库存 */
    @ApiModelProperty(name="afterPreempt",value = "变动后预占库存")
    private BigDecimal afterPreempt;
    /** 变动前已分配库存 */
    @ApiModelProperty(name="beforeAllocate",value = "变动前已分配库存")
    private BigDecimal beforeAllocate;
    /** 变动已分配库存 */
    @ApiModelProperty(name="changeAllocate",value = "变动已分配库存")
    private BigDecimal changeAllocate;
    /** 变动后已分配库存 */
    @ApiModelProperty(name="afterAllocate",value = "变动后已分配库存")
    private BigDecimal afterAllocate;
    /** 变动前活动分配库存 */
    @ApiModelProperty(name="beforeActivityAllocate",value = "变动前活动分配库存")
    private BigDecimal beforeActivityAllocate;
    /** 变动活动分配库存 */
    @ApiModelProperty(name="changeActivityAllocate",value = "变动活动分配库存")
    private BigDecimal changeActivityAllocate;
    /** 变动后活动分配库存 */
    @ApiModelProperty(name="afterActivityAllocate",value = "变动后活动分配库存")
    private BigDecimal afterActivityAllocate;
    /** 变动前在途库存 */
    @ApiModelProperty(name="beforeIntransit",value = "变动前在途库存")
    private BigDecimal beforeIntransit;
    /** 变动在途库存 */
    @ApiModelProperty(name="changeIntransit",value = "变动在途库存")
    private BigDecimal changeIntransit;
    /** 变动后在途库存 */
    @ApiModelProperty(name="afterIntransit",value = "变动后在途库存")
    private BigDecimal afterIntransit;
    /** 变动前已调拨库存 */
    @ApiModelProperty(name="beforeTransfer",value = "变动前已调拨库存")
    private BigDecimal beforeTransfer;
    /** 变动已调拨库存 */
    @ApiModelProperty(name="changeTransfer",value = "变动已调拨库存")
    private BigDecimal changeTransfer;
    /** 变动后已调拨库存 */
    @ApiModelProperty(name="afterTransfer",value = "变动后已调拨库存")
    private BigDecimal afterTransfer;
    /** 变动前已完成库存 */
    @ApiModelProperty(name="beforeCompleted",value = "变动前已完成库存")
    private BigDecimal beforeCompleted;
    /** 变动已完成库存 */
    @ApiModelProperty(name="changeCompleted",value = "变动已完成库存")
    private BigDecimal changeCompleted;
    /** 变动后已完成库存 */
    @ApiModelProperty(name="afterCompleted",value = "变动后已完成库存")
    private BigDecimal afterCompleted;
    /** 变动前可用库存 */
    @ApiModelProperty(name="beforeAvailable",value = "变动前可用库存")
    private BigDecimal beforeAvailable;
    /** 变动可用库存 */
    @ApiModelProperty(name="changeAvailable",value = "变动可用库存")
    private BigDecimal changeAvailable;
    /** 变动后可用库存 */
    @ApiModelProperty(name="afterAvailable",value = "变动后可用库存")
    private BigDecimal afterAvailable;
    /** 单据类型,待定 */
    @ApiModelProperty(name="sourceType",value = "单据类型,待定")
    private String sourceType;
    /** 来源单据号 */
    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatchType() {
        return batchType;
    }

    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getChangeBalance() {
        return changeBalance;
    }

    public void setChangeBalance(BigDecimal changeBalance) {
        this.changeBalance = changeBalance;
    }

    public BigDecimal getAfterBalance() {
        return afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getBeforePreempt() {
        return beforePreempt;
    }

    public void setBeforePreempt(BigDecimal beforePreempt) {
        this.beforePreempt = beforePreempt;
    }

    public BigDecimal getChangePreempt() {
        return changePreempt;
    }

    public void setChangePreempt(BigDecimal changePreempt) {
        this.changePreempt = changePreempt;
    }

    public BigDecimal getAfterPreempt() {
        return afterPreempt;
    }

    public void setAfterPreempt(BigDecimal afterPreempt) {
        this.afterPreempt = afterPreempt;
    }

    public BigDecimal getBeforeAllocate() {
        return beforeAllocate;
    }

    public void setBeforeAllocate(BigDecimal beforeAllocate) {
        this.beforeAllocate = beforeAllocate;
    }

    public BigDecimal getChangeAllocate() {
        return changeAllocate;
    }

    public void setChangeAllocate(BigDecimal changeAllocate) {
        this.changeAllocate = changeAllocate;
    }

    public BigDecimal getAfterAllocate() {
        return afterAllocate;
    }

    public void setAfterAllocate(BigDecimal afterAllocate) {
        this.afterAllocate = afterAllocate;
    }

    public BigDecimal getBeforeActivityAllocate() {
        return beforeActivityAllocate;
    }

    public void setBeforeActivityAllocate(BigDecimal beforeActivityAllocate) {
        this.beforeActivityAllocate = beforeActivityAllocate;
    }

    public BigDecimal getChangeActivityAllocate() {
        return changeActivityAllocate;
    }

    public void setChangeActivityAllocate(BigDecimal changeActivityAllocate) {
        this.changeActivityAllocate = changeActivityAllocate;
    }

    public BigDecimal getAfterActivityAllocate() {
        return afterActivityAllocate;
    }

    public void setAfterActivityAllocate(BigDecimal afterActivityAllocate) {
        this.afterActivityAllocate = afterActivityAllocate;
    }

    public BigDecimal getBeforeIntransit() {
        return beforeIntransit;
    }

    public void setBeforeIntransit(BigDecimal beforeIntransit) {
        this.beforeIntransit = beforeIntransit;
    }

    public BigDecimal getChangeIntransit() {
        return changeIntransit;
    }

    public void setChangeIntransit(BigDecimal changeIntransit) {
        this.changeIntransit = changeIntransit;
    }

    public BigDecimal getAfterIntransit() {
        return afterIntransit;
    }

    public void setAfterIntransit(BigDecimal afterIntransit) {
        this.afterIntransit = afterIntransit;
    }

    public BigDecimal getBeforeTransfer() {
        return beforeTransfer;
    }

    public void setBeforeTransfer(BigDecimal beforeTransfer) {
        this.beforeTransfer = beforeTransfer;
    }

    public BigDecimal getChangeTransfer() {
        return changeTransfer;
    }

    public void setChangeTransfer(BigDecimal changeTransfer) {
        this.changeTransfer = changeTransfer;
    }

    public BigDecimal getAfterTransfer() {
        return afterTransfer;
    }

    public void setAfterTransfer(BigDecimal afterTransfer) {
        this.afterTransfer = afterTransfer;
    }

    public BigDecimal getBeforeCompleted() {
        return beforeCompleted;
    }

    public void setBeforeCompleted(BigDecimal beforeCompleted) {
        this.beforeCompleted = beforeCompleted;
    }

    public BigDecimal getChangeCompleted() {
        return changeCompleted;
    }

    public void setChangeCompleted(BigDecimal changeCompleted) {
        this.changeCompleted = changeCompleted;
    }

    public BigDecimal getAfterCompleted() {
        return afterCompleted;
    }

    public void setAfterCompleted(BigDecimal afterCompleted) {
        this.afterCompleted = afterCompleted;
    }

    public BigDecimal getBeforeAvailable() {
        return beforeAvailable;
    }

    public void setBeforeAvailable(BigDecimal beforeAvailable) {
        this.beforeAvailable = beforeAvailable;
    }

    public BigDecimal getChangeAvailable() {
        return changeAvailable;
    }

    public void setChangeAvailable(BigDecimal changeAvailable) {
        this.changeAvailable = changeAvailable;
    }

    public BigDecimal getAfterAvailable() {
        return afterAvailable;
    }

    public void setAfterAvailable(BigDecimal afterAvailable) {
        this.afterAvailable = afterAvailable;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}