/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.warehouse;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csPhysicsWarehouseQueryApiImpl")
public class CsPhysicsWarehouseQueryApiImpl
implements ICsPhysicsWarehouseQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseQueryApiImpl.class);
    @Autowired
    private ICsPhysicsWarehouseQueryService csPhysicsWarehouseQueryService;

    public RestResponse<CsPhysicsWarehouseRespDto> queryByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        PhysicsWarehouseEo eo = this.csPhysicsWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        CsPhysicsWarehouseRespDto dto = new CsPhysicsWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<CsPhysicsWarehouseRespDto>> queryByPage(CsPhysicsWarehouseQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.csPhysicsWarehouseQueryService.queryByPage(queryDto));
    }

    public RestResponse<List<CsPhysicsWarehouseRespDto>> queryByParam(CsPhysicsWarehouseQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(null);
    }
}

