/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.BusinessOrderCallBackParseHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.ITransferOrderWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutMatchRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics.CsInOutBasicsOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="Cstransfer_orderBusinessOrderCallBackService")
public class CsTransferOrderCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static final Logger log = LoggerFactory.getLogger(CsTransferOrderCallBackServiceImpl.class);
    @Resource
    CsTransferOrderDas csTransferOrderDas;
    @Resource
    IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    MqService mqService;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    BaseOrderFacade baseOrderFacade;
    @Resource
    ITransferOrderWrapperHelper transferOrderWrapperHelper;
    @Resource
    IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Autowired
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Autowired
    TransactionCallBackService transactionCallBackService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getStrategy() {
        return "tcbjtransfer_order";
    }

    private void updateOrderStatus(String transferOrderNo, String status) {
        log.info("\u66f4\u65b0\u8c03\u62e8\u5355\u636e\u72b6\u6001\uff1a{}\uff0c{}", (Object)transferOrderNo, (Object)status);
        CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(transferOrderNo);
        CsTransferOrderEo updateEo = new CsTransferOrderEo();
        updateEo.setId(transferOrderEo.getId());
        updateEo.setOrderStatus(status);
        this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
        if (CsTransferOrderEnum.Status.CANCELED.getCode().equals(status) && (transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.INTERNAL_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode()))) {
            this.csTransferOrderDas.logicDeleteById(transferOrderEo.getId());
        }
        if (CsTransferOrderEnum.Status.DELIVERED.getCode().equals(status)) {
            this.transactionCallBackService.execute(() -> {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString((Object)transferOrderEo.getTransferOrderNo()));
                this.mqService.transferDeliveryProcessor(messageVo);
                log.info("\u8c03\u62e8\u5355\u5df2\u53d1\u8d27,\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
            });
        }
        if (CsTransferOrderEnum.Status.FINISH.getCode().equals(status)) {
            this.transactionCallBackService.execute(() -> {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString((Object)transferOrderEo.getTransferOrderNo()));
                this.mqService.transferCompleteProcessor(messageVo);
                log.info("\u8c03\u62e8\u5355\u5b8c\u6210,\u5e7f\u64ad\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
            });
        }
        try {
            if (status.equals(CsTransferOrderEnum.Status.FINISH.getCode()) && (transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode()))) {
                this.transactionCallBackService.execute(() -> {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)JSON.toJSONString((Object)transferOrderEo.getPreOrderNo()));
                    this.mqService.transferCompleteNeedCreateNextProcessor(messageVo);
                    log.info("\u8c03\u62e8\u5355\u5b8c\u6210,\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u7279\u6b8a\u5904\u7406,\u6d88\u606f\u53d1\u9001\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(messageVo));
                });
            }
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u7279\u6b8a\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private CsTransferOrderEo getCsTransferOrderEo(String transferOrderNo) {
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue(Objects.nonNull(transferOrderEo), "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u5355\u636e,\u5355\u636e\u53f7:" + transferOrderNo);
        return transferOrderEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("\u8c03\u62e8\u5355\u56de\u8c03deliveryReceiveNoticeOrderCallBack");
        if (callBackContext.getInFlag().booleanValue()) {
            // empty if block
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inOutNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("\u8c03\u62e8\u5355\u56de\u8c03inOutNoticeOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
        if (CsPcpBusinessTypeEnum.cAllotList().contains(transferOrderEo.getType())) {
            log.info("E3\u76f8\u5173\u8c03\u62e8\u4e0d\u9700\u8981\u56de\u8c03");
            return true;
        }
        boolean sendWms = callBackContext.getSendWms();
        if (callBackContext.getInFlag().booleanValue()) {
            List inOutResultOrderEos;
            String status = CsTransferOrderEnum.Status.WAIT_RECEIVE.getCode();
            this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
            if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(transferOrderEo.getType())) {
                return true;
            }
            List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
            AssertUtils.notEmpty((Collection)physicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
            PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
            if (YesNoHelper.isYes((Integer)physicsWarehouseEo.getIsLogistics())) {
                return true;
            }
            if (!sendWms && (inOutResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(callBackContext.getRelevanceNo())).stream().noneMatch(r -> "in".equals(r.getOrderType()))) {
                this.generateWmsInCallbackOrder(callBackContext, transferOrderEo);
            }
        } else {
            List inOutResultOrderEos;
            String status = CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode();
            this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
            if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(transferOrderEo.getType())) {
                return true;
            }
            List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(transferOrderEo.getOutPhysicsWarehouseCode());
            AssertUtils.notEmpty((Collection)physicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
            PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
            if (YesNoHelper.isYes((Integer)physicsWarehouseEo.getIsLogistics())) {
                return true;
            }
            if (!sendWms && (inOutResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(callBackContext.getRelevanceNo())).stream().noneMatch(r -> "in".equals(r.getOrderType()))) {
                this.generateWmsOutCallbackOrder(callBackContext, transferOrderEo);
            }
        }
        return true;
    }

    @Override
    public Boolean sendWms(InOutNoticeOrderEo outNoticeOrderEo) {
        log.info("\u8c03\u62e8\u5355\u6821\u9a8c\u662f\u5426\u9700\u63a8\u9001wms\uff1a{}", (Object)JSON.toJSONString((Object)outNoticeOrderEo));
        CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(outNoticeOrderEo.getRelevanceNo());
        if (CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.ROUTE_INTERNAL_ALLOT.getCode().equals(transferOrderEo.getType())) {
            log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613/\u5728\u9014\u5185\u90e8\u4ea4\u6613(\u4f70\u50b2\u603b\u4ee3\u7406\u6a21\u5f0f)/\u5728\u9014\u8c03\u62e8\u4e0d\u63a8\u9001wms");
            return false;
        }
        if (outNoticeOrderEo.getOrderType().equals("out") && (transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.CC_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.CB_ALLOT.getCode()))) {
            log.info("\u51fa\u5e93\u5355\u901a\u77e5\u5355\uff0cCC\u3001CB\u8c03\u62e8\u51fa\u4e0d\u63a8\u9001wms");
            return false;
        }
        if (outNoticeOrderEo.getOrderType().equals("in") && (transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.CC_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.BC_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.CLAIM_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.BORROW_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode()))) {
            log.info("\u5165\u5e93\u901a\u77e5\u5355CC\u3001CB\u8c03\u62e8\u51fa\u4e0d\u63a8\u9001wms");
            return false;
        }
        if (StringUtils.equals((CharSequence)transferOrderEo.getInPhysicsWarehouseCode(), (CharSequence)transferOrderEo.getOutPhysicsWarehouseCode()) && "in".equals(outNoticeOrderEo.getOrderType()) && !CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode().equals(transferOrderEo.getType()) && !CsPcpBusinessTypeEnum.CB_ALLOT.getCode().equals(transferOrderEo.getType())) {
            log.info("\u8c03\u62e8\u5355\u5165\u5e93\u7269\u7406\u4ed3\u548c\u51fa\u5e93\u7269\u6d41\u4ed3\u76f8\u540c\uff0c\u4e14\u672a\u5165\u5e93\u901a\u77e5\u5355\uff0c\u8c03\u62e8\u7c7b\u578b\u4e0d\u7b49\u4e8e\u5e93\u5b58\u8c03\u62e8\u5355\uff08\u8c03\u62e8\u5165\u5e93\uff09/CB\u8c03\u62e8\u4e0d\u63a8\u9001wms");
            return false;
        }
        String logicWarehouseCode = "";
        String physicsWarehouseCode = "";
        if ("in".equals(outNoticeOrderEo.getOrderType())) {
            logicWarehouseCode = outNoticeOrderEo.getInLogicWarehouseCode();
            physicsWarehouseCode = outNoticeOrderEo.getInPhysicsWarehouseCode();
        } else {
            logicWarehouseCode = outNoticeOrderEo.getOutLogicWarehouseCode();
            physicsWarehouseCode = outNoticeOrderEo.getOutPhysicsWarehouseCode();
        }
        AssertUtils.notBlank((String)logicWarehouseCode, (String)"\u901a\u77e5\u5355\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo csLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(logicWarehouseCode);
        AssertUtils.notNull((Object)csLogicWarehouseEo, (String)"\u903b\u8f91\u4ed3[%s]\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[]{logicWarehouseCode});
        if (YesNoEnum.YES.getValue().equals(csLogicWarehouseEo.getIsVirtual())) {
            log.info("{}\u903b\u8f91\u4ed3\u4e3a\u865a\u62df\u903b\u8f91\u4ed3\u4e0d\u63a8\u9001wms", (Object)logicWarehouseCode);
            return false;
        }
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(physicsWarehouseCode);
        AssertUtils.notEmpty((Collection)physicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
        if (YesNoHelper.isYes((Integer)physicsWarehouseEo.getIsLogistics())) {
            log.info("{}\u7269\u7406\u4ed3\u4e3a\u7269\u6d41\u4ed3\u4e0d\u63a8\u9001wms", (Object)physicsWarehouseCode);
            return false;
        }
        return true;
    }

    private void generateWmsInCallbackOrder(CsOrderBusinessCallBackContext callBackContext, CsTransferOrderEo transferOrderEo) {
        log.info("generateInOutOrder==>\u8c03\u62e8\u5355\u7c7b\u578b\u56de\u8c03,\u6a21\u62dfWMS\u56de\u8c03\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355");
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsOrderReqDto basics = callBackContext.getCsBasicsOrderReqDto();
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        List sourceDetail = basics.getOrderBasicsDetailReqDtoList();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(basics.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setEnableAdjustInTransit(Boolean.TRUE);
        csBasicsReceiveReqDto.setAdjustInTransitAutoAudit(Boolean.TRUE);
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : sourceDetail) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setExpireTime(detailReqDto.getExpireTime());
            inSendBackDetailReqDto.setProduceTime(detailReqDto.getProduceTime());
            inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getTradeOrderItemId());
            inSendBackDetailReqDto.setWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
    }

    private void generateWmsOutCallbackOrder(CsOrderBusinessCallBackContext callBackContext, CsTransferOrderEo transferOrderEo) {
        log.info("generateInOutOrder==>\u8c03\u62e8\u5355\u7c7b\u578b\u56de\u8c03,\u6a21\u62dfWMS\u56de\u8c03\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355");
        String physicWarehouseCode = transferOrderEo.getOutPhysicsWarehouseCode();
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsOrderReqDto basics = callBackContext.getCsBasicsOrderReqDto();
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        List sourceDetail = basics.getOrderBasicsDetailReqDtoList();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(basics.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setAdjustInTransitAutoAudit(Boolean.TRUE);
        csBasicsReceiveReqDto.setEnableAdjustInTransit(Boolean.TRUE);
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : sourceDetail) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setWarehouseCode(physicWarehouseCode);
            inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getTradeOrderItemId());
            inSendBackDetailReqDto.setExpireTime(detailReqDto.getExpireTime());
            inSendBackDetailReqDto.setProduceTime(detailReqDto.getProduceTime());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveOut(csBasicsReceiveReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("\u8c03\u62e8\u5355\u56de\u8c03inOutResultOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        return true;
    }

    private String judgeStatus(CsOrderBusinessCallBackContext callBackContext) {
        String status = callBackContext.getPortionFlag() != false ? CsTransferOrderEnum.Status.PORTION_RECEIVE.getCode() : CsTransferOrderEnum.Status.FINISH.getCode();
        log.info("judgeStatus: {}, {}", (Object)LogUtils.buildLogContent(callBackContext), (Object)status);
        return status;
    }

    private String judgeOutStatus(CsOrderBusinessCallBackContext callBackContext) {
        String status = CsTransferOrderEnum.Status.PORTION_DELIVERY.getCode();
        if (!callBackContext.getPortionFlag().booleanValue()) {
            CsTransferOrderEo csTransferOrderEo = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
            status = CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(csTransferOrderEo.getSubType()) || CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode().equals(csTransferOrderEo.getSubType()) ? CsTransferOrderEnum.Status.FINISH.getCode() : CsTransferOrderEnum.Status.DELIVERED.getCode();
        }
        log.info("judgeOutStatus: {}, {}", (Object)LogUtils.buildLogContent(callBackContext), (Object)status);
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("\u8c03\u62e8\u5355\u56de\u8c03deliveryReceiveResultOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        if (callBackContext.getInFlag().booleanValue()) {
            String status = this.judgeStatus(callBackContext);
            this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
            CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
            InOutResultOrderEo inOutResultOrderEo = callBackContext.getInOutResultOrderEo();
            AssertUtils.notNull((Object)inOutResultOrderEo, (String)"\u51fa/\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\u4e3a\u7a7a");
            this.transferOutCompleteSendMq(transferOrderEo, inOutResultOrderEo.getDocumentNo());
        } else {
            String status = this.judgeOutStatus(callBackContext);
            this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
            this.generateReceiveNoticeOrder(callBackContext);
        }
        return true;
    }

    private void generateReceiveNoticeOrder(CsOrderBusinessCallBackContext callBackContext) {
        CsBasicsOrderReqDto dto;
        log.info("generateReceiveNoticeOrder==>\u8c03\u62e8\u5355\u56de\u8c03,\u751f\u6210\u5165\u5e93\u901a\u77e5\u5355");
        final CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
        if (CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(transferOrderEo.getSubType()) || CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(transferOrderEo.getSubType()) || CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode().equals(transferOrderEo.getSubType())) {
            return;
        }
        log.info("generateReceiveNoticeOrder==>\u8c03\u62e8\u5355\u56de\u8c03,\u751f\u6210\u6536\u8d27\u901a\u77e5\u5355\uff1a{}", (Object)JSON.toJSONString((Object)callBackContext));
        HashMap reqDtoMap = new HashMap();
        if (ObjectUtils.isNotEmpty((Object)callBackContext.getCsBasicsOrderReqDto()) && CollectionUtils.isNotEmpty((Collection)(dto = callBackContext.getCsBasicsOrderReqDto()).getOrderBasicsDetailReqDtoList())) {
            List orderBasicsDetailReqDtoList = dto.getOrderBasicsDetailReqDtoList();
            Map map = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(o -> o.getLongCode() + "_" + o.getBatch(), Function.identity(), (o, o1) -> o));
            reqDtoMap.putAll(map);
        }
        InOutResultOrderEo inOutResultOrderEo = callBackContext.getInOutResultOrderEo();
        AssertUtils.notEmpty((Object)inOutResultOrderEo, (String)"\u51fa\u5e93\u7ed3\u679c\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        List receiveDeliveryNoticeOrderEos = this.receiveDeliveryResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ReceiveDeliveryResultOrderEo.class).eq(ReceiveDeliveryResultOrderEo::getPreOrderNo, (Object)inOutResultOrderEo.getDocumentNo())).eq(ReceiveDeliveryResultOrderEo::getOrderType, (Object)"delivery")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ReceiveDeliveryResultOrderEo deliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)receiveDeliveryNoticeOrderEos.get(0);
        AssertUtils.notEmpty((Collection)receiveDeliveryNoticeOrderEos, (String)"\u53d1\u8d27\u7ed3\u679c\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        List inOutResultOrderDetailEos = callBackContext.getInOutResultOrderDetailEos();
        AssertUtils.notEmpty((Collection)inOutResultOrderDetailEos, (String)"\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(deliveryResultOrderEo.getDocumentNo());
        receiveDeliveryNoticeOrderFacadeBo.setExtension(deliveryResultOrderEo.getExtension());
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(deliveryResultOrderEo.getExternalOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(transferOrderEo.getType());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(transferOrderEo.getTransferOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(transferOrderEo.getType());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseName(transferOrderEo.getInLogicWarehouseName());
        receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.IN_ALLOT.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setRemark(deliveryResultOrderEo.getRemark());
        if (CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode().equals(transferOrderEo.getType())) {
            receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(Boolean.valueOf(true));
        }
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ReceiveDeliveryNoticeOrderContext relContext = (ReceiveDeliveryNoticeOrderContext)context;
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = relContext.getReceiveDeliveryNoticeOrderEo();
                    CsTransferOrderCallBackServiceImpl.this.transferOrderWrapperHelper.wrapperTransferOrderDelivery(receiveDeliveryNoticeOrderEo, transferOrderEo);
                    CsTransferOrderCallBackServiceImpl.this.orderPreemptWrapperHelper.copyDeliveryToContext(relContext, receiveDeliveryNoticeOrderEo);
                    if (CsPcpBusinessTypeEnum.ALLOT_BC_EFFICACY.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.CLAIM_ALLOT.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.BORROW_ALLOT.getCode().equals(transferOrderEo.getType())) {
                        relContext.setSendWms(false);
                    }
                }
                if (context instanceof InOutNoticeOrderContext) {
                    log.info("generateReceiveNoticeOrder,InOutNoticeOrderContext:{}", (Object)JSON.toJSONString((Object)context));
                    InOutNoticeOrderEo inOutNoticeOrderEo = ((InOutNoticeOrderContext)context).getInOutNoticeOrderEo();
                    Boolean sendWms = CsTransferOrderCallBackServiceImpl.this.sendWms(inOutNoticeOrderEo);
                    context.setSendWms(sendWms.booleanValue());
                    CsTransferOrderCallBackServiceImpl.this.getExpireTime(context);
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseNoticeCallBack(context);
                    CsTransferOrderCallBackServiceImpl.this.inOutNoticeOrderCallBack(csOrderBusinessCallBackContext);
                }
            }
        });
        receiveDeliveryNoticeOrderFacadeBo.setCompleteCallBack(context -> {
            log.info("transferOrder CompleteCallBack context: {}", (Object)LogUtils.buildLogContent(context));
            if (!context.isSendWms()) {
                return;
            }
            if (context instanceof InOutResultOrderContext) {
                InOutResultOrderContext inOutResultOrderContext = (InOutResultOrderContext)context;
                CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseNoticeCallBack(context);
                csOrderBusinessCallBackContext.setPortionFlag(Boolean.valueOf(false));
                csOrderBusinessCallBackContext.setInOutResultOrderDetailEos(inOutResultOrderContext.getInOutResultOrderDetailEoList());
                csOrderBusinessCallBackContext.setInOutResultOrderEo(inOutResultOrderContext.getInOutResultOrderEo());
                this.deliveryReceiveResultOrderCallBack(csOrderBusinessCallBackContext);
            }
        });
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(inOutResultOrderDetailEos.stream().map(re -> {
            BaseOrderDetailReqDto basic = (BaseOrderDetailReqDto)BeanUtil.copyProperties((Object)re, BaseOrderDetailReqDto.class, (String[])new String[0]);
            basic.setSkuCode(re.getSkuCode());
            basic.setSkuName(Optional.ofNullable(re.getSkuName()).filter(StringUtil::isNotBlank).orElse(re.getSkuName()));
            return basic;
        }).collect(Collectors.toList()));
        this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        this.transactionCallBackService.execute(() -> this.transferOutCompleteSendMq(transferOrderEo, deliveryResultOrderEo.getPreOrderNo()));
    }

    private void getExpireTime(BaseOrderBaseContext context) {
        String relevanceNo = context.getRelevanceNo();
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderEo.class).eq(InOutNoticeOrderEo::getRelevanceNo, (Object)relevanceNo)).eq(InOutNoticeOrderEo::getOrderType, (Object)"out")).ne(InOutNoticeOrderEo::getOrderStatus, (Object)BaseOrderStatusEnum.ONO_CANCEL.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos)) {
            String documentNo = ((InOutNoticeOrderEo)inOutNoticeOrderEos.get(0)).getDocumentNo();
            List inOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderDetailEo.class).eq(InOutNoticeOrderDetailEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)inOutNoticeOrderDetailEos, (String)"\u901a\u77e5\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
            Map skuBatchMap = inOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
            List inOutNoticeOrderDetailEoList = ((InOutNoticeOrderContext)context).getInOutNoticeOrderDetailEoList();
            for (InOutNoticeOrderDetailEo detailEo : inOutNoticeOrderDetailEoList) {
                InOutNoticeOrderDetailEo noticeOrderDetailEo;
                String key = detailEo.getSkuCode() + "_" + detailEo.getBatch();
                if (!skuBatchMap.containsKey(key) || null == (noticeOrderDetailEo = (InOutNoticeOrderDetailEo)skuBatchMap.get(key))) continue;
                if (null != noticeOrderDetailEo.getExpireTime()) {
                    detailEo.setExpireTime(noticeOrderDetailEo.getExpireTime());
                }
                if (null == noticeOrderDetailEo.getProduceTime()) continue;
                detailEo.setProduceTime(noticeOrderDetailEo.getProduceTime());
            }
            List orderBasicsDetailReqDtoList = context.getOrderBasicsDetailReqDtoList();
            for (BaseOrderDetailReqDto detailReqDto : orderBasicsDetailReqDtoList) {
                InOutNoticeOrderDetailEo noticeOrderDetailEo;
                String key = detailReqDto.getSkuCode() + "_" + detailReqDto.getBatch();
                if (!skuBatchMap.containsKey(key) || null == (noticeOrderDetailEo = (InOutNoticeOrderDetailEo)skuBatchMap.get(key))) continue;
                if (null != noticeOrderDetailEo.getExpireTime()) {
                    detailReqDto.setExpireTime(noticeOrderDetailEo.getExpireTime());
                }
                if (null == noticeOrderDetailEo.getProduceTime()) continue;
                detailReqDto.setProduceTime(noticeOrderDetailEo.getProduceTime());
            }
            context.setOrderBasicsDetailReqDtoList(orderBasicsDetailReqDtoList);
            ((InOutNoticeOrderContext)context).setInOutNoticeOrderDetailEoList(inOutNoticeOrderDetailEoList);
            log.info("InOutNoticeOrderContext\u8865\u5145\u5b8c\u751f\u4ea7\u65e5\u671f\u548c\u8fc7\u671f\u65e5\u671f:{}", (Object)JSON.toJSONString((Object)context));
        }
    }

    private void transferOutCompleteSendMq(CsTransferOrderEo transferOrderEo, String documentNo) {
        boolean noSend = StringUtils.equals((CharSequence)transferOrderEo.getInPhysicsWarehouseCode(), (CharSequence)transferOrderEo.getOutPhysicsWarehouseCode());
        if (!noSend) {
            this.transactionCallBackService.execute(() -> {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)documentNo);
                this.mqService.transferOutCompleteProcessor(messageVo);
                log.info("\u8c03\u62e8\u5355\u51fa/\u5165\u5e93\u5b8c\u6210,\u63a8\u9001\u6d88\u606f:{}", (Object)LogUtils.buildLogContent(messageVo));
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("\u8c03\u62e8\u5355\u56de\u8c03relieveOverchargeCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("\u8c03\u62e8\u5355\u56de\u8c03overchargeAdjustCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        return true;
    }

    @Override
    public void updateMainOrderStatus(String relevanceNo, boolean inFlag) {
        String status = CsTransferOrderEnum.Status.HANG_UP.getCode();
        this.updateOrderStatus(relevanceNo, status);
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
        this.updateOrderStatus(relevanceNo, CsTransferOrderEnum.Status.CLOSED.getCode());
    }

    @Override
    public void inInventoryDeal(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag) {
        if (inFlag) {
            this.inTransitIn(csInOutMatchRespDto, InOutNoticeOrderEo2);
        }
    }

    private void inTransitIn(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        TransferInDto param = new TransferInDto();
        param.setSourceNo(InOutNoticeOrderEo2.getRelevanceNo());
        param.setSourceType(InOutNoticeOrderEo2.getBusinessType());
        param.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        param.setExternalOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInOutMatchRespDto.getBatchInventoryList())) {
            for (CsInOutBasicsOrderDetailRespDto detailReqDto : csInOutMatchRespDto.getBatchInventoryList()) {
                CalcDetailDto detailParam = new CalcDetailDto();
                BigDecimal balance = BigDecimalUtils.abs((BigDecimal)detailReqDto.getBalance());
                if (BigDecimalUtils.eqZero((BigDecimal)balance).booleanValue()) continue;
                detailParam.setNum(balance);
                detailParam.setSkuCode(detailReqDto.getLongCode());
                String warehouseCode = StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getInLogicWarehouseCode()) ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setBatch(detailReqDto.getBatch());
                detailParam.setExpireDate(detailReqDto.getExpireTime());
                detailParam.setProduceDate(detailReqDto.getProduceTime());
                detailParams.add(detailParam);
            }
        }
        param.setDetails((List)detailParams);
        if (CollectionUtils.isNotEmpty((Collection)detailParams)) {
            this.calcInventoryService.transferIn(param);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        String status = CsTransferOrderEnum.Status.CANCELED.getCode();
        if (callBackContext.getInFlag().booleanValue() && callBackContext.getOnlyNodeCancel().booleanValue()) {
            status = CsTransferOrderEnum.Status.DELIVERED.getCode();
        }
        this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
        log.info("\u8c03\u62e8\u5355\u62fc\u63a5\u6536\u8d27\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)dto.getRelevanceNo())).one();
        LogicWarehouseEo csLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(transferOrderEo.getInLogicWarehouseCode());
        if (transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.BC_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode()) || transferOrderEo.getType().equals(CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode())) {
            this.BCAllotContactsInfo(dto, transferOrderEo);
            return;
        }
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getInPhysicsWarehouseCode()) || CsWarehouseTypeEnum.TCBJ_C.getCode().equals(csLogicWarehouseEo.getWarehouseType())) {
            try {
                WmsStockOutOrderReqDto.ReceiverInfo receiverInfo = (WmsStockOutOrderReqDto.ReceiverInfo)JSON.parseObject((String)transferOrderEo.getExtension(), WmsStockOutOrderReqDto.ReceiverInfo.class);
                dto.setReceiverInfo(receiverInfo);
            }
            catch (Exception ex) {
                log.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
            return;
        }
        WarehouseAddressEo csWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
        if (null != csWarehouseAddressEo) {
            WmsStockOutOrderReqDto.ReceiverInfo receiverInfo = new WmsStockOutOrderReqDto.ReceiverInfo();
            CubeBeanUtils.copyProperties((Object)receiverInfo, (Object)csWarehouseAddressEo, (String[])new String[0]);
            receiverInfo.setLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
            receiverInfo.setOrganizationCode(csLogicWarehouseEo.getCargoEscheatageId() + "");
            dto.setReceiverInfo(receiverInfo);
        }
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
    }

    private void BCAllotContactsInfo(WmsStockOutOrderReqDto dto, CsTransferOrderEo eo) {
        log.info("BC\u8c03\u62e8\u6536\u83b7\u4fe1\u606f\u4ece\u8c03\u62e8\u5355\u5355\u636e\u91cc\u83b7\u53d6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        WmsStockOutOrderReqDto.ReceiverInfo receiverInfo = new WmsStockOutOrderReqDto.ReceiverInfo();
        receiverInfo.setProvince(eo.getProvince());
        receiverInfo.setProvinceCode(eo.getProvinceCode());
        receiverInfo.setCity(eo.getCity());
        receiverInfo.setCityCode(eo.getCityCode());
        receiverInfo.setDistrict(eo.getArea());
        receiverInfo.setDistrictCode(eo.getAreaCode());
        receiverInfo.setDetailAddress(eo.getAddress());
        receiverInfo.setContacts(eo.getContact());
        receiverInfo.setPhone(eo.getContactPhone());
        dto.setReceiverInfo(receiverInfo);
    }
}

