/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionNotReleaseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionNotReleaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionNotReleaseService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionNotReleaseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionNotReleaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionNotReleaseServiceImpl
implements IInspectionNotReleaseService {
    @Resource
    private InspectionNotReleaseDas inspectionNotReleaseDas;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveInspectionNotRelease(List<Long> preemptIds) {
        List preemptionEos = this.inventoryPreemptionDomain.getMapper().selectBatchIds(preemptIds);
        preemptionEos.removeIf(o -> StringUtils.equals((CharSequence)EnableDisableEnum.DISABLE.getCode(), (CharSequence)o.getValid()));
        AssertUtils.notEmpty((Collection)preemptionEos, (String)"\u6ca1\u6709\u6709\u6548\u9884\u5360\u8bb0\u5f55");
        String skuCode = ((InventoryPreemptionEo)preemptionEos.get(0)).getSkuCode();
        String batch = ((InventoryPreemptionEo)preemptionEos.get(0)).getBatch();
        List inspectionNotReleaseEos = this.inspectionNotReleaseDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionNotReleaseEo.class).eq(InspectionNotReleaseEo::getSkuCode, (Object)skuCode)).eq(InspectionNotReleaseEo::getBatch, (Object)batch)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)inspectionNotReleaseEos)) {
            List deleteIds = inspectionNotReleaseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.inspectionNotReleaseDas.getMapper().deleteBatchIds(deleteIds);
        }
        ArrayList eos = Lists.newArrayList();
        for (InventoryPreemptionEo preemptionEo : preemptionEos) {
            InspectionNotReleaseEo eo = new InspectionNotReleaseEo();
            eo.setBusinessNo(preemptionEo.getSourceNo());
            eo.setNotReleaseNum(preemptionEo.getPreemptNum());
            eo.setRemark(preemptionEo.getRemark());
            eo.setValid(EnableDisableEnum.ENABLE.getCode());
            eo.setBusinessType(preemptionEo.getSourceType());
            eo.setSkuCode(preemptionEo.getSkuCode());
            eo.setBatch(preemptionEo.getBatch());
            eos.add(eo);
        }
        this.inspectionNotReleaseDas.insertBatch((List)eos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearInspectionNotRelease(String longCode, String batch) {
        List inspectionNotReleaseEos = this.inspectionNotReleaseDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InspectionNotReleaseEo.class).eq(InspectionNotReleaseEo::getSkuCode, (Object)longCode)).eq(InspectionNotReleaseEo::getBatch, (Object)batch)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)inspectionNotReleaseEos)) {
            List deleteIds = inspectionNotReleaseEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.inspectionNotReleaseDas.getMapper().deleteBatchIds(deleteIds);
        }
    }

    @Override
    public InspectionNotReleaseRespDto queryById(Long id) {
        InspectionNotReleaseEo inspectionNotReleaseEo = (InspectionNotReleaseEo)this.inspectionNotReleaseDas.selectByPrimaryKey(id);
        InspectionNotReleaseRespDto inspectionNotReleaseRespDto = new InspectionNotReleaseRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionNotReleaseEo, (BaseVo)inspectionNotReleaseRespDto);
        return inspectionNotReleaseRespDto;
    }

    @Override
    public PageInfo<InspectionNotReleaseRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionNotReleaseReqDto inspectionNotReleaseReqDto = (InspectionNotReleaseReqDto)JSON.parseObject((String)filter, InspectionNotReleaseReqDto.class);
        InspectionNotReleaseEo inspectionNotReleaseEo = new InspectionNotReleaseEo();
        DtoHelper.dto2Eo((BaseVo)inspectionNotReleaseReqDto, (BaseEo)inspectionNotReleaseEo);
        PageInfo eoPageInfo = this.inspectionNotReleaseDas.selectPage((BaseEo)inspectionNotReleaseEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionNotReleaseRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

