/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IInventoryBizDateService;
import com.dtyunxi.yundt.cube.center.inventory.constant.InventoryBizDateBizTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.AdjustmentInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsOtherStorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.AdjustmentInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsOtherStorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.InventoryBizDateReqDto;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InventoryBizDateServiceImpl
implements IInventoryBizDateService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryBizDateServiceImpl.class);
    @Resource
    private CsInPlannedOrderDas csInPlannedOrderDas;
    @Resource
    private CsOutPlannedOrderDas csOutPlannedOrderDas;
    @Resource
    private CsTransferOrderDas csTransferOrderDas;
    @Resource
    private CsOtherStorageOrderDas csOtherStorageOrderDas;
    @Resource
    private AdjustmentInventoryDas adjustmentInventoryDas;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;

    @Override
    public void updateBizDate(InventoryBizDateReqDto reqDto) {
        logger.info("\u66f4\u65b0\u5355\u636e\u4e1a\u52a1\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)reqDto.getId()) && StringUtils.isBlank((CharSequence)reqDto.getNo())) {
            throw new BizException("-1", "\u5355\u636eID\u4e0e\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        switch (InventoryBizDateBizTypeEnum.getStatusByCode((String)reqDto.getBizType())) {
            case CS_IN_PLANNED_ORDER: {
                this.csInPlannedOrder(reqDto);
                break;
            }
            case CS_OUT_PLANNED_ORDER: {
                this.csOutPlannedOrder(reqDto);
                break;
            }
            case CS_TRANSFER_ORDER: {
                this.csTransferOrder(reqDto);
                break;
            }
            case CS_OTHER_STORAGE_ORDER: {
                this.csOtherStorageOrder(reqDto);
                break;
            }
            case CS_ADJUSTMENT_ORDER: {
                this.csAdjustmentOrder(reqDto);
                break;
            }
            case cs_out_notice_order: {
                this.csOutNoticeOrder(reqDto);
                break;
            }
            case cs_out_result_order: {
                this.csOutResultOrder(reqDto);
                break;
            }
            case CS_DELIVERY_NOTICE_ORDER: {
                this.csDeliveryNoticeOrder(reqDto);
                break;
            }
            case CS_DELIVERY_RESULT_ORDER: {
                this.csDeliveryResultOrder(reqDto);
                break;
            }
            default: {
                throw new BizException("-1", "\u8bf7\u6c42\u7c7b\u578b\u5f02\u5e38");
            }
        }
    }

    private void csDeliveryResultOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u6536\u53d1\u7ed3\u679c\u5355");
        ExtQueryChainWrapper filter = this.receiveDeliveryResultOrderDomain.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"document_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        ReceiveDeliveryResultOrderEo one = (ReceiveDeliveryResultOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        ReceiveDeliveryResultOrderEo update = new ReceiveDeliveryResultOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)update);
    }

    private void csDeliveryNoticeOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u6536\u53d1\u901a\u77e5\u5355");
        ExtQueryChainWrapper filter = this.receiveDeliveryNoticeOrderDomain.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"document_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        ReceiveDeliveryNoticeOrderEo one = (ReceiveDeliveryNoticeOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        ReceiveDeliveryNoticeOrderEo update = new ReceiveDeliveryNoticeOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)update);
    }

    private void csOutResultOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u51fa\u5165\u7ed3\u679c\u5355");
        ExtQueryChainWrapper filter = this.inOutResultOrderDomain.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"document_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        InOutResultOrderEo one = (InOutResultOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        InOutResultOrderEo update = new InOutResultOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.inOutResultOrderDomain.updateSelective((BaseEo)update);
    }

    private void csOutNoticeOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u51fa\u5165\u901a\u77e5\u5355");
        ExtQueryChainWrapper filter = this.inOutNoticeOrderDomain.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"document_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        InOutNoticeOrderEo one = (InOutNoticeOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        InOutNoticeOrderEo update = new InOutNoticeOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)update);
    }

    private void csAdjustmentOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u76d8\u70b9\u3001\u8c03\u6574");
        ExtQueryChainWrapper filter = this.adjustmentInventoryDas.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"adjustment_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        AdjustmentInventoryEo one = (AdjustmentInventoryEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        AdjustmentInventoryEo update = new AdjustmentInventoryEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.adjustmentInventoryDas.updateSelective((BaseEo)update);
    }

    private void csOtherStorageOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u5176\u4ed6\u5355");
        ExtQueryChainWrapper filter = this.csOtherStorageOrderDas.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"storage_order_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        CsOtherStorageOrderEo one = (CsOtherStorageOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        CsOtherStorageOrderEo update = new CsOtherStorageOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.csOtherStorageOrderDas.updateSelective((BaseEo)update);
    }

    private void csTransferOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u8c03\u62e8");
        ExtQueryChainWrapper filter = this.csTransferOrderDas.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"transfer_order_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        CsTransferOrderEo one = (CsTransferOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        CsTransferOrderEo update = new CsTransferOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.csTransferOrderDas.updateSelective((BaseEo)update);
    }

    private void csOutPlannedOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u8ba1\u5212\u51fa");
        ExtQueryChainWrapper filter = this.csOutPlannedOrderDas.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"order_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        CsOutPlannedOrderEo one = (CsOutPlannedOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        CsOutPlannedOrderEo update = new CsOutPlannedOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.csOutPlannedOrderDas.updateSelective((BaseEo)update);
    }

    private void csInPlannedOrder(InventoryBizDateReqDto reqDto) {
        logger.info("\u8ba1\u5212\u5165");
        ExtQueryChainWrapper filter = this.csInPlannedOrderDas.filter();
        filter.eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId());
        filter.eq(StringUtils.isNotBlank((CharSequence)reqDto.getNo()), (Object)"order_no", (Object)reqDto.getNo());
        filter.eq((Object)"dr", (Object)0);
        CsInPlannedOrderEo one = (CsInPlannedOrderEo)filter.one();
        if (!ObjectUtil.isNotEmpty((Object)one)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        CsInPlannedOrderEo update = new CsInPlannedOrderEo();
        update.setId(one.getId());
        update.setBizDate(reqDto.getBizDate());
        this.csInPlannedOrderDas.updateSelective((BaseEo)update);
    }
}

