/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.warehouse;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLogicWarehouseQueryApiImpl")
public class CsLogicWarehouseQueryApiImpl
implements ICsLogicWarehouseQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseQueryApiImpl.class);
    @Autowired
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Autowired
    private ICsWarehouseAddressQueryService csWarehouseAddressQueryService;

    public RestResponse<CsLogicWarehouseRespDto> queryByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsLogicWarehouseRespDto dto = this.csLogicWarehouseQueryService.selectByPrimaryKey(id);
        dto.setWarehouseIsNegative(dto.getNegativeFlag());
        AssertUtil.isTrue(dto != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        Long warehouseId = dto.getId();
        WarehouseAddressEo csWarehouseAddressEo = this.csWarehouseAddressQueryService.selectByWarehouseId(warehouseId);
        CsWarehouseAddressRespDto warehouseAddressRespDto = null;
        if (null != csWarehouseAddressEo) {
            warehouseAddressRespDto = new CsWarehouseAddressRespDto();
            CubeBeanUtils.copyProperties((Object)warehouseAddressRespDto, (Object)csWarehouseAddressEo, (String[])new String[0]);
        }
        dto.setWarehouseAddress(warehouseAddressRespDto);
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<CsLogicWarehouseRespDto>> queryByPage(CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.csLogicWarehouseQueryService.queryByPage(queryDto));
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryByParam(CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(this.csLogicWarehouseQueryService.queryByParam(queryDto));
    }

    public RestResponse<CsLogicWarehouseRespDto> queryReturnWarehouseByOrganizationId(Long organizationId) {
        logger.info("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u5173\u8054\u7684\u9ed8\u8ba4\u9000\u8d27\u4ed3\u4fe1\u606f\uff1a[{}]", (Object)organizationId);
        return new RestResponse((Object)this.csLogicWarehouseQueryService.queryReturnWarehouseByOrganizationId(organizationId));
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryList(List<String> warehouseCodes) {
        return new RestResponse(this.csLogicWarehouseQueryService.queryList(warehouseCodes));
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryListAll() {
        return new RestResponse(this.csLogicWarehouseQueryService.queryList(null));
    }
}

