/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONArray;
import com.aliyuncs.utils.StringUtils;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryDetailMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderUnhookFacadeBo;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInResultOrderService")
public class CsInResultOrderServiceImpl
implements ICsInResultOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsInResultOrderServiceImpl.class);
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    ICsInResultOrderQueryService csInResultOrderQueryService;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    RepeatFilter repeatFilter;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Autowired
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    private ICommonsMqService mqService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsInResultOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u5165\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("InResult:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        InOutResultOrderEo inResultOrderEo = new InOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)inResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        String orderNo = this.generateCode();
        inResultOrderEo.setDocumentNo(orderNo);
        inResultOrderEo.setOrderStatus(BaseOrderStatusEnum.RECEIVE_FINISH.getCode());
        inResultOrderEo.setExtension(com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.inOutResultOrderDomain.insert((BaseEo)inResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsInResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(orderNo);
            detailEoList.add(detailEo);
        }
        this.inOutResultOrderDetailDomain.insertBatch((List)detailEoList);
        return inResultOrderEo.getId();
    }

    private void dataValid(CsInResultOrderAddReqDto addReqDto) {
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsInResultOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List cargoEoList = this.itemSkuProxy.queryBySkuCodes(cargoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)cargoEoList), "\u8d27\u54c1\u672a\u914d\u7f6e");
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, ItemSkuDto> cargoMap = cargoEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
        for (CsInResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ItemSkuDto cargoEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == cargoEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(cargoEo.getId());
            detailAddReqDto.setCargoName(cargoEo.getSkuName());
        }
    }

    private void preValid(CsInResultOrderAddReqDto addReqDto) {
        List oldList = this.inOutResultOrderDomain.queryByRelevanceNo(addReqDto.getRelevanceNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (InOutResultOrderEo resultOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.RECEIVE_CANCEL.getCode().equals(resultOrderEo.getOrderStatus()), CsInventoryExceptionCode.SUCCESS_CODE.getCode(), CsInventoryExceptionCode.SUCCESS_CODE.getMsg());
            }
        }
    }

    @Override
    public void update(Long id, CsInResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inOutResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutResultOrderEo eo = this.csInResultOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inOutResultOrderDomain.logicDeleteById(id);
    }

    private String generateCode() {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.IN_RESULT_ORDER.getCode());
        return generateCodeService.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer updateShippingCompany(InOutResultOrderDto dto) {
        logger.info("updateShippingCompany-->dto:{}", (Object)LogUtils.buildLogContent(dto));
        AssertUtil.isTrue(dto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(StringUtils.isEmpty((CharSequence)dto.getRelevanceNo()), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(StringUtils.isEmpty((CharSequence)dto.getShippingCompanyCode()), "\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(StringUtils.isEmpty((CharSequence)dto.getShippingCompany()), "\u7269\u6d41\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderEo inOutResultOrderEo = new InOutResultOrderEo();
        inOutResultOrderEo.setShippingCompany(dto.getShippingCompany());
        inOutResultOrderEo.setShippingCompanyCode(dto.getShippingCompanyCode());
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"relevance_no", (Object)dto.getRelevanceNo()));
        inOutResultOrderEo.setSqlFilters((List)sqlFilters);
        int count = 0;
        List inOutResultOrderEos = this.inOutResultOrderDomain.queryByRealRelevanceNo(dto.getRelevanceNo());
        logger.info("updateShippingCompany-->inOutResultOrderEos:{}", (Object)LogUtils.buildLogContent(inOutResultOrderEos));
        CsOutDeliveryMessageDto csOutDeliveryMessageDto = new CsOutDeliveryMessageDto();
        csOutDeliveryMessageDto.setOrderNo(dto.getRelevanceNo());
        csOutDeliveryMessageDto.setShipmentEnterpriseCode(dto.getShippingCompanyCode());
        csOutDeliveryMessageDto.setShipmentEnterpriseName(dto.getShippingCompany());
        if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEos)) {
            List csWmsShippingInfoReqDtos;
            InOutResultOrderEo dbInOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
            csOutDeliveryMessageDto.setOutResultOrderNo(dbInOutResultOrderEo.getDocumentNo());
            csOutDeliveryMessageDto.setDeliveryTime(dbInOutResultOrderEo.getInOutTime());
            csOutDeliveryMessageDto.setShippingNo(dbInOutResultOrderEo.getShippingCode());
            csOutDeliveryMessageDto.setTotalQuantity(dbInOutResultOrderEo.getTotalQuantity());
            csOutDeliveryMessageDto.setTotalCartons(dbInOutResultOrderEo.getTotalCartons());
            csOutDeliveryMessageDto.setMergeQuantity(dbInOutResultOrderEo.getMergeQuantity());
            ArrayList deliveryDetailMessageDtoList = Lists.newArrayList();
            List inOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryByDocumentNo(dbInOutResultOrderEo.getDocumentNo());
            if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderDetailEos)) {
                for (Object inOutResultOrderDetailEo : inOutResultOrderDetailEos) {
                    CsOutDeliveryDetailMessageDto deliveryDetailMessageDto = new CsOutDeliveryDetailMessageDto();
                    deliveryDetailMessageDto.setOrderNo(dto.getRelevanceNo());
                    deliveryDetailMessageDto.setOutQuantity(inOutResultOrderDetailEo.getDoneQuantity());
                    deliveryDetailMessageDto.setLongCode(inOutResultOrderDetailEo.getSkuCode());
                    deliveryDetailMessageDto.setBatch(inOutResultOrderDetailEo.getBatch());
                    deliveryDetailMessageDto.setTradeOrderItemId(inOutResultOrderDetailEo.getPreOrderItemId());
                    deliveryDetailMessageDtoList.add(deliveryDetailMessageDto);
                }
            }
            csOutDeliveryMessageDto.setDeliveryDetailMessageDtoList((List)deliveryDetailMessageDtoList);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbInOutResultOrderEo.getShippingJson())) {
                try {
                    List csWmsShippingInfoReqDtoList = JSON.parseArray((String)dbInOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class);
                    if (CollectionUtils.isNotEmpty((Collection)csWmsShippingInfoReqDtoList)) {
                        for (CsWmsShippingInfoReqDto csWmsShippingInfoReqDto : csWmsShippingInfoReqDtoList) {
                            if (Objects.isNull(csWmsShippingInfoReqDto.getDeliveryTime())) {
                                csWmsShippingInfoReqDto.setDeliveryTime(csOutDeliveryMessageDto.getDeliveryTime());
                            }
                            csWmsShippingInfoReqDto.setShippingCompanyName(dto.getShippingCompany());
                            csWmsShippingInfoReqDto.setShippingCompanyCode(dto.getShippingCompanyCode());
                        }
                    }
                    csOutDeliveryMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String shippingJson = dbInOutResultOrderEo.getShippingJson();
            InOutNoticeOrderEo inOutNoticeOrderEo = new InOutNoticeOrderEo();
            ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
            ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
            if (!StringUtils.isEmpty((CharSequence)shippingJson) && CollectionUtils.isNotEmpty((Collection)(csWmsShippingInfoReqDtos = JSONArray.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class)))) {
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)csWmsShippingInfoReqDtos.get(0);
                String shippingCompanyCode = csWmsShippingInfoReqDto.getShippingCompanyCode();
                csWmsShippingInfoReqDto.setShippingCompanyCode(dto.getShippingCompanyCode());
                csWmsShippingInfoReqDto.setShippingCompanyName(dto.getShippingCompany());
                inOutResultOrderEo.setShippingJson(JSONArray.toJSONString((Object)csWmsShippingInfoReqDtos));
                inOutNoticeOrderEo.setShippingCompany(dto.getShippingCompanyCode());
                inOutNoticeOrderEo.setShippingCompanyName(dto.getShippingCompany());
                inOutNoticeOrderEo.setShippingJson(inOutResultOrderEo.getShippingJson());
                inOutNoticeOrderEo.setSqlFilters((List)sqlFilters);
                logger.info("updateShippingCompany-->inOutResultOrderEo:{}", (Object)LogUtils.buildLogContent(inOutResultOrderEo));
                logger.info("updateShippingCompany-->inOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(inOutNoticeOrderEo));
                this.inOutResultOrderDomain.updateSelectiveSqlFilter((BaseEo)inOutResultOrderEo);
                this.inOutNoticeOrderDomain.updateSelectiveSqlFilter((BaseEo)inOutNoticeOrderEo);
                List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(dto.getRelevanceNo());
                logger.info("updateShippingCompany-->receiveDeliveryNoticeOrderEos:{}", (Object)LogUtils.buildLogContent(receiveDeliveryNoticeOrderEos));
                if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEos)) {
                    ReceiveDeliveryNoticeOrderEo dbReceiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
                    csOutDeliveryMessageDto.setDeliveryNoticeOrderNo(dbReceiveDeliveryNoticeOrderEo.getPreOrderNo());
                    csOutDeliveryMessageDto.setOutNoticeOrderNo(dbReceiveDeliveryNoticeOrderEo.getDocumentNo());
                    String receiveShippingJson = dbReceiveDeliveryNoticeOrderEo.getShippingJson();
                    List receiveCsWmsShippingInfoReqDtos = JSONArray.parseArray((String)receiveShippingJson, CsWmsShippingInfoReqDto.class);
                    if (CollectionUtils.isNotEmpty((Collection)receiveCsWmsShippingInfoReqDtos)) {
                        for (CsWmsShippingInfoReqDto receiveCsWmsShippingInfoReqDto : receiveCsWmsShippingInfoReqDtos) {
                            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)receiveCsWmsShippingInfoReqDto.getShippingCompanyCode(), (CharSequence)shippingCompanyCode)) continue;
                            receiveCsWmsShippingInfoReqDto.setShippingCompanyCode(dto.getShippingCompanyCode());
                            receiveCsWmsShippingInfoReqDto.setShippingCompanyName(dto.getShippingCompany());
                        }
                        receiveDeliveryNoticeOrderEo.setShippingCompany(dto.getShippingCompanyCode());
                        receiveDeliveryNoticeOrderEo.setShippingCompanyName(dto.getShippingCompany());
                        receiveDeliveryNoticeOrderEo.setShippingJson(JSONArray.toJSONString((Object)receiveCsWmsShippingInfoReqDtos));
                        receiveDeliveryNoticeOrderEo.setSqlFilters((List)sqlFilters);
                        receiveDeliveryResultOrderEo.setShippingCompany(dto.getShippingCompany());
                        receiveDeliveryResultOrderEo.setShippingCompanyCode(dto.getShippingCompanyCode());
                        receiveDeliveryResultOrderEo.setShippingJson(receiveDeliveryNoticeOrderEo.getShippingJson());
                        receiveDeliveryResultOrderEo.setSqlFilters((List)sqlFilters);
                        logger.info("updateShippingCompany-->receiveDeliveryNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(receiveDeliveryNoticeOrderEo));
                        logger.info("updateShippingCompany-->receiveDeliveryResultOrderEo:{}", (Object)LogUtils.buildLogContent(receiveDeliveryResultOrderEo));
                        this.receiveDeliveryNoticeOrderDomain.updateSelectiveSqlFilter((BaseEo)receiveDeliveryNoticeOrderEo);
                        this.receiveDeliveryResultOrderDomain.updateSelectiveSqlFilter((BaseEo)receiveDeliveryResultOrderEo);
                    }
                }
            }
            InOutResultOrderUnhookFacadeBo context = new InOutResultOrderUnhookFacadeBo();
            context.setDocumentNo(dbInOutResultOrderEo.getDocumentNo());
            logger.info("updateShippingCompany-->context:{}", (Object)LogUtils.buildLogContent(context));
            if (org.apache.commons.lang.StringUtils.equals((String)dbInOutResultOrderEo.getOrderStatus(), (String)BaseOrderStatusEnum.ORO_HANG_UP.getCode())) {
                this.baseOrderFacade.outResultOrderUnhook(context);
            } else {
                this.sendDelaySingleMessage(csOutDeliveryMessageDto);
            }
        }
        return count;
    }

    private void sendDelaySingleMessage(CsOutDeliveryMessageDto csOutDeliveryMessageDto) {
        csOutDeliveryMessageDto.setCommonBack(Boolean.FALSE);
        csOutDeliveryMessageDto.setUpdateShippingCompany(Boolean.TRUE);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)csOutDeliveryMessageDto);
        logger.info("sendDelaySingleMessage==>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5\u8ba2\u5355\u5df2\u53d1\u8d27,messageVo:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendDelaySingleMessage("ORDER_SALE_WMS_SEND_BACK_TAG", (Object)messageVo, Long.valueOf(5L));
    }
}

