/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtils {
    public static final String EMAIL = "\\w+(\\.\\w+)*@\\w+(\\.\\w+)+";
    public static final String PHONE = "(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)";
    public static final String MOBILE = "^(13[0-9]|14[0-9]|15[0-9]|17[0-9]|18[0-9]|19[0-9])\\d{8}$";
    public static final String INTEGER_WEEK = "^[1-7]\\d*|0$";
    public static final String INTEGER = "^-?(([1-9]\\d*$)|0)";
    public static final String INTEGER_NEGATIVE = "^[1-9]\\d*|0$";
    public static final String INTEGER_POSITIVE = "^-[1-9]\\d*|0$";
    public static final String DOUBLE = "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$";
    public static final String DOUBLE_NEGATIVE = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$";
    public static final String DOUBLE_POSITIVE = "^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$";
    public static final String AGE = "^(?:[1-9][0-9]?|1[01][0-9]|120)$";
    public static final String CODE = "[0-9]\\d{5}(?!\\d)";
    public static final String STR_ENG_NUM_ = "^\\w+$";
    public static final String STR_ENG_NUM = "^[A-Za-z0-9]+";
    public static final String STR_ENG = "^[A-Za-z]+$";
    public static final String STR_SPECIAL = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
    public static final String DATE_ALL = "((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(10|12|0?[13578])([-\\/\\._]?)(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(11|0?[469])([-\\/\\._]?)(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(0?2)([-\\/\\._]?)(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([3579][26]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$))";
    public static final String DATE_FORMAT1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";
    public static final String URL = "^(http|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$";
    public static final String IDCARD = "((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65)[0-9]{4})(([1|2][0-9]{3}[0|1][0-9][0-3][0-9][0-9]{3}[Xx0-9])|([0-9]{2}[0|1][0-9][0-3][0-9][0-9]{3}))";
    public static final String ORG_CODE = "^[A-Z0-9]{8}-[A-Z0-9]$";
    public static final String STR_NUM = "^[0-9]+$";
    private static final String EMAIL_PATTERN = "\"[1-9a-zA-z_]\\\\w{0,14}@\\\\w{1,}\\\\.(com|net|com.cn)\"";
    private static final String CHINA_STR = "^[\\u4e00-\\u9fa5]+$";

    public static synchronized boolean StrisNull(String str) {
        return null == str || str.trim().length() <= 0;
    }

    public static boolean StrNotNull(String str) {
        return !ValidationUtils.StrisNull(str);
    }

    public static String nulltoStr(String str) {
        return ValidationUtils.StrisNull(str) ? "" : str;
    }

    public static String nulltoStr(String str, String defaut) {
        return ValidationUtils.StrisNull(str) ? defaut : str;
    }

    public static boolean checkEmail(String str) {
        return ValidationUtils.Regular(str, EMAIL);
    }

    public static boolean checkPhone(String str) {
        return ValidationUtils.Regular(str, PHONE);
    }

    public static boolean checkMobile(String str) {
        return ValidationUtils.Regular(str, MOBILE);
    }

    public static boolean checkUrl(String str) {
        return ValidationUtils.Regular(str, URL);
    }

    public static boolean checkNumber(String str) {
        return ValidationUtils.Regular(str, DOUBLE);
    }

    public static boolean checkInteger(String str) {
        return ValidationUtils.Regular(str, INTEGER);
    }

    public static boolean checkINTEGER_NEGATIVE(String str) {
        return ValidationUtils.Regular(str, INTEGER_NEGATIVE);
    }

    public static boolean checkINTEGER_WEEK(String str) {
        return ValidationUtils.Regular(str, INTEGER_WEEK);
    }

    public static boolean checkINTEGER_POSITIVE(String str) {
        return ValidationUtils.Regular(str, INTEGER_POSITIVE);
    }

    public static boolean checkDouble(String str) {
        return ValidationUtils.Regular(str, DOUBLE);
    }

    public static boolean checkDOUBLE_NEGATIVE(String str) {
        return ValidationUtils.Regular(str, DOUBLE_NEGATIVE);
    }

    public static boolean checkDOUBLE_POSITIVE(String str) {
        return ValidationUtils.Regular(str, DOUBLE_POSITIVE);
    }

    public static boolean checkDate(String str) {
        return ValidationUtils.Regular(str, DATE_ALL);
    }

    public static boolean checkDate1(String str) {
        return ValidationUtils.Regular(str, DATE_FORMAT1);
    }

    public static boolean checkAge(String str) {
        return ValidationUtils.Regular(str, AGE);
    }

    public static boolean checkLengOut(String str, int leng) {
        return ValidationUtils.StrisNull(str) ? false : str.trim().length() > leng;
    }

    public static boolean checkIdCard(String str) {
        if (ValidationUtils.StrisNull(str)) {
            return false;
        }
        if (str.trim().length() == 15 || str.trim().length() == 18) {
            return ValidationUtils.Regular(str, IDCARD);
        }
        return false;
    }

    public static boolean checkCode(String str) {
        return ValidationUtils.Regular(str, CODE);
    }

    public static boolean checkEnglish(String str) {
        return ValidationUtils.Regular(str, STR_ENG);
    }

    public static boolean checkENG_NUM(String str) {
        return ValidationUtils.Regular(str, STR_ENG_NUM);
    }

    public static boolean checkENG_NUM_(String str) {
        return ValidationUtils.Regular(str, STR_ENG_NUM_);
    }

    public static String filterStr(String str) {
        Pattern p = Pattern.compile(STR_SPECIAL);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean checkOrgCode(String str) {
        return ValidationUtils.Regular(str, ORG_CODE);
    }

    public static boolean checkSTR_NUM(String str) {
        return ValidationUtils.Regular(str, STR_NUM);
    }

    private static boolean Regular(String str, String pattern) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean checkBankCard(String bankCard) {
        if (bankCard.length() < 15 || bankCard.length() > 22) {
            return false;
        }
        char bit = ValidationUtils.getBankCardCheckCode(bankCard.substring(0, bankCard.length() - 1));
        if (bit == 'N') {
            return false;
        }
        return bankCard.charAt(bankCard.length() - 1) == bit;
    }

    public static char getBankCardCheckCode(String nonCheckCodeBankCard) {
        if (nonCheckCodeBankCard == null || nonCheckCodeBankCard.trim().length() == 0 || !nonCheckCodeBankCard.matches("\\d+")) {
            return 'N';
        }
        char[] chs = nonCheckCodeBankCard.trim().toCharArray();
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        return luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
    }

    public static boolean matchesEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        return email.matches(EMAIL_PATTERN);
    }

    public static boolean checkChinaStr(String chinaStr) {
        if (StringUtils.isBlank((CharSequence)chinaStr)) {
            return false;
        }
        return chinaStr.matches(CHINA_STR);
    }
}

