/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.listener;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.bd.StorageOrderExtApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsPcpExternalQimenTestOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.listener.CsSapChangeInventoryTransactionalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsQimenOrderTestReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.PushOrderWmsEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.SapChangeInventoryEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.WmsOutInSendCallBackEvent;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class PushOrderWmsTransactionalListener {
    private static final Logger logger = LoggerFactory.getLogger(PushOrderWmsTransactionalListener.class);
    @Autowired
    private ICsPcpExternalQimenTestOrderService csPcpExternalQimenTestOrderService;
    @Autowired
    private StorageOrderExtApiImpl storageOrderExtApiImpl;
    @Resource
    private ICacheService cacheService;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={PushOrderWmsEvent.class})
    public void handlePush(PushOrderWmsEvent pushOrderWmsEvent) {
        if (pushOrderWmsEvent.getSource() instanceof CsQimenOrderTestReqDto) {
            logger.info("handlePush==>\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u51fa\u5165\u5e93\u901a\u77e5\u5355\u63a8\u9001WMS\u7684,pushOrderWmsEvent:{}", (Object)JSON.toJSONString((Object)pushOrderWmsEvent));
            CsQimenOrderTestReqDto csQimenOrderTestReqDto = (CsQimenOrderTestReqDto)pushOrderWmsEvent.getSource();
            logger.info("handlePush==>\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u51fa\u5165\u5e93\u901a\u77e5\u5355\u63a8\u9001WMS\u7684,csQimenOrderTestReqDto:{}", (Object)JSON.toJSONString((Object)csQimenOrderTestReqDto));
            this.csPcpExternalQimenTestOrderService.sendOrderInfoToQimen(csQimenOrderTestReqDto);
        } else {
            InOutNoticeOrderContext source = (InOutNoticeOrderContext)pushOrderWmsEvent.getSource();
            String handlePush = "handlePush";
            if (!this.cacheService.setIfAbsent(handlePush + source.getDocumentNo(), (Object)1, 60).booleanValue()) {
                return;
            }
            InventoryConfig.getPushWms().pushWms(source);
            logger.info("handlePush==>\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u51fa\u5165\u5e93\u901a\u77e5\u5355\u63a8\u9001WMS\u7684,csQimenOrderTestReqDto:{}", (Object)source.getDocumentNo());
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={SapChangeInventoryEvent.class})
    public void handlePush(SapChangeInventoryEvent sapChangeInventoryEvent) {
        logger.info("handlePush==>\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406sap\u65b0\u589e\u51fa\u5165\u5e93\u5355\u636e\u540e\u66f4\u65b0\u5e93\u5b58\u4fe1\u606f\u53ca\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u72b6\u6001\u5165\u53c2,sapChangeInventoryEvent:{}", (Object)JSON.toJSONString((Object)sapChangeInventoryEvent));
        CsSapChangeInventoryTransactionalReqDto reqDto = (CsSapChangeInventoryTransactionalReqDto)sapChangeInventoryEvent.getSource();
        this.storageOrderExtApiImpl.asyncChangeInventory(reqDto.getResultNoList(), reqDto.getDeliveryNoList());
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={WmsOutInSendCallBackEvent.class})
    public void handlePush(WmsOutInSendCallBackEvent wmsOutInSendCallBackEvent) {
        logger.info("handlePush==>\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406wms\u51fa\u5165\u5e93\u56de\u4f20\u56de\u8c03,wmsOutInSendCallBackEvent:{}", (Object)JSON.toJSONString((Object)wmsOutInSendCallBackEvent));
        CsOrderBusinessCallBackContext callBackContext = (CsOrderBusinessCallBackContext)wmsOutInSendCallBackEvent.getSource();
        logger.info("handlePush==>\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406wms\u51fa\u5165\u5e93\u56de\u4f20\u56de\u8c03,callBackContext:{}", (Object)JSON.toJSONString((Object)callBackContext));
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)callBackContext.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        businessOrderCallBackService.inOutResultOrderCallBack(callBackContext);
        if (!callBackContext.getOverchargeFlag().booleanValue()) {
            businessOrderCallBackService.deliveryReceiveResultOrderCallBack(callBackContext);
        }
    }
}

