/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryTotalQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.LogicSupplyInventoryVo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLogicInventoryTotalQueryService")
public class CsLogicInventoryTotalQueryServiceImpl
implements ICsLogicInventoryTotalQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CsLogicInventoryTotalQueryServiceImpl.class);
    @Autowired
    ILogicInventoryTotalDomain logicInventoryTotalDomain;

    @Override
    public LogicInventoryTotalEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (LogicInventoryTotalEo)this.logicInventoryTotalDomain.selectByPrimaryKey(id);
    }

    @Override
    public List<CsLogicInventoryTotalRespDto> queryWarehouseInventory(CsLogicInventoryTotalBatchQueryDto batchQueryDto) {
        logger.info("queryWarehouseInventory-->\u6279\u91cf\u67e5\u8be2\u4ed3\u5e93\u8d27\u54c1\u5e93\u5b58\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)batchQueryDto));
        List<Object> list = Lists.newArrayList();
        LogicInventoryTotalEo logicInventoryTotalEo = new LogicInventoryTotalEo();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)batchQueryDto.getWarehouseCode())) {
            logicInventoryTotalEo.setWarehouseCode(batchQueryDto.getWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)batchQueryDto.getWarehouseCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"warehouse_code", (Object)batchQueryDto.getWarehouseCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)batchQueryDto.getCargoCode())) {
            sqlFilterList.add(SqlFilter.like((String)"sku_code", (Object)batchQueryDto.getCargoCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)batchQueryDto.getCargoCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"sku_code", (Object)batchQueryDto.getCargoCodeList()));
        }
        if (YesNoEnum.YES.getValue().equals(batchQueryDto.getIsAvailable())) {
            sqlFilterList.add(SqlFilter.gt((String)"available", (Object)0));
        }
        logicInventoryTotalEo.setSqlFilters((List)sqlFilterList);
        logicInventoryTotalEo.setDr(YesNoEnum.NO.getValue());
        logicInventoryTotalEo.setOrderByDesc("update_time");
        List inventoryTotalEoList = this.logicInventoryTotalDomain.selectList((BaseEo)logicInventoryTotalEo);
        if (CollectionUtils.isNotEmpty((Collection)inventoryTotalEoList)) {
            list = inventoryTotalEoList.stream().map(e -> {
                CsLogicInventoryTotalRespDto logicInventoryTotalRespDto = new CsLogicInventoryTotalRespDto();
                CubeBeanUtils.copyProperties((Object)logicInventoryTotalRespDto, (Object)e, (String[])new String[0]);
                logicInventoryTotalRespDto.setLongCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoName(e.getSkuName());
                return logicInventoryTotalRespDto;
            }).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public PageInfo<CsLogicInventoryTotalRespDto> queryByLogicWarehouseCodePage(CsInventoryTotalQueryReqDto csInventoryTotalQueryReqDto, Integer pageNum, Integer pageSize) {
        csInventoryTotalQueryReqDto.setPageNum(pageNum);
        csInventoryTotalQueryReqDto.setPageSize(pageSize);
        return this.queryByLogicWarehouseCodePage(csInventoryTotalQueryReqDto);
    }

    @Override
    public List<LogicSupplyInventoryVo> queryLogicSupplyInventory(List<String> warehouseCodes, List<String> cargoCodes) {
        return this.logicInventoryTotalDomain.queryLogicSupplyInventory(warehouseCodes, cargoCodes);
    }

    @Override
    public PageInfo<CsLogicInventoryTotalRespDto> queryByLogicWarehouseCodePage(CsInventoryTotalQueryReqDto csInventoryTotalQueryReqDto) {
        ExtQueryChainWrapper filter = this.logicInventoryTotalDomain.filter();
        if (StringUtils.isNotEmpty((CharSequence)csInventoryTotalQueryReqDto.getLogicWarehouseCode())) {
            filter.eq((Object)"warehouse_code", (Object)csInventoryTotalQueryReqDto.getLogicWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)csInventoryTotalQueryReqDto.getLogicWarehouseCodeList())) {
            filter.in((Object)"warehouse_code", (Collection)csInventoryTotalQueryReqDto.getLogicWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)csInventoryTotalQueryReqDto.getLongCodeList())) {
            filter.in((Object)"sku_code", (Collection)csInventoryTotalQueryReqDto.getLongCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)csInventoryTotalQueryReqDto.getLongCode())) {
            filter.like((Object)"sku_code", (Object)csInventoryTotalQueryReqDto.getLongCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)csInventoryTotalQueryReqDto.getCargoName())) {
            filter.like((Object)"sku_name", (Object)csInventoryTotalQueryReqDto.getCargoName());
        }
        PageInfo eoPageInfo = filter.select(new String[0]).page(csInventoryTotalQueryReqDto.getPageNum(), csInventoryTotalQueryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> dtoList = new ArrayList();
        if (Objects.nonNull(eoPageInfo) && CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            dtoList = eoPageInfo.getList().stream().map(e -> {
                CsLogicInventoryTotalRespDto logicInventoryTotalRespDto = new CsLogicInventoryTotalRespDto();
                CubeBeanUtils.copyProperties((Object)logicInventoryTotalRespDto, (Object)e, (String[])new String[0]);
                logicInventoryTotalRespDto.setLongCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoName(e.getSkuName());
                return logicInventoryTotalRespDto;
            }).collect(Collectors.toList());
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<CsLogicInventoryTotalRespDto> queryAvailableGtZeroByPage(CsLogicInventoryTotalQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u5927\u4e8e0-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper<LogicInventoryTotalEo> wrapper = this.getQueryWrapper(queryDto);
        wrapper.gt((Object)"available", (Object)0);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.logicInventoryTotalDomain.getMapper().selectList(wrapper);
        PageInfo info = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)pageInfo, (String[])new String[]{"list"});
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)selectList)) {
            list = selectList.stream().map(e -> {
                CsLogicInventoryTotalRespDto logicInventoryTotalRespDto = new CsLogicInventoryTotalRespDto();
                CubeBeanUtils.copyProperties((Object)logicInventoryTotalRespDto, (Object)e, (String[])new String[0]);
                logicInventoryTotalRespDto.setLongCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoName(e.getSkuName());
                return logicInventoryTotalRespDto;
            }).collect(Collectors.toList());
        }
        pageInfo.setList((List)list);
        logger.info("\u5206\u9875\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u5927\u4e8e0-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public List<CsLogicInventoryTotalRespDto> queryByList(List<CsLogicInventoryTotalQueryDto> list) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        CompletableFuture[] completableFutures = (CompletableFuture[])list.stream().map(re -> CompletableFuture.supplyAsync(() -> this.queryEoByParam((CsLogicInventoryTotalQueryDto)re), executorService)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(completableFutures);
        return Arrays.stream(completableFutures).flatMap(r -> {
            try {
                return ((List)r.get()).stream();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }).collect(Collectors.toList());
    }

    private QueryWrapper<LogicInventoryTotalEo> getQueryWrapper(CsLogicInventoryTotalQueryDto queryDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)"0");
        if (queryDto.getWarehouseId() != null) {
            wrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            wrapper.eq((Object)"sku_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoName()})) {
            wrapper.like((Object)"sku_name", (Object)("%" + queryDto.getCargoName() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.like((Object)"sku_code", (Object)("%" + queryDto.getLongCode() + "%"));
        }
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        return wrapper;
    }

    private List<CsLogicInventoryTotalRespDto> queryEoByParam(CsLogicInventoryTotalQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u903b\u8f91\u6279\u6b21\u5e93\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        List<Object> list = Lists.newArrayList();
        if (Objects.isNull(queryDto)) {
            return list;
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            wrapper.eq((Object)"sku_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.eq((Object)"sku_code", (Object)queryDto.getLongCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodes())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getCargoCodes())) {
            wrapper.in((Object)"sku_code", (Collection)queryDto.getCargoCodes());
        }
        wrapper.eq((Object)"dr", (Object)"0");
        List selectList = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)selectList)) {
            list = selectList.stream().map(e -> {
                CsLogicInventoryTotalRespDto logicInventoryTotalRespDto = new CsLogicInventoryTotalRespDto();
                CubeBeanUtils.copyProperties((Object)logicInventoryTotalRespDto, (Object)e, (String[])new String[0]);
                logicInventoryTotalRespDto.setLongCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoCode(e.getSkuCode());
                logicInventoryTotalRespDto.setCargoName(e.getSkuName());
                return logicInventoryTotalRespDto;
            }).collect(Collectors.toList());
        }
        return list;
    }
}

