/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsInPlannedOrderDetailQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInPlannedOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInPlannedOrderDetailQueryService")
public class CsInPlannedOrderDetailQueryServiceImpl
implements ICsInPlannedOrderDetailQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInPlannedOrderDetailQueryServiceImpl.class);
    @Autowired
    private CsInPlannedOrderDetailDas csInPlannedOrderDetailDas;
    @Autowired
    private CsInPlannedOrderDetailMapper csInPlannedOrderDetailMapper;

    @Override
    public CsInPlannedOrderDetailEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (CsInPlannedOrderDetailEo)this.csInPlannedOrderDetailDas.selectByPrimaryKey(id);
    }

    @Override
    public List<CsInPlannedOrderDetailRespDto> queryItemDetailByOrderNo(String orderNo) {
        logger.info("queryItemDetailByOrderNo==>\u6839\u636e\u5355\u636e\u7f16\u7801\u67e5\u8be2\u5355\u636e\u5546\u54c1\u8be6\u60c5\u4fe1\u606f,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        List orderDetailEoList = this.csInPlannedOrderDetailMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderDetailEoList)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyProperties((Object)resultList, (Object)orderDetailEoList, (String[])new String[0]);
        return resultList;
    }

    @Override
    public PageInfo<CsInPlannedOrderDetailRespDto> queryItemDetailPageInfo(CsInPlannedOrderPageQueryDto csInPlannedOrderPageQueryDto) {
        logger.info("queryItemDetailByOrderNo==>\u6839\u636e\u5355\u636e\u7f16\u7801\u67e5\u8be2\u5355\u636e\u5546\u54c1\u8be6\u60c5\u4fe1\u606f,csInPlannedOrderPageQueryDto:{}", (Object)LogUtils.buildLogContent(csInPlannedOrderPageQueryDto));
        String orderNo = csInPlannedOrderPageQueryDto.getOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u53f7\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = csInPlannedOrderPageQueryDto.getPageNum();
        Integer pageSize = csInPlannedOrderPageQueryDto.getPageSize();
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.csInPlannedOrderDetailMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(list);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, CsInPlannedOrderDetailRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public List<CsInPlannedOrderDetailRespDto> releaseQueryList(CsInPlannedOrderDetailQueryDto queryDto) {
        logger.info("\u653e\u884c\u8ba1\u5212\u6570\u91cf\u660e\u7ec6\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)queryDto.getLongCodeList()), "\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)queryDto.getBatchList()), "\u6279\u6b21\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return this.csInPlannedOrderDetailMapper.releaseQueryList(queryDto);
    }
}

