/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.statemachine.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.statemachine.AbstractDocumentActionService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="csDocumentDeliveryOutFinishService")
public class CsDocumentDeliveryOutFinishServiceImpl
extends AbstractDocumentActionService {
    private static Logger logger = LoggerFactory.getLogger(CsDocumentDeliveryOutFinishServiceImpl.class);
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private ICsDeliveryResultOrderService csDeliveryResultOrderService;
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;
    @Resource
    private ICsInventoryPreemptionService csInventoryPreemptionService;
    @Resource
    private ICsDeliveryResultOrderQueryService csDeliveryResultOrderQueryService;
    @Resource
    private MqService mqService;

    @Override
    public void doAction(String documentNo, String preOrderNo) {
        logger.info("\u51fa\u5e93\u5b8c\u6210,\u5165\u53c2\uff1a[documentNo:{},preOrderNo{}]", (Object)documentNo, (Object)preOrderNo);
        List csOutNoticeOrderEos = this.inOutNoticeOrderDomain.queryByRelevanceNo(documentNo);
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEos)) {
            InOutNoticeOrderEo csOutNoticeOrderEo = new InOutNoticeOrderEo();
            csOutNoticeOrderEo.setId(((InOutNoticeOrderEo)csOutNoticeOrderEos.get(0)).getId());
            csOutNoticeOrderEo.setOrderStatus(CsOrderStatusEnum.DELIVERY_OUT_FINISH.getCode());
            this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)csOutNoticeOrderEo);
        }
        logger.info("\u51fa\u5e93\u5b8c\u6210,\u66f4\u65b0\u51fa\u5e93\u901a\u77e5\u5355\u72b6\u6001\uff1a[relevanceNo:{},preOrderNo{}]", (Object)documentNo, (Object)preOrderNo);
        Long deliveryResultOrderId = this.csDeliveryResultOrderService.createDeliveryResultOrder(documentNo, preOrderNo);
        logger.info("\u51fa\u5e93\u5b8c\u6210,\u751f\u6210\u53d1\u8d27\u7ed3\u679c\u5355\uff1a [relevanceNo:{},preOrderNo{},deliveryResultOrderId:{}]", new Object[]{documentNo, preOrderNo, deliveryResultOrderId});
        CsInventoryOperateReqDto dto = this.structureParam(documentNo);
        CompletableFuture.runAsync(() -> {
            logger.info("\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff1a\u51fa\u5e93\u5b8c\u6210\uff0c\u53d8\u52a8\u7269\u7406\u4ed3\u3001\u903b\u8f91\u4ed3\u5e93\u5b58\u3001\u603b\u5e93\u5b58");
            Boolean aBoolean = this.csInventoryExposedService.deductionInventory(dto);
            logger.info("\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f\uff0c\u51fa\u5e93\u5b8c\u6210,\u51fa\u5e93\u5b8c\u6210");
            logger.info("\u51fa\u5e93\u5b8c\u6210,\u5e93\u5b58\u53d8\u52a8\u53c2\u6570\uff1a[aBoolean\uff1a{}]", (Object)aBoolean);
            this.csInventoryPreemptionService.updateStatusDisableBySourceNo(dto.getSourceNo());
            logger.info("\u8425\u9500\u4e91\u53d1\u8d27\u56de\u4f20,\u53d8\u66f4\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210");
        });
        MessageVo messageVo = new MessageVo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderTradeStatus", (Object)"SUCC");
        jsonObject.put("orderCode", (Object)preOrderNo);
        messageVo.setData((Object)jsonObject);
        jsonObject.put("orderCode", (Object)preOrderNo);
        jsonObject.put("type", (Object)"delivery");
        logger.info("\u51fa\u5e93\u5b8c\u6210,\u901a\u77e5\u8ba2\u5355\u66f4\u65b0\u72b6\u6001\uff1a[messageVo\uff1a{}]", (Object)messageVo.toString());
        this.mqService.sendToChangeOrderStatus(messageVo);
    }

    private CsInventoryOperateReqDto structureParam(String documentNo) {
        CsInventoryOperateReqDto dto = new CsInventoryOperateReqDto();
        List<ReceiveDeliveryResultOrderEo> resultOrderEos = this.csDeliveryResultOrderQueryService.queryByRelevanceNo(documentNo);
        CsDeliveryResultOrderRespDto deliveryResultOrderRespDto = this.csDeliveryResultOrderQueryService.queryById(resultOrderEos.get(0).getId());
        dto.setSourceNo(deliveryResultOrderRespDto.getPreOrderNo());
        dto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE.getCode());
        dto.setNegativeValidate(YesNoEnum.NO.getValue());
        ArrayList<CsInventoryOperateCargoReqDto> operateCargoReqDtoList = new ArrayList<CsInventoryOperateCargoReqDto>();
        for (CsDeliveryResultOrderDetailRespDto detailRespDto : deliveryResultOrderRespDto.getDeliveryResultOrderDetailRespDtoList()) {
            CsInventoryOperateCargoReqDto cargoReqDto = new CsInventoryOperateCargoReqDto();
            cargoReqDto.setWarehouseCode(deliveryResultOrderRespDto.getWarehouseCode());
            cargoReqDto.setCargoCode(detailRespDto.getCargoCode());
            cargoReqDto.setCargoCode(detailRespDto.getCargoCode());
            cargoReqDto.setBatch(detailRespDto.getBatch());
            cargoReqDto.setActivityId(detailRespDto.getActivityId());
            cargoReqDto.setChangeInventory(detailRespDto.getQuantity());
            operateCargoReqDtoList.add(cargoReqDto);
        }
        dto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        return dto;
    }
}

