/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.IPcpDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryDateUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csLogicInventoryExposedServiceImpl")
public class CsLogicInventoryExposedServiceImpl
implements ICsLogicInventoryExposedService {
    private final Logger logger = LoggerFactory.getLogger(CsLogicInventoryExposedServiceImpl.class);
    @Autowired
    IPcpDeliveryNoticeOrderService pcpDeliveryNoticeOrderService;
    @Resource
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Resource
    ICalcInventoryService calcInventoryService;
    @Resource
    ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("preemptInventory==>\u903b\u8f91\u4ed3\u5e93\u5b58\u9884\u5360,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkParams(inventoryOperateReqDto);
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        this.rollbackOutLogicInventory(inventoryOperateReqDto.getSourceNo(), inventoryOperateReqDto.getSourceType());
        Boolean commonFlag = this.preemptLogicInventory(inventoryOperateReqDto, inventoryOperateReqDto.getOperateCargoReqDtoList());
        this.logger.info("preemptInventory==>\u903b\u8f91\u4ed3\u5e93\u5b58\u9884\u5360,commonFlag:{}", (Object)commonFlag);
        if (!commonFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u9884\u5360\u5931\u8d25");
        }
        return true;
    }

    public void rollbackOutLogicInventory(String sourceNo, String sourceType) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(sourceNo);
        if (StringUtils.contains((CharSequence)sourceNo, (CharSequence)"DD")) {
            releasePreemptParam.setIsSaleOrder(Boolean.valueOf(true));
        }
        releasePreemptParam.setSourceType(sourceType);
        releasePreemptParam.setBusinessType(sourceType);
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }

    private Boolean preemptLogicInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setIsSaleOrder(Boolean.valueOf(true));
        preemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
        preemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
        preemptParam.setBusinessType(inventoryOperateReqDto.getBusinessType());
        if (StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getExtension())) {
            preemptParam.setBusinessType(inventoryOperateReqDto.getExtension());
        }
        preemptParam.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        if (null != inventoryOperateReqDto.getNegativeValidate()) {
            preemptParam.setValidNegative(Boolean.valueOf(YesNoHelper.YES.equals(inventoryOperateReqDto.getNegativeValidate())));
        }
        ArrayList detailParams = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto detailReqDto : operateCargoReqDtoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getChangeInventory());
            detailParam.setNum(preempt);
            detailParam.setSkuCode(detailReqDto.getLongCode());
            String warehouseCode = detailReqDto.getWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParams.add(detailParam);
            preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
            preemptParam.setShoutBatch(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)detailReqDto.getBatch())));
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptOrderInventory(CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        this.logger.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,logicPreemptInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(logicPreemptInventoryOperateReqDto));
        AssertUtil.isTrue(null != logicPreemptInventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInventoryOperateReqDto csInventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto = logicPreemptInventoryOperateReqDto.getDeliveryNoticeOrderAddReqDto();
        String businessType = StringUtils.isNotBlank((CharSequence)csInventoryOperateReqDto.getBusinessType()) ? csInventoryOperateReqDto.getBusinessType() : CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode();
        csInventoryOperateReqDto.setBusinessType(businessType);
        this.mergeCargoList(deliveryNoticeOrderAddReqDto, csInventoryOperateReqDto);
        deliveryNoticeOrderAddReqDto.setBusinessType(businessType);
        Long deliveryNoticeOrderId = this.pcpDeliveryNoticeOrderService.add(deliveryNoticeOrderAddReqDto);
        Boolean preemptInventoryFlag = this.preemptInventory(csInventoryOperateReqDto);
        this.logger.info("preemptOrderInventory==>preemptInventoryFlag:{},deliveryNoticeOrderId:{}", (Object)preemptInventoryFlag, (Object)deliveryNoticeOrderId);
        if (!preemptInventoryFlag.booleanValue() || null == deliveryNoticeOrderId) {
            throw new BizException("\u5e93\u5b58\u9884\u5360\u5931\u8d25");
        }
        return true;
    }

    private void mergeCargoList(CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto, CsInventoryOperateReqDto csInventoryOperateReqDto) {
        List operateCargoReqDtoList = csInventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> cargoMap = operateCargoReqDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getLongCode() + "_" + dto.getBatch()));
        Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = cargoMap.entrySet();
        List<Object> buildList = Lists.newArrayList();
        Boolean noBatch = false;
        for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
            List<CsInventoryOperateCargoReqDto> tempList = entry.getValue();
            CsInventoryOperateCargoReqDto cargoReqDto = tempList.get(0);
            BigDecimal mergeChangeInventory = tempList.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
            String longCode = cargoReqDto.getLongCode();
            String cargoCode = cargoReqDto.getCargoCode();
            CsDeliveryNoticeOrderDetailAddReqDto addDto = new CsDeliveryNoticeOrderDetailAddReqDto();
            addDto.setCargoCode(cargoCode);
            addDto.setLongCode(longCode);
            addDto.setPlanQuantity(mergeChangeInventory);
            addDto.setBatch(cargoReqDto.getBatch());
            addDto.setTradeOrderItemId(cargoReqDto.getTradeOrderItemId());
            noBatch = StringUtils.isBlank((CharSequence)addDto.getBatch());
            buildList.add(addDto);
        }
        if (noBatch.booleanValue()) {
            this.logger.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u6ca1\u6709\u6307\u5b9a\u6279\u6b21\u9884\u5360:sourceNo{}", (Object)deliveryNoticeOrderAddReqDto.getPreOrderNo());
            buildList = this.getCsBasicsOrderDetailList(deliveryNoticeOrderAddReqDto, (List<CsDeliveryNoticeOrderDetailAddReqDto>)buildList);
        }
        deliveryNoticeOrderAddReqDto.setNoBatch(Boolean.TRUE.equals(noBatch) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        deliveryNoticeOrderAddReqDto.setDetailAddReqDtoList((List)buildList);
    }

    private List<CsDeliveryNoticeOrderDetailAddReqDto> getCsBasicsOrderDetailList(CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto, List<CsDeliveryNoticeOrderDetailAddReqDto> buildList) {
        List<InventoryPreemptionEo> InventoryPreemptionEoList = this.csInventoryPreemptionQueryService.queryPreemptTypeBySourceNo(deliveryNoticeOrderAddReqDto.getPreOrderNo(), CsValidFlagEnum.ENABLE.getCode(), CsWarehouseClassifyEnum.LOGIC.getCode());
        if (CollectionUtils.isNotEmpty(InventoryPreemptionEoList)) {
            Map tradeOrderItemIdMap = buildList.stream().collect(HashMap::new, (m, v) -> m.put(v.getLongCode(), v.getTradeOrderItemId()), HashMap::putAll);
            ArrayList<CsDeliveryNoticeOrderDetailAddReqDto> deliveryDetailList1 = new ArrayList<CsDeliveryNoticeOrderDetailAddReqDto>();
            for (InventoryPreemptionEo inventoryPreemptionEo : InventoryPreemptionEoList) {
                CsDeliveryNoticeOrderDetailAddReqDto basic = new CsDeliveryNoticeOrderDetailAddReqDto();
                basic.setLongCode(inventoryPreemptionEo.getSkuCode());
                basic.setCargoName(inventoryPreemptionEo.getSkuName());
                basic.setCargoCode(inventoryPreemptionEo.getSkuCode());
                basic.setPlanQuantity(inventoryPreemptionEo.getPreemptNum());
                basic.setBatch(inventoryPreemptionEo.getBatch());
                basic.setTradeOrderItemId((Long)tradeOrderItemIdMap.get(inventoryPreemptionEo.getSkuCode()));
                deliveryDetailList1.add(basic);
            }
            return deliveryDetailList1;
        }
        return buildList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean releaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("releaseInventory==>\u903b\u8f91\u4ed3\u5e93\u5b58\u91ca\u653e,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
        if (StringUtils.contains((CharSequence)inventoryOperateReqDto.getSourceNo(), (CharSequence)"DD")) {
            releasePreemptParam.setIsSaleOrder(Boolean.valueOf(true));
        }
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(inventoryOperateReqDto.getBusinessType()) || CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(inventoryOperateReqDto.getBusinessType())) {
            releasePreemptParam.setIsSaleOrder(Boolean.TRUE);
        }
        releasePreemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
        releasePreemptParam.setValidNegative(Boolean.valueOf(false));
        this.calcInventoryService.releasePreempt(releasePreemptParam);
        return true;
    }

    @Override
    public Boolean releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        List inventoryPreemptionEos;
        this.logger.info("releaseInventoryByPreemption==>\u6839\u636e\u9884\u5360\u8bb0\u5f55\uff0c\u91ca\u653e\u4e4b\u524d\u9884\u5360\u7684\u5e93\u5b58,releasePreemptOperateReqDto:{}", (Object)LogUtils.buildLogContent(releasePreemptOperateReqDto));
        String sourceNo = releasePreemptOperateReqDto.getSourceNo();
        String sourceType = releasePreemptOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceType), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoReqDtoList = releasePreemptOperateReqDto.getOperateCargoReqDtoList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        List includeSourceTypeList = releasePreemptOperateReqDto.getIncludeSourceTypeList();
        if (CollectionUtils.isNotEmpty((Collection)includeSourceTypeList)) {
            queryWrapper.in((Object)"source_type", (Collection)includeSourceTypeList);
        }
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        if (CollectionUtils.isNotEmpty((Collection)operateCargoReqDtoList)) {
            List cargoCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getCargoCode())).map(CsInventoryOperateCargoReqDto::getCargoCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"sku_code", cargoCodeList);
            }
            List warehouseCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getWarehouseCode())).map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(inventoryPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper)))) {
            this.logger.error("releasePreemptionInfo==>\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55,sourceNo:{}", (Object)sourceNo);
            return true;
        }
        CsInventoryOperateReqDto releaseOperateReqDto = new CsInventoryOperateReqDto();
        releaseOperateReqDto.setSourceNo(releasePreemptOperateReqDto.getSourceNo());
        releaseOperateReqDto.setSourceType(sourceType);
        releaseOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList releaseCargoReqDtoList = Lists.newArrayList();
        for (InventoryPreemptionEo inventoryPreemptionEo : inventoryPreemptionEos) {
            CsInventoryOperateCargoReqDto releaseCargoReqDto = new CsInventoryOperateCargoReqDto();
            releaseCargoReqDto.setCargoCode(inventoryPreemptionEo.getSkuCode());
            releaseCargoReqDto.setWarehouseCode(inventoryPreemptionEo.getWarehouseCode());
            releaseCargoReqDto.setChangeInventory(inventoryPreemptionEo.getPreemptNum());
            releaseCargoReqDto.setBatch(inventoryPreemptionEo.getBatch());
            releaseCargoReqDto.setActivityId(inventoryPreemptionEo.getActivityId());
            releaseCargoReqDtoList.add(releaseCargoReqDto);
        }
        releaseOperateReqDto.setOperateCargoReqDtoList((List)releaseCargoReqDtoList);
        Boolean releaseInventory = this.releaseInventory(releaseOperateReqDto);
        return releaseInventory;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean cancelOrder(String orderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInventoryReleasePreemptOperateReqDto csInventoryReleasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        csInventoryReleasePreemptOperateReqDto.setSourceNo(orderNo);
        csInventoryReleasePreemptOperateReqDto.setSourceType(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
        Boolean releaseFlag = this.releaseInventoryByPreemption(csInventoryReleasePreemptOperateReqDto);
        this.pcpDeliveryNoticeOrderService.onlyUpdateDocumentStatusUnCheck(orderNo, BaseOrderStatusEnum.DELIVERY_CANCEL.getCode());
        return releaseFlag;
    }

    @Override
    public Boolean batchUpdateInventoryDate(List<CsInventoryDateUpdateReqDto> inventoryDateUpdateReqDtoList) {
        if (CollectionUtils.isEmpty(inventoryDateUpdateReqDtoList)) {
            return false;
        }
        List<LogicInventoryEo> csLogicInventoryEoList = this.getLogicInventoryEos(inventoryDateUpdateReqDtoList);
        Map<String, Long> inventoryIdMap = this.getStringLongMap(csLogicInventoryEoList);
        for (CsInventoryDateUpdateReqDto updateReqDto : inventoryDateUpdateReqDtoList) {
            String key = updateReqDto.getWarehouseCode() + updateReqDto.getWarehouseCode() + updateReqDto.getBatch();
            Long updateId = inventoryIdMap.get(key);
            if (null == updateId) continue;
            LogicInventoryEo logicInventoryEo = new LogicInventoryEo();
            logicInventoryEo.setId(updateId);
            logicInventoryEo.setProduceTime(updateReqDto.getProduceTime());
            logicInventoryEo.setExpireTime(updateReqDto.getExpireTime());
            this.logicInventoryDomain.getMapper().updateById((BaseEo)logicInventoryEo);
        }
        return true;
    }

    private Map<String, Long> getStringLongMap(List<LogicInventoryEo> csLogicInventoryEoList) {
        HashMap<String, Long> inventoryIdMap = new HashMap<String, Long>();
        if (CollectionUtils.isNotEmpty(csLogicInventoryEoList)) {
            for (LogicInventoryEo csLogicInventoryEo : csLogicInventoryEoList) {
                String key = csLogicInventoryEo.getWarehouseCode() + csLogicInventoryEo.getWarehouseCode() + csLogicInventoryEo.getBatch();
                inventoryIdMap.put(key, csLogicInventoryEo.getId());
            }
        }
        return inventoryIdMap;
    }

    private List<LogicInventoryEo> getLogicInventoryEos(List<CsInventoryDateUpdateReqDto> inventoryDateUpdateReqDtoList) {
        ArrayList<String> warehouseCodeList = new ArrayList<String>();
        ArrayList<String> longCodeList = new ArrayList<String>();
        ArrayList<String> batchList = new ArrayList<String>();
        for (CsInventoryDateUpdateReqDto csInventoryDateUpdateReqDto : inventoryDateUpdateReqDtoList) {
            warehouseCodeList.add(csInventoryDateUpdateReqDto.getWarehouseCode());
            longCodeList.add(csInventoryDateUpdateReqDto.getLongCode());
            batchList.add(csInventoryDateUpdateReqDto.getBatch());
        }
        QueryWrapper logicWrapper = new QueryWrapper();
        logicWrapper.in((Object)"warehouse_code", warehouseCodeList);
        logicWrapper.in((Object)"sku_code", longCodeList);
        logicWrapper.in((Object)"batch", batchList);
        List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)logicWrapper);
        return csLogicInventoryEoList;
    }

    private void checkParams(CsInventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceNo()), "\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceType()), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Integer negativeValidate = inventoryOperateReqDto.getNegativeValidate();
        if (null == negativeValidate) {
            negativeValidate = YesNoEnum.YES.getValue();
        }
        AssertUtil.isTrue(YesNoEnum.YES.getValue().equals(negativeValidate) || YesNoEnum.NO.getValue().equals(negativeValidate), "\u662f\u5426\u6821\u9a8c\u8d1f\u5e93\u5b58\u53c2\u6570\u6709\u8bef");
        List operateDetailReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateDetailReqDtoList), "\u8d27\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateDetailReqDtoList) {
            String cargoCode = inventoryOperateDetailReqDto.getCargoCode();
            String longCode = inventoryOperateDetailReqDto.getLongCode();
            if (StringUtils.isNotBlank((CharSequence)cargoCode) && StringUtils.isBlank((CharSequence)longCode)) {
                inventoryOperateDetailReqDto.setLongCode(cargoCode);
            }
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getLongCode()), "\u5546\u54c1\u957f\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

