/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsRelWarehouseShipmentQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.other.ICsRelWarehouseShipmentService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.other.CsRelWarehouseShipmentDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsRelWarehouseShipmentEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsRelWarehouseShipmentMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsRelWarehouseShipmentUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csRelWarehouseShipmentService")
public class CsRelWarehouseShipmentServiceImpl
implements ICsRelWarehouseShipmentService {
    private static Logger logger = LoggerFactory.getLogger(CsRelWarehouseShipmentServiceImpl.class);
    @Autowired
    private CsRelWarehouseShipmentDas csRelWarehouseShipmentDas;
    @Autowired
    private ICsRelWarehouseShipmentQueryService csRelWarehouseShipmentQueryService;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    private CsShipmenetEnterpriseMapper csShipmenetEnterpriseMapper;
    @Resource
    private CsRelWarehouseShipmentMapper csRelWarehouseShipmentMapper;

    @Override
    public Long add(CsRelWarehouseShipmentAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsRelWarehouseShipmentEo insertEo = CsRelWarehouseShipmentEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csRelWarehouseShipmentDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsRelWarehouseShipmentUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsRelWarehouseShipmentEo updateEo = CsRelWarehouseShipmentEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csRelWarehouseShipmentDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsRelWarehouseShipmentEo eo = this.csRelWarehouseShipmentQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, CsInventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csRelWarehouseShipmentDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean generateRelInfo(CsRelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        logger.info("generateRelInfo==>\u65b0\u589e\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,relWarehouseShipmentGenerateReqDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentGenerateReqDto));
        this.checkParams(relWarehouseShipmentGenerateReqDto);
        this.checkRepetition(relWarehouseShipmentGenerateReqDto);
        List detailReqDtoList = relWarehouseShipmentGenerateReqDto.getDetailReqDtoList();
        ArrayList csRelWarehouseShipmentEoList = Lists.newArrayList();
        for (CsRelWarehouseShipmentGenerateDetailReqDto detailReqDto : detailReqDtoList) {
            CsRelWarehouseShipmentEo csRelWarehouseShipmentEo = new CsRelWarehouseShipmentEo();
            csRelWarehouseShipmentEo.setWarehouseCode(relWarehouseShipmentGenerateReqDto.getWarehouseCode());
            csRelWarehouseShipmentEo.setWarehouseName(relWarehouseShipmentGenerateReqDto.getWarehouseName());
            csRelWarehouseShipmentEo.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            csRelWarehouseShipmentEo.setShipmentEnterpriseCode(detailReqDto.getShipmentEnterpriseCode());
            csRelWarehouseShipmentEo.setShipmentEnterpriseName(detailReqDto.getShipmentEnterpriseName());
            csRelWarehouseShipmentEo.setShipmentPriority(detailReqDto.getShipmentPriority());
            csRelWarehouseShipmentEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            csRelWarehouseShipmentEoList.add(csRelWarehouseShipmentEo);
        }
        this.csRelWarehouseShipmentMapper.insertBatch((List)csRelWarehouseShipmentEoList);
        return true;
    }

    private void checkRepetition(CsRelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        String warehouseCode = relWarehouseShipmentGenerateReqDto.getWarehouseCode();
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseShipmentEoList = this.csRelWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentEoList), String.format("\u4ed3\u5e93\u3010%s\u3011\u5df2\u8bbe\u7f6e\u7269\u6d41\u5546\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e", warehouseCode));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRelInfo(String warehouseCode) {
        logger.info("deleteRelInfo==>\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u5220\u9664\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,warehouseCode:{}", (Object)warehouseCode);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseShipmentEoList = this.csRelWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseShipmentEoList), "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f");
        for (CsRelWarehouseShipmentEo csRelWarehouseShipmentEo : csRelWarehouseShipmentEoList) {
            csRelWarehouseShipmentEoQueryWrapper.clear();
            csRelWarehouseShipmentEoQueryWrapper.eq((Object)"id", (Object)csRelWarehouseShipmentEo.getId());
            csRelWarehouseShipmentEo.setValidFlag(CsValidFlagEnum.DISABLE.getCode());
            csRelWarehouseShipmentEo.setDr(YesNoEnum.YES.getValue());
            this.csRelWarehouseShipmentMapper.update((Object)csRelWarehouseShipmentEo, (Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean editRelInfo(CsRelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        logger.info("editRelInfo==>\u7f16\u8f91\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f,relWarehouseShipmentGenerateReqDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentGenerateReqDto));
        AssertUtil.isTrue(null != relWarehouseShipmentGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseCode = relWarehouseShipmentGenerateReqDto.getWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List detailReqDtoList = relWarehouseShipmentGenerateReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList), "\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsRelWarehouseShipmentGenerateDetailReqDto detailReqDto : detailReqDtoList) {
            String shipmentEnterpriseCode = detailReqDto.getShipmentEnterpriseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), "\u7269\u6d41\u5546\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            Integer shipmentPriority = detailReqDto.getShipmentPriority();
            AssertUtil.isTrue(null != shipmentPriority && shipmentPriority >= 1 && shipmentPriority <= Integer.MAX_VALUE, "\u4f18\u5148\u7ea7\u53c2\u6570\u6709\u8bef");
        }
        QueryWrapper csRelWarehouseShipmentEoQueryWrapper = new QueryWrapper();
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        csRelWarehouseShipmentEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        List csRelWarehouseShipmentEoList = this.csRelWarehouseShipmentMapper.selectList((Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csRelWarehouseShipmentEoList), "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f");
        for (CsRelWarehouseShipmentEo relWarehouseShipmentEo : csRelWarehouseShipmentEoList) {
            csRelWarehouseShipmentEoQueryWrapper.clear();
            csRelWarehouseShipmentEoQueryWrapper.eq((Object)"id", (Object)relWarehouseShipmentEo.getId());
            relWarehouseShipmentEo.setValidFlag(CsValidFlagEnum.DISABLE.getCode());
            relWarehouseShipmentEo.setDr(YesNoEnum.YES.getValue());
            this.csRelWarehouseShipmentMapper.update((Object)relWarehouseShipmentEo, (Wrapper)csRelWarehouseShipmentEoQueryWrapper);
        }
        this.generateRelInfo(relWarehouseShipmentGenerateReqDto);
        return true;
    }

    private void checkParams(CsRelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        AssertUtil.isTrue(null != relWarehouseShipmentGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseCode = relWarehouseShipmentGenerateReqDto.getWarehouseCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)csLogicWarehouseEoList.get(0);
        relWarehouseShipmentGenerateReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        List detailReqDtoList = relWarehouseShipmentGenerateReqDto.getDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList), "\u7269\u6d41\u660e\u7ec6\u4fe1\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsRelWarehouseShipmentGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            String shipmentEnterpriseCode = generateDetailReqDto.getShipmentEnterpriseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), "\u7269\u6d41\u5546\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List shipmentCodeList = detailReqDtoList.stream().map(CsRelWarehouseShipmentGenerateDetailReqDto::getShipmentEnterpriseCode).collect(Collectors.toList());
        QueryWrapper csShipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csShipmenetEnterpriseEoQueryWrapper.in((Object)"shipment_enterprise_code", shipmentCodeList);
        csShipmenetEnterpriseEoQueryWrapper.in((Object)"shipment_enterprise_status", new Object[]{YesNoEnum.YES.getValue()});
        List csShipmenetEnterpriseEoList = this.csShipmenetEnterpriseMapper.selectList((Wrapper)csShipmenetEnterpriseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csShipmenetEnterpriseEoList), "\u67e5\u8be2\u4e0d\u5230\u7269\u6d41\u5546\u4fe1\u606f");
        Map shipmenetEnterpriseEoMap = csShipmenetEnterpriseEoList.stream().collect(Collectors.toMap(CsShipmenetEnterpriseEo::getShipmentEnterpriseCode, Function.identity()));
        for (CsRelWarehouseShipmentGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            String shipmentEnterpriseCode = generateDetailReqDto.getShipmentEnterpriseCode();
            CsShipmenetEnterpriseEo csShipmenetEnterpriseEo = (CsShipmenetEnterpriseEo)shipmenetEnterpriseEoMap.get(shipmentEnterpriseCode);
            AssertUtil.isTrue(null != csShipmenetEnterpriseEo, "\u7269\u6d41\u5c1a\u4fe1\u606f\u4e0d\u5b58\u5728");
            generateDetailReqDto.setShipmentEnterpriseName(csShipmenetEnterpriseEo.getShipmentEnterpriseName());
            Integer shipmentPriority = generateDetailReqDto.getShipmentPriority();
            if (null == shipmentPriority) {
                shipmentPriority = 1;
                generateDetailReqDto.setShipmentPriority(Integer.valueOf(1));
            }
            AssertUtil.isTrue(null != shipmentPriority && shipmentPriority >= 1 && shipmentPriority <= Integer.MAX_VALUE, "\u4f18\u5148\u7ea7\u53c2\u6570\u6709\u8bef");
        }
    }
}

