/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csLogicWarehouseService")
public class CsLogicWarehouseServiceImpl
implements ICsLogicWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseServiceImpl.class);
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Autowired
    ICsWarehouseAddressService csWarehouseAddressService;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsLogicWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo insertEo = new LogicWarehouseEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.logicWarehouseDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(Long id, CsLogicWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectById((Serializable)id);
        AssertUtils.notNull((Object)logicWarehouseEo, (String)"\u903b\u8f91\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        LogicWarehouseEo updateEo = new LogicWarehouseEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.logicWarehouseDomain.updateSelective((BaseEo)updateEo);
        this.cacheService.hdel("dg_inventory_able_group_logic_warehouse_code", new String[]{logicWarehouseEo.getWarehouseCode()});
        if (StringUtils.isNotBlank((CharSequence)updateEo.getWarehouseName()) && !StringUtils.equals((CharSequence)logicWarehouseEo.getWarehouseName(), (CharSequence)updateEo.getWarehouseName())) {
            this.logicInventoryDomain.updateWarehouseNameByWarehouseCode(logicWarehouseEo.getWarehouseCode(), updateEo.getWarehouseName());
            this.logicInventoryTotalDomain.updateWarehouseNameByWarehouseCode(logicWarehouseEo.getWarehouseCode(), updateEo.getWarehouseName());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsLogicWarehouseRespDto dto = this.csLogicWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(dto != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.logicWarehouseDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLogicWarehouse(CsLogicWarehouseAddReqDto addReqDto) {
        logger.info("addLogicWarehouse==>\u65b0\u589e\u903b\u8f91\u4ed3\u5e93,addReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        String warehouseCode = addReqDto.getWarehouseCode();
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.LOGIC_WAREHOUSE.getCode());
            String code = generateCodeService.getCode();
            addReqDto.setWarehouseCode(code);
        }
        Long logicWarehouseId = this.add(addReqDto);
        CsWarehouseAddressAddReqDto warehouseAddressAddReqDto = addReqDto.getWarehouseAddress();
        if (null != warehouseAddressAddReqDto) {
            warehouseAddressAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            warehouseAddressAddReqDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            warehouseAddressAddReqDto.setWarehouseId(logicWarehouseId);
            warehouseAddressAddReqDto.setWarehouseCode(warehouseCode);
            warehouseAddressAddReqDto.setWarehouseName(addReqDto.getWarehouseName());
            this.csWarehouseAddressService.add(warehouseAddressAddReqDto);
        }
        logger.info("addLogicWarehouse==>\u65b0\u589e\u903b\u8f91\u4ed3\u5e93,logicWarehouseId:{}", (Object)logicWarehouseId);
        return logicWarehouseId;
    }

    @Override
    public LogicWarehouseEo queryByWarehouseCode(String warehouseCode) {
        LogicWarehouseEo csLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(warehouseCode);
        return csLogicWarehouseEo;
    }

    @Override
    public List<LogicWarehouseEo> queryByExcludeWarehouseType(String ... warehouseType) {
        return ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().notIn((Object)"warehouse_type", (Object[])warehouseType)).list();
    }

    @Override
    public Long add(LogicWarehouseEo csLogicWarehouseEo) {
        csLogicWarehouseEo.setId(null);
        this.logicWarehouseDomain.insert((BaseEo)csLogicWarehouseEo);
        return csLogicWarehouseEo.getId();
    }

    @Override
    public Long update(LogicWarehouseEo csLogicWarehouseEo) {
        this.logicWarehouseDomain.updateSelective((BaseEo)csLogicWarehouseEo);
        return csLogicWarehouseEo.getId();
    }
}

