/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsBusinessTypeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsBusinessTypeDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsOtherStorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsBusinessTypeEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBusinessTypeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessTypeStatusEnum;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsBusinessTypeServiceImpl
implements ICsBusinessTypeService {
    @Resource
    private CsBusinessTypeDas csBusinessTypeDas;
    @Resource
    private CsOtherStorageOrderDas otherStorageOrderDas;

    @Override
    public Long addCsBusinessType(CsBusinessTypeReqDto addReqDto) {
        CsBusinessTypeEo businessType = (CsBusinessTypeEo)((ExtQueryChainWrapper)this.csBusinessTypeDas.filter().eq((Object)"business_type_name", (Object)addReqDto.getBusinessTypeName())).one();
        AssertUtil.isTrue(Objects.isNull(businessType), "\u4e1a\u52a1\u7c7b\u578b\u5df2\u5b58\u5728");
        CsBusinessTypeEo csBusinessTypeEo = new CsBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csBusinessTypeEo);
        this.csBusinessTypeDas.insert((BaseEo)csBusinessTypeEo);
        return csBusinessTypeEo.getId();
    }

    @Override
    public void modifyCsBusinessType(CsBusinessTypeReqDto modifyReqDto) {
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getId()), "\u4e1a\u52a1\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CsBusinessTypeEo businessType = (CsBusinessTypeEo)((ExtQueryChainWrapper)this.csBusinessTypeDas.filter().eq((Object)"business_type_name", (Object)modifyReqDto.getBusinessTypeName())).one();
        AssertUtil.isTrue(Objects.isNull(businessType) || Objects.nonNull(businessType) && modifyReqDto.getId().equals(businessType.getId()), "\u4e1a\u52a1\u7c7b\u578b\u5df2\u5b58\u5728");
        CsBusinessTypeEo csBusinessTypeEo = new CsBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csBusinessTypeEo);
        this.csBusinessTypeDas.updateSelective((BaseEo)csBusinessTypeEo);
    }

    @Override
    public void modifyCsBusinessTypeStatus(CsBusinessTypeReqDto modifyReqDto) {
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getId()), "\u4e1a\u52a1\u7c7b\u578b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getStatus()), "\u4e1a\u52a1\u7c7b\u578b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        CsBusinessTypeEo csBusinessTypeEo = new CsBusinessTypeEo();
        csBusinessTypeEo.setId(modifyReqDto.getId());
        csBusinessTypeEo.setStatus(modifyReqDto.getStatus());
        this.csBusinessTypeDas.updateSelective((BaseEo)csBusinessTypeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsBusinessType(String ids) {
        AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)ids), "\u5220\u9664\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String[] removeIds = ids.split(",");
        Integer count = ((ExtQueryChainWrapper)this.otherStorageOrderDas.filter().in((Object)"business_type", Arrays.asList(removeIds))).count();
        AssertUtil.isTrue(count == 0, "\u8be5\u4e1a\u52a1\u7c7b\u578b\u5df2\u88ab\u4f7f\u7528,\u4e0d\u53ef\u5220\u9664");
        for (String id : removeIds) {
            this.csBusinessTypeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsBusinessTypeRespDto queryById(Long id) {
        CsBusinessTypeEo csBusinessTypeEo = (CsBusinessTypeEo)this.csBusinessTypeDas.selectByPrimaryKey(id);
        CsBusinessTypeRespDto csBusinessTypeRespDto = new CsBusinessTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)csBusinessTypeEo, (BaseVo)csBusinessTypeRespDto);
        return csBusinessTypeRespDto;
    }

    @Override
    public CsBusinessTypeRespDto queryByCode(String code) {
        CsBusinessTypeEo csBusinessTypeEo = new CsBusinessTypeEo();
        csBusinessTypeEo.setCode(code);
        csBusinessTypeEo = (CsBusinessTypeEo)this.csBusinessTypeDas.selectOne((BaseEo)csBusinessTypeEo);
        CsBusinessTypeRespDto csBusinessTypeRespDto = new CsBusinessTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)csBusinessTypeEo, (BaseVo)csBusinessTypeRespDto);
        return csBusinessTypeRespDto;
    }

    @Override
    public List<CsBusinessTypeRespDto> queryByIds(CsBusinessTypeReqDto csBusinessTypeReqDto) {
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)csBusinessTypeReqDto.getIds()), "id\u4e0d\u80fd\u4e3a\u7a7a");
        List csBusinessTypeEos = ((ExtQueryChainWrapper)this.csBusinessTypeDas.filter().in((Object)"id", (Collection)csBusinessTypeReqDto.getIds())).list();
        ArrayList<CsBusinessTypeRespDto> dtoList = new ArrayList<CsBusinessTypeRespDto>();
        if (CollectionUtil.isNotEmpty((Collection)csBusinessTypeEos)) {
            DtoHelper.eoList2DtoList((Collection)csBusinessTypeEos, dtoList, CsBusinessTypeRespDto.class);
        }
        return dtoList;
    }

    @Override
    public PageInfo<CsBusinessTypeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CsBusinessTypeReqDto csBusinessTypeReqDto = (CsBusinessTypeReqDto)JSON.parseObject((String)filter, CsBusinessTypeReqDto.class);
        CsBusinessTypeEo csBusinessTypeEo = new CsBusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)csBusinessTypeReqDto, (BaseEo)csBusinessTypeEo);
        PageInfo eoPageInfo = this.csBusinessTypeDas.selectPage((BaseEo)csBusinessTypeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsBusinessTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<Long, String> queryByType(String type) {
        List<CsBusinessTypeEo> typeEos = this.queryEoListByType(type);
        Map<Long, String> typeMap = CollectionUtil.isNotEmpty(typeEos) ? typeEos.stream().filter(t -> t.getStatus().equals(CsBusinessTypeStatusEnum.ENABLE.getCode())).collect(Collectors.toMap(BaseEo::getId, CsBusinessTypeEo::getBusinessTypeName)) : new HashMap<Long, String>(0);
        return typeMap;
    }

    private List<CsBusinessTypeEo> queryEoListByType(String type) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csBusinessTypeDas.filter().eq((Object)"type", (Object)type)).orderByAsc((Object)"can_delete")).orderByDesc((Object)"create_time")).list();
    }

    @Override
    public List<CsBusinessTypeRespDto> queryListByType(String type) {
        ArrayList<CsBusinessTypeRespDto> typeList = new ArrayList<CsBusinessTypeRespDto>();
        List<CsBusinessTypeEo> typeEos = this.queryEoListByType(type);
        if (CollectionUtil.isNotEmpty(typeEos)) {
            DtoHelper.eoList2DtoList(typeEos, typeList, CsBusinessTypeRespDto.class);
        }
        return typeList;
    }
}

