/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseAreaMappingReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseAreaMappingRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseAreaMappingService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseAreaMappingDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseAreaMappingEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WarehouseAreaMappingServiceImpl
implements IWarehouseAreaMappingService {
    @Resource
    WarehouseAreaMappingDas warehouseAreaMappingDas;
    @Resource
    CodeGenerateUtil codeGenerateUtil;

    @Override
    public Long addWarehouseAreaMapping(WarehouseAreaMappingReqDto addReqDto) {
        WarehouseAreaMappingEo one;
        WarehouseAreaMappingEo warehouseAreaMappingEo = new WarehouseAreaMappingEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)warehouseAreaMappingEo);
        if (Strings.isNotBlank((String)addReqDto.getCenterWarehouseCode()) && Strings.isNotBlank((String)addReqDto.getInWarehouseCode())) {
            AssertUtil.isTrue(!addReqDto.getCenterWarehouseCode().equals(addReqDto.getInWarehouseCode()), "\u4e2d\u8f6c\u7269\u7406\u4ed3\u4e0e\u8c03\u5165\u7269\u7406\u4ed3\u4e0d\u80fd\u76f8\u540c");
        }
        if (Objects.nonNull(one = (WarehouseAreaMappingEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAreaMappingDas.filter().eq((Object)"province_code", (Object)addReqDto.getProvinceCode())).eq((Object)"source_warehouse_code", (Object)addReqDto.getSourceWarehouseCode())).one())) {
            warehouseAreaMappingEo.setId(one.getId());
            warehouseAreaMappingEo.setCode(one.getCode());
            warehouseAreaMappingEo.setCreatePerson(one.getCreatePerson());
            warehouseAreaMappingEo.setCreateTime(one.getCreateTime());
        }
        if (StringUtils.isBlank((CharSequence)warehouseAreaMappingEo.getCode())) {
            warehouseAreaMappingEo.setCode(this.codeGenerateUtil.generateNo("KMH", 8));
        }
        try {
            if (warehouseAreaMappingEo.getId() != null) {
                this.warehouseAreaMappingDas.update((BaseEo)warehouseAreaMappingEo);
            } else {
                this.warehouseAreaMappingDas.insert((BaseEo)warehouseAreaMappingEo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u6570\u636e\u91cd\u590d");
        }
        return warehouseAreaMappingEo.getId();
    }

    @Override
    public void modifyWarehouseAreaMapping(WarehouseAreaMappingReqDto modifyReqDto) {
        WarehouseAreaMappingEo warehouseAreaMappingEo = new WarehouseAreaMappingEo();
        WarehouseAreaMappingEo areaMappingEo = (WarehouseAreaMappingEo)this.warehouseAreaMappingDas.getMapper().findById(modifyReqDto.getId());
        AssertUtils.notNull((Object)areaMappingEo, (String)"\u627e\u4e0d\u5230\u8be5\u89c4\u5219");
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseAreaMappingEo);
        warehouseAreaMappingEo.setId(areaMappingEo.getId());
        warehouseAreaMappingEo.setCode(areaMappingEo.getCode());
        this.warehouseAreaMappingDas.update((BaseEo)warehouseAreaMappingEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseAreaMapping(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseAreaMappingDas.deleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseAreaMappingRespDto queryById(Long id) {
        WarehouseAreaMappingEo warehouseAreaMappingEo = (WarehouseAreaMappingEo)this.warehouseAreaMappingDas.selectByPrimaryKey(id);
        WarehouseAreaMappingRespDto warehouseAreaMappingRespDto = new WarehouseAreaMappingRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseAreaMappingEo, (BaseVo)warehouseAreaMappingRespDto);
        return warehouseAreaMappingRespDto;
    }

    @Override
    public PageInfo<WarehouseAreaMappingRespDto> queryByPage(WarehouseAreaMappingReqDto warehouseAreaMappingReqDto) {
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseAreaMappingDas.filter().like(StringUtils.isNotBlank((CharSequence)warehouseAreaMappingReqDto.getCode()), (Object)"code", (Object)warehouseAreaMappingReqDto.getCode())).eq(StringUtils.isNotBlank((CharSequence)warehouseAreaMappingReqDto.getProvinceCode()), (Object)"province_code", (Object)warehouseAreaMappingReqDto.getProvinceCode())).eq(StringUtils.isNotBlank((CharSequence)warehouseAreaMappingReqDto.getType()), (Object)"type", (Object)warehouseAreaMappingReqDto.getType())).eq(StringUtils.isNotBlank((CharSequence)warehouseAreaMappingReqDto.getInWarehouseCode()), (Object)"in_warehouse_code", (Object)warehouseAreaMappingReqDto.getInWarehouseCode())).eq(StringUtils.isNotBlank((CharSequence)warehouseAreaMappingReqDto.getSourceWarehouseCode()), (Object)"source_warehouse_code", (Object)warehouseAreaMappingReqDto.getSourceWarehouseCode())).eq(StringUtils.isNotBlank((CharSequence)warehouseAreaMappingReqDto.getCenterWarehouseCode()), (Object)"center_warehouse_code", (Object)warehouseAreaMappingReqDto.getCenterWarehouseCode())).eq(Objects.nonNull(warehouseAreaMappingReqDto.getStatus()), (Object)"status", (Object)warehouseAreaMappingReqDto.getStatus())).in(CollectionUtil.isNotEmpty((Collection)warehouseAreaMappingReqDto.getProvinceCodeList()), (Object)"province_code", (Collection)warehouseAreaMappingReqDto.getProvinceCodeList())).in(CollectionUtil.isNotEmpty((Collection)warehouseAreaMappingReqDto.getSourceWarehouseCodeList()), (Object)"source_warehouse_code", (Collection)warehouseAreaMappingReqDto.getSourceWarehouseCodeList())).orderByDesc((Object)"create_time")).page(warehouseAreaMappingReqDto.getPageNum(), warehouseAreaMappingReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseAreaMappingRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchSaveWarehouseAreaMapping(List<WarehouseAreaMappingReqDto> addReqDto) {
    }

    @Override
    public void enable(WarehouseAreaMappingReqDto addReqDto) {
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)addReqDto.getIds()), "\u4fee\u6539\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getStatus()), "\u4fee\u6539\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        List warehouseAreaMappingEos = this.warehouseAreaMappingDas.getMapper().selectBatchIds((Collection)addReqDto.getIds());
        for (WarehouseAreaMappingEo warehouseAreaMappingEo : warehouseAreaMappingEos) {
            WarehouseAreaMappingEo updateEo = new WarehouseAreaMappingEo();
            updateEo.setId(warehouseAreaMappingEo.getId());
            updateEo.setStatus(addReqDto.getStatus());
            this.warehouseAreaMappingDas.updateSelective((BaseEo)updateEo);
        }
    }
}

