/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.ReturnorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsReturnOrderCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IMergeNoticeTransferService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.MergeNoticeTransferDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.MergeNoticeTransferEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderDeliveryInfoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.MergeNoticeTransferMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.MergeNoticeTransferDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MergeNoticeTransferServiceImpl
implements IMergeNoticeTransferService {
    private static final Logger log = LoggerFactory.getLogger(MergeNoticeTransferServiceImpl.class);
    @Autowired
    MergeNoticeTransferMapper mergeNoticeTransferMapper;
    @Autowired
    MergeNoticeTransferDas mergeNoticeTransferDas;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    ConsignmentOrderDas consignmentOrderDas;
    @Autowired
    CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    ConsignmentOrderMapper consignmentOrderMapper;
    @Autowired
    ConsignmentOrderDeliveryInfoMapper consignmentOrderDeliveryInfoMapper;
    @Autowired
    MqService mqService;
    @Autowired
    CodeGenerateUtil codeGenerateUtil;

    @Override
    public List<MergeNoticeTransferDto> queryWaitMergeList() {
        List mergeNoticeTransferEos = this.mergeNoticeTransferMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MergeNoticeTransferEo.class).eq(MergeNoticeTransferEo::getOrderStatus, (Object)0)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtil.isEmpty((Collection)mergeNoticeTransferEos)) {
            return Lists.newArrayList();
        }
        return BeanUtil.copyToList((Collection)mergeNoticeTransferEos, MergeNoticeTransferDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doMerge(MergeNoticeTransferEo mergeNoticeTransferEo) {
        AssertUtils.notNull((Object)mergeNoticeTransferEo, (String)"\u5408\u5355\u4fe1\u606f\u5bf9\u8c61\u4e3a\u7a7a");
        AssertUtils.notBlank((String)mergeNoticeTransferEo.getWmsConsignmentNo(), (String)"\u6258\u8fd0\u5355\u53f7\u4e3a\u7a7a");
        if (0 != mergeNoticeTransferEo.getOrderStatus()) {
            throw new BizException("\u8be5\u8f6c\u8fd0\u5408\u5355\u5df2\u6267\u884c\u5b8c");
        }
        List mergeNoticeTransferEos = this.mergeNoticeTransferMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MergeNoticeTransferEo.class).eq(MergeNoticeTransferEo::getWmsConsignmentNo, (Object)mergeNoticeTransferEo.getWmsConsignmentNo())).eq(MergeNoticeTransferEo::getOrderStatus, (Object)1)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtil.isNotEmpty((Collection)mergeNoticeTransferEos)) {
            MergeNoticeTransferEo updateEo = new MergeNoticeTransferEo();
            updateEo.setId(mergeNoticeTransferEo.getId());
            updateEo.setOrderStatus(Integer.valueOf(1));
            updateEo.setExtension("\u8be5\u6258\u8fd0\u5355\u53f7\uff0c\u5df2\u5408\u5355\u63a8\u9001");
            this.mergeNoticeTransferDas.updateSelective((BaseEo)updateEo);
            return;
        }
        List<InOutResultOrderEo> inOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getConsignmentNo, (Object)mergeNoticeTransferEo.getWmsConsignmentNo())).eq(InOutResultOrderEo::getOrderStatus, (Object)BaseOrderStatusEnum.ORO_DONE_OUT.getCode())).eq(InOutResultOrderEo::getOrderType, (Object)"out")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u7ed3\u679c\u5355\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        List relevanceNoList = inOutResultOrderEos.stream().map(InOutResultOrderEo::getRelevanceNo).distinct().collect(Collectors.toList());
        List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).in(CsTransferOrderEo::getTransferOrderNo, relevanceNoList)).isNull(CsTransferOrderEo::getSecondTransferOrderNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)csTransferOrderEos, (String)"\u8c03\u62e8\u5355\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)csTransferOrderEos.get(0);
        List transferNoList = csTransferOrderEos.stream().map(CsTransferOrderEo::getTransferOrderNo).distinct().collect(Collectors.toList());
        log.info("\u5408\u5355 \u8c03\u62e8\u5355 \u5355\u53f7: {}", (Object)LogUtils.buildLogContent(transferNoList));
        inOutResultOrderEos = inOutResultOrderEos.stream().filter(o -> transferNoList.contains(o.getRelevanceNo())).collect(Collectors.toList());
        List outResultOrderNoList = inOutResultOrderEos.stream().map(InOutResultOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
        List inOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderDetailEo.class).in(InOutResultOrderDetailEo::getDocumentNo, outResultOrderNoList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inOutResultOrderDetailEos, (String)"\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        List consignmentOrderEos = this.consignmentOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).in(ConsignmentOrderEo::getOutResultNo, outResultOrderNoList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)consignmentOrderEos, (String)"\u8fd0\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List consignmentOrderDeliveryInfoEos = this.consignmentOrderDeliveryInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery(ConsignmentOrderDeliveryInfoEo.class).eq(ConsignmentOrderDeliveryInfoEo::getConsignmentNo, (Object)((ConsignmentOrderEo)consignmentOrderEos.get(0)).getConsignmentNo()));
        AssertUtils.notEmpty((Collection)consignmentOrderDeliveryInfoEos, (String)"\u8fd0\u5355\u914d\u9001\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        this.doAllotSaleNoticeConsignmentOrder(csTransferOrderEo, inOutResultOrderEos, inOutResultOrderDetailEos, consignmentOrderEos, (ConsignmentOrderDeliveryInfoEo)consignmentOrderDeliveryInfoEos.get(0));
        MergeNoticeTransferEo updateEo = new MergeNoticeTransferEo();
        updateEo.setId(mergeNoticeTransferEo.getId());
        updateEo.setMergeOrderNos(StringUtils.join(outResultOrderNoList, (String)","));
        updateEo.setMergeTime(new Date());
        updateEo.setOrderStatus(Integer.valueOf(1));
        this.mergeNoticeTransferDas.updateSelective((BaseEo)updateEo);
    }

    private void doAllotSaleNoticeConsignmentOrder(CsTransferOrderEo transferOrderEo, List<InOutResultOrderEo> csOutResultOrderEos, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos, List<ConsignmentOrderEo> consignmentOrderEos, ConsignmentOrderDeliveryInfoEo deliveryInfoEo) {
        List<WmsReturnOrderCreateReqDto.TransferDto> transferDtoList;
        MessageVo messageVo = new MessageVo();
        WmsReturnOrderCreateReqDto wmsReturnOrderCreateReqDto = new WmsReturnOrderCreateReqDto();
        String outPhysicsWarehouseCode = transferOrderEo.getOutPhysicsWarehouseCode();
        AssertUtils.notBlank((String)outPhysicsWarehouseCode, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        List outPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(outPhysicsWarehouseCode);
        AssertUtils.notEmpty((Collection)outPhysicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo outPhysicsWarehouseEo = (PhysicsWarehouseEo)outPhysicsWarehouseEos.get(0);
        WarehouseAddressEo outWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(outPhysicsWarehouseCode);
        AssertUtils.notNull((Object)outWarehouseAddressEo, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u5730\u5740\u67e5\u8be2\u4e0d\u5b58\u5728");
        String inPhysicsWarehouseCode = transferOrderEo.getInPhysicsWarehouseCode();
        AssertUtils.notBlank((String)inPhysicsWarehouseCode, (String)"\u5165\u5e93\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        List inPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(inPhysicsWarehouseCode);
        AssertUtils.notEmpty((Collection)inPhysicsWarehouseEos, (String)"\u5165\u5e93\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo inPhysicsWarehouseEo = (PhysicsWarehouseEo)inPhysicsWarehouseEos.get(0);
        WarehouseAddressEo inWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(inPhysicsWarehouseCode);
        AssertUtils.notNull((Object)inWarehouseAddressEo, (String)"\u5165\u5e93\u7269\u7406\u4ed3\u5730\u5740\u67e5\u8be2\u4e0d\u5b58\u5728");
        String saleOrderNo = transferOrderEo.getSaleOrderNo();
        List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(saleOrderNo);
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = receiveDeliveryNoticeOrderEos.stream().filter(o -> "delivery".equals(o.getOrderType())).findFirst().orElse(null);
        AssertUtils.notNull((Object)deliveryNoticeOrderEo, (String)"\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        ContactDto contactDto = (ContactDto)JSON.parseObject((String)deliveryNoticeOrderEo.getExtension(), ContactDto.class);
        AssertUtils.notNull((Object)contactDto, (String)"\u53d1\u8d27\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        wmsReturnOrderCreateReqDto.setWarehouseCode(inPhysicsWarehouseCode);
        WmsReturnOrderCreateReqDto.ExtendInfo extendInfo = new WmsReturnOrderCreateReqDto.ExtendInfo();
        extendInfo.setDocumentNo(csOutResultOrderEos.stream().map(InOutResultOrderEo::getPreOrderNo).distinct().collect(Collectors.joining(",")));
        extendInfo.setPhysicWarehouseCode(csOutResultOrderEos.get(0).getInPhysicsWarehouseCode());
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getNextPhysicsWarehouseCode())) {
            transferDtoList = this.twoStageLogistics(consignmentOrderEos, deliveryInfoEo, outPhysicsWarehouseEo, inPhysicsWarehouseEo, inWarehouseAddressEo, contactDto);
        } else {
            String nextPhysicsWarehouseCode = transferOrderEo.getNextPhysicsWarehouseCode();
            AssertUtils.notBlank((String)nextPhysicsWarehouseCode, (String)"\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
            List nextPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(nextPhysicsWarehouseCode);
            AssertUtils.notEmpty((Collection)nextPhysicsWarehouseEos, (String)"\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            PhysicsWarehouseEo nextPhysicsWarehouseEo = (PhysicsWarehouseEo)nextPhysicsWarehouseEos.get(0);
            WarehouseAddressEo nextWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(nextPhysicsWarehouseCode);
            AssertUtils.notNull((Object)nextWarehouseAddressEo, (String)"\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u5730\u5740\u67e5\u8be2\u4e0d\u5b58\u5728");
            transferDtoList = this.threeStageLogistics(consignmentOrderEos, deliveryInfoEo, outPhysicsWarehouseEo, inPhysicsWarehouseEo, inWarehouseAddressEo, nextPhysicsWarehouseEo, nextWarehouseAddressEo, contactDto);
        }
        extendInfo.setTransferArray(transferDtoList);
        wmsReturnOrderCreateReqDto.setExtendInfo(extendInfo);
        HashMap itemLineMap = Maps.newHashMap();
        for (InOutResultOrderDetailEo csOutResultOrderDetailEo : csOutResultOrderDetailEos) {
            String mapKey = csOutResultOrderDetailEo.getSkuCode() + "_" + csOutResultOrderDetailEo.getBatch();
            WmsItemLine itemLine = (WmsItemLine)itemLineMap.get(mapKey);
            if (null == itemLine) {
                itemLine = new WmsItemLine();
                itemLine.setCargoCode(csOutResultOrderDetailEo.getSkuCode());
                itemLine.setCargoName(csOutResultOrderDetailEo.getSkuName());
                itemLine.setBatch(csOutResultOrderDetailEo.getBatch());
                itemLine.setPlanQuantity(csOutResultOrderDetailEo.getDoneQuantity());
                itemLine.setTradeOrderItemId(null != csOutResultOrderDetailEo.getPreOrderItemId() ? csOutResultOrderDetailEo.getPreOrderItemId().toString() : csOutResultOrderDetailEo.getId().toString());
                String productDate = null != csOutResultOrderDetailEo.getProduceTime() ? DateUtils.formatYMDHms(csOutResultOrderDetailEo.getProduceTime()) : null;
                String arrivalDate = null != csOutResultOrderDetailEo.getExpireTime() ? DateUtils.formatYMDHms(csOutResultOrderDetailEo.getExpireTime()) : null;
                itemLine.setProductDate(productDate);
                itemLine.setArrivalDate(arrivalDate);
            } else {
                itemLine.setPlanQuantity(BigDecimalUtils.add((BigDecimal)itemLine.getPlanQuantity(), (BigDecimal)csOutResultOrderDetailEo.getDoneQuantity()));
            }
            itemLineMap.put(mapKey, itemLine);
        }
        log.info("\u5408\u5355\u63a8\u9001\uff0c\u5546\u54c1\u884c\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent(itemLineMap.values()));
        wmsReturnOrderCreateReqDto.setItemLines((List)Lists.newArrayList(itemLineMap.values()));
        this.transactionCallBackService.execute(() -> {
            ReturnorderCreateRequestDto.SenderInfo senderInfo = new ReturnorderCreateRequestDto.SenderInfo();
            senderInfo.setName(outWarehouseAddressEo.getContacts());
            senderInfo.setMobile(outWarehouseAddressEo.getPhone());
            senderInfo.setProvince(outWarehouseAddressEo.getProvince());
            senderInfo.setCity(outWarehouseAddressEo.getCity());
            senderInfo.setArea(outWarehouseAddressEo.getDistrict());
            senderInfo.setDetailAddress(outWarehouseAddressEo.getDetailAddress());
            wmsReturnOrderCreateReqDto.setSenderInfo(senderInfo);
            messageVo.setData((Object)JSON.toJSONString((Object)wmsReturnOrderCreateReqDto));
            this.mqService.returnOrderToWmsProcessor(messageVo);
        });
    }

    private List<WmsReturnOrderCreateReqDto.TransferDto> threeStageLogistics(List<ConsignmentOrderEo> consignmentOrderEos, ConsignmentOrderDeliveryInfoEo deliveryInfoEo, PhysicsWarehouseEo outPhysicsWarehouseEo, PhysicsWarehouseEo inPhysicsWarehouseEo, WarehouseAddressEo inWarehouseAddressEo, PhysicsWarehouseEo nextPhysicsWarehouseEo, WarehouseAddressEo nextWarehouseAddressEo, ContactDto contactDto) {
        ArrayList transferDtoList = Lists.newArrayList();
        WmsReturnOrderCreateReqDto.TransferDto oneTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        oneTransferDto.setPhysicWarehouseCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setPhysicWarehouseName(outPhysicsWarehouseEo.getWarehouseName());
        oneTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEos.get(0).getSecondaryConsignmentNo(), outPhysicsWarehouseEo.getSampleCode()));
        oneTransferDto.setOcsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        oneTransferDto.setOriginWmsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        oneTransferDto.setTransferFlag(outPhysicsWarehouseEo.getSampleCode());
        oneTransferDto.setReceivePerson(inWarehouseAddressEo.getContacts());
        oneTransferDto.setReceivePhone(inWarehouseAddressEo.getPhone());
        oneTransferDto.setReceiveProvince(inWarehouseAddressEo.getProvince());
        oneTransferDto.setReceiveCity(inWarehouseAddressEo.getCity());
        oneTransferDto.setReceiveDistrict(inWarehouseAddressEo.getDistrict());
        oneTransferDto.setReceiveDetailAddress(inWarehouseAddressEo.getDetailAddress());
        oneTransferDto.setLogisticsCode(deliveryInfoEo.getCarrierCode());
        oneTransferDto.setLogisticsName(deliveryInfoEo.getCarrierName());
        oneTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        oneTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        oneTransferDto.setCustomerCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setTransferSort("1");
        transferDtoList.add(oneTransferDto);
        WmsReturnOrderCreateReqDto.TransferDto twoTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        twoTransferDto.setPhysicWarehouseCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setPhysicWarehouseName(inPhysicsWarehouseEo.getWarehouseName());
        twoTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEos.get(0).getSecondaryConsignmentNo(), inPhysicsWarehouseEo.getSampleCode()));
        String twoConsignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        twoTransferDto.setOcsConsignmentNo(twoConsignmentNo);
        twoTransferDto.setOriginWmsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        twoTransferDto.setTransferFlag(inPhysicsWarehouseEo.getSampleCode());
        twoTransferDto.setReceivePerson(nextWarehouseAddressEo.getContacts());
        twoTransferDto.setReceivePhone(nextWarehouseAddressEo.getPhone());
        twoTransferDto.setReceiveProvince(nextWarehouseAddressEo.getProvince());
        twoTransferDto.setReceiveCity(nextWarehouseAddressEo.getCity());
        twoTransferDto.setReceiveDistrict(nextWarehouseAddressEo.getDistrict());
        twoTransferDto.setReceiveDetailAddress(nextWarehouseAddressEo.getDetailAddress());
        twoTransferDto.setLogisticsCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setLogisticsName(inPhysicsWarehouseEo.getWarehouseName() + "\u8363\u5e86");
        twoTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        twoTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        twoTransferDto.setCustomerCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setTransferSort("2");
        transferDtoList.add(twoTransferDto);
        WmsReturnOrderCreateReqDto.TransferDto threeTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        threeTransferDto.setPhysicWarehouseCode(nextPhysicsWarehouseEo.getWarehouseCode());
        threeTransferDto.setPhysicWarehouseName(nextPhysicsWarehouseEo.getWarehouseName());
        threeTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEos.get(0).getSecondaryConsignmentNo(), nextPhysicsWarehouseEo.getSampleCode()));
        String threeConsignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        threeTransferDto.setOcsConsignmentNo(threeConsignmentNo);
        threeTransferDto.setOriginWmsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        threeTransferDto.setTransferFlag(nextPhysicsWarehouseEo.getSampleCode());
        threeTransferDto.setReceivePerson(contactDto.getContacts());
        threeTransferDto.setReceivePhone(contactDto.getPhone());
        threeTransferDto.setReceiveProvince(contactDto.getProvince());
        threeTransferDto.setReceiveCity(contactDto.getCity());
        threeTransferDto.setReceiveDistrict(contactDto.getDistrict());
        threeTransferDto.setReceiveDetailAddress(contactDto.getDetailAddress());
        threeTransferDto.setLogisticsCode(nextPhysicsWarehouseEo.getWarehouseCode());
        threeTransferDto.setLogisticsName(nextPhysicsWarehouseEo.getWarehouseName() + "\u8363\u5e86");
        threeTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        threeTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        threeTransferDto.setCustomerCode(nextPhysicsWarehouseEo.getWarehouseCode());
        threeTransferDto.setTransferSort("3");
        transferDtoList.add(threeTransferDto);
        this.updateConsignmentOrder(consignmentOrderEos, twoConsignmentNo, threeConsignmentNo);
        return transferDtoList;
    }

    private void updateConsignmentOrder(List<ConsignmentOrderEo> consignmentOrderEos, String twoConsignmentNo, String threeConsignmentNo) {
        for (ConsignmentOrderEo consignmentOrderEo : consignmentOrderEos) {
            log.info("updateConsignmentOrder\u8fd0\u5355\u4fee\u6539:{},\u7b2c\u4e8c\u6bb5\u8fd0\u5355:{},\u7b2c\u4e09\u6bb5\u8fd0\u5355:{}", new Object[]{JSON.toJSONString((Object)consignmentOrderEo), JSON.toJSONString((Object)twoConsignmentNo), JSON.toJSONString((Object)threeConsignmentNo)});
            ConsignmentOrderEo updateEo = new ConsignmentOrderEo();
            updateEo.setId(consignmentOrderEo.getId());
            updateEo.setSecondConsignmentNo(twoConsignmentNo);
            updateEo.setThirdConsignmentNo(threeConsignmentNo);
            this.consignmentOrderDas.updateSelective((BaseEo)updateEo);
        }
    }

    private List<WmsReturnOrderCreateReqDto.TransferDto> twoStageLogistics(List<ConsignmentOrderEo> consignmentOrderEos, ConsignmentOrderDeliveryInfoEo deliveryInfoEo, PhysicsWarehouseEo outPhysicsWarehouseEo, PhysicsWarehouseEo inPhysicsWarehouseEo, WarehouseAddressEo inWarehouseAddressEo, ContactDto contactDto) {
        ArrayList transferDtoList = Lists.newArrayList();
        WmsReturnOrderCreateReqDto.TransferDto oneTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        oneTransferDto.setPhysicWarehouseCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setPhysicWarehouseName(outPhysicsWarehouseEo.getWarehouseName());
        oneTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEos.get(0).getSecondaryConsignmentNo(), outPhysicsWarehouseEo.getSampleCode()));
        oneTransferDto.setOcsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        oneTransferDto.setOriginWmsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        oneTransferDto.setTransferFlag(outPhysicsWarehouseEo.getSampleCode());
        oneTransferDto.setReceivePerson(inWarehouseAddressEo.getContacts());
        oneTransferDto.setReceivePhone(inWarehouseAddressEo.getPhone());
        oneTransferDto.setReceiveProvince(inWarehouseAddressEo.getProvince());
        oneTransferDto.setReceiveCity(inWarehouseAddressEo.getCity());
        oneTransferDto.setReceiveDistrict(inWarehouseAddressEo.getDistrict());
        oneTransferDto.setReceiveDetailAddress(inWarehouseAddressEo.getDetailAddress());
        oneTransferDto.setLogisticsCode(deliveryInfoEo.getCarrierCode());
        oneTransferDto.setLogisticsName(deliveryInfoEo.getCarrierName());
        oneTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        oneTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        oneTransferDto.setCustomerCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setTransferSort("1");
        transferDtoList.add(oneTransferDto);
        WmsReturnOrderCreateReqDto.TransferDto twoTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        twoTransferDto.setPhysicWarehouseCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setPhysicWarehouseName(inPhysicsWarehouseEo.getWarehouseName());
        twoTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEos.get(0).getSecondaryConsignmentNo(), inPhysicsWarehouseEo.getSampleCode()));
        String twoConsignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        twoTransferDto.setOcsConsignmentNo(twoConsignmentNo);
        twoTransferDto.setOriginWmsConsignmentNo(consignmentOrderEos.get(0).getOriginWmsConsignmentNo());
        twoTransferDto.setTransferFlag(inPhysicsWarehouseEo.getSampleCode());
        twoTransferDto.setReceivePerson(contactDto.getContacts());
        twoTransferDto.setReceivePhone(contactDto.getPhone());
        twoTransferDto.setReceiveProvince(contactDto.getProvince());
        twoTransferDto.setReceiveCity(contactDto.getCity());
        twoTransferDto.setReceiveDistrict(contactDto.getDistrict());
        twoTransferDto.setReceiveDetailAddress(contactDto.getDetailAddress());
        twoTransferDto.setLogisticsCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setLogisticsName(inPhysicsWarehouseEo.getWarehouseName() + "\u8363\u5e86");
        twoTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        twoTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        twoTransferDto.setCustomerCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setTransferSort("2");
        transferDtoList.add(twoTransferDto);
        this.updateConsignmentOrder(consignmentOrderEos, null, twoConsignmentNo);
        return transferDtoList;
    }
}

