/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.AbstractCsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderOperateStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.WarehouseAreaMappingMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics.InOutTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@CsBasicsOrderOperateStrategy(strategyName="inOutNoticeOrder")
@Component(value="CsinOutNoticeOrderbasicsOrderStrategyService")
public class CsInOutNoticeOrderOperateServiceImpl
extends AbstractCsBasicsOrderOperateService {
    private static final Logger logger = LoggerFactory.getLogger(CsInOutNoticeOrderOperateServiceImpl.class);
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    MqService mqService;
    @Autowired
    CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    private WarehouseAreaMappingMapper warehouseAreaMappingMapper;
    @Autowired
    TransactionCallBackService transactionCallBackService;

    private void sendWms(InOutNoticeOrderEo outNoticeOrderEo, List<InOutNoticeOrderDetailEo> detailEoList, Boolean inFlag, Boolean sendWms) {
        if (CsPcpBusinessTypeEnum.cAllotList().contains(outNoticeOrderEo.getBusinessType())) {
            if (outNoticeOrderEo.getBusinessType().equals(CsPcpBusinessTypeEnum.CC_ALLOT.getCode())) {
                logger.info("CC\u8c03\u62e8\u65e0\u9700\u901a\u77e5wms");
                return;
            }
            if (outNoticeOrderEo.getBusinessType().equals(CsPcpBusinessTypeEnum.CB_ALLOT.getCode()) && "out".equals(outNoticeOrderEo.getOrderType())) {
                logger.info("CB\u8c03\u62e8\uff0c\u51fa\u5e93\u901a\u77e5\u65e0\u9700\u901a\u77e5wms");
                return;
            }
            if (outNoticeOrderEo.getBusinessType().equals(CsPcpBusinessTypeEnum.BC_ALLOT.getCode()) && "in".equals(outNoticeOrderEo.getOrderType())) {
                logger.info("BC\u8c03\u62e8\uff0c\u5165\u5e93\u901a\u77e5\u65e0\u9700\u901a\u77e5wms");
                return;
            }
            if (outNoticeOrderEo.getBusinessType().equals(CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode()) && "in".equals(outNoticeOrderEo.getOrderType())) {
                logger.info("\u9ea6\u4f18BC\u8c03\u62e8\uff0c\u5165\u5e93\u901a\u77e5\u65e0\u9700\u901a\u77e5wms");
                return;
            }
            if (outNoticeOrderEo.getBusinessType().equals(CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode()) && "in".equals(outNoticeOrderEo.getOrderType())) {
                logger.info("BC\u540c\u7ec4\u7ec7\u8c03\u62e8\uff0c\u5165\u5e93\u901a\u77e5\u65e0\u9700\u901a\u77e5wms\uff0c\u81ea\u52a8\u5b8c\u6210");
                return;
            }
        }
        if (!sendWms.booleanValue()) {
            logger.info("\u751f\u6210\u51fa\u5165\u5e93\u901a\u77e5\u5355,\u5355\u53f7documentNo\uff1a{}\uff0c\u8c03\u62e8\u5355\u5165\u5e93\u51fa\u5165\u5e93\u7269\u7406\u4ed3\u4e00\u81f4 \u6216\u903b\u8f91\u4ed3\u70ba\u62a5\u5e9f\u4ed3 \u6216\u8005\u903b\u8f91\u4ed3\u4e3a\u865a\u62df\u4ed3 \u65e0\u9700\u901a\u77e5wms", (Object)outNoticeOrderEo.getDocumentNo());
            return;
        }
        if (!CsRelevanceTableNameEnum.CS_BATCH_ADJUSTMENT_ORDER.getCode().equals(outNoticeOrderEo.getRelevanceTableName()) && !CsRelevanceTableNameEnum.CS_ADJUSTMENT_ORDER.getCode().equals(outNoticeOrderEo.getRelevanceTableName())) {
            MessageVo messageVo;
            String warehouseCode = "";
            if (inFlag.booleanValue()) {
                warehouseCode = outNoticeOrderEo.getInLogicWarehouseCode();
                messageVo = this.joinInWmsSendInfo(outNoticeOrderEo, detailEoList);
            } else {
                warehouseCode = outNoticeOrderEo.getOutLogicWarehouseCode();
                messageVo = this.joinOutWmsSendInfo(outNoticeOrderEo, detailEoList);
            }
            AssertUtils.notBlank((String)warehouseCode, (String)"\u901a\u77e5\u5355\u4ed3\u5e93\u7f16\u53f7\u4e0d\u5b58\u5728");
            List logicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)warehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)logicWarehouseEos, (String)"\u901a\u77e5\u5355\u4ed3\u5e93\u7f16\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728");
            LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
            if (Objects.equals(logicWarehouseEo.getIsVirtual(), YesNoHelper.YES)) {
                logger.info("\u903b\u8f91\u4ed3\u4e3a\u865a\u4ed3\uff0c\u4e2d\u6b62WMS\u63a8\u9001, warehouseCode: {}", (Object)warehouseCode);
                return;
            }
            this.transactionCallBackService.execute(() -> {
                logger.info("\u751f\u6210\u51fa\u5165\u5e93\u901a\u77e5\u5355,\u5355\u53f7documentNo\uff1a{}\uff0c\u901a\u77e5wms\u51fa/\u5165\u5e93,messageVo:{}", (Object)outNoticeOrderEo.getDocumentNo(), (Object)JSON.toJSONString((Object)messageVo));
                this.mqService.stockOutAndInAddProcessor(messageVo);
            });
        }
    }

    private void sendE3(InOutNoticeOrderEo outNoticeOrderEo) {
        logger.info("\u51fa\u5165\u901a\u77e5\u5355\u5b8c\u6210\uff0c\u901a\u77e5E3");
        try {
            if (!outNoticeOrderEo.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()) && CsPcpBusinessTypeEnum.cAllotList().contains(outNoticeOrderEo.getOrderType())) {
                logger.info("\u975ecc\u3001cb\u3001bc\u8c03\u62e8\u4e1a\u52a1\uff0c\u65e0\u9700\u901a\u77e5E3");
                return;
            }
            if ("out".equals(outNoticeOrderEo.getOrderType())) {
                logger.info("\u51fa\u5e93\u901a\u77e5\u65e0\u9700\u901a\u77e5E3\uff0c\u5355\u636e\u521b\u5efa\u540e\u5df2\u901a\u77e5");
                return;
            }
            MessageVo messageVo = new MessageVo();
            CsOutNoticeOrderRespDto respDto = new CsOutNoticeOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)outNoticeOrderEo, (BaseVo)respDto);
            messageVo.setData((Object)JSON.toJSONString((Object)respDto));
            this.mqService.stockInToE3Processor(messageVo);
        }
        catch (Exception e) {
            logger.error("\u51fa\u5165\u901a\u77e5\u5355\u5b8c\u6210\uff0c\u901a\u77e5E3\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private MessageVo joinOutWmsSendInfo(InOutNoticeOrderEo outNoticeOrderEo, List<InOutNoticeOrderDetailEo> detailEoList) {
        WmsStockOutOrderReqDto wmsStockOutOrderReqDto = new WmsStockOutOrderReqDto();
        WarehouseAddressEo csWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(outNoticeOrderEo.getOutPhysicsWarehouseCode());
        if (null != csWarehouseAddressEo) {
            WmsStockOutOrderReqDto.SenderInfo senderInfo = new WmsStockOutOrderReqDto.SenderInfo();
            CubeBeanUtils.copyProperties((Object)senderInfo, (Object)csWarehouseAddressEo, (String[])new String[0]);
            wmsStockOutOrderReqDto.setSenderInfo(senderInfo);
        }
        wmsStockOutOrderReqDto.setDocumentNo(outNoticeOrderEo.getDocumentNo());
        wmsStockOutOrderReqDto.setRelevanceNo(outNoticeOrderEo.getRelevanceNo());
        wmsStockOutOrderReqDto.setThirdOrderNo(outNoticeOrderEo.getExternalOrderNo());
        wmsStockOutOrderReqDto.setCreateTime(DateUtils.formatYMDHms(outNoticeOrderEo.getCreateTime()));
        wmsStockOutOrderReqDto.setOrderType(outNoticeOrderEo.getOrderType());
        wmsStockOutOrderReqDto.setBusinessType(outNoticeOrderEo.getBusinessType());
        wmsStockOutOrderReqDto.setWarehouseCode(outNoticeOrderEo.getOutPhysicsWarehouseCode());
        wmsStockOutOrderReqDto.setLogicWarehouseCode(outNoticeOrderEo.getOutLogicWarehouseCode());
        wmsStockOutOrderReqDto.setEnableBatch(!YesNoEnum.YES.getValue().equals(outNoticeOrderEo.getNoBatch()));
        List<WmsItemLine> itemLines = this.getWmsItemLines(detailEoList);
        LogicWarehouseEo csLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(wmsStockOutOrderReqDto.getLogicWarehouseCode());
        wmsStockOutOrderReqDto.setOrganizationCode(csLogicWarehouseEo.getCargoEscheatageId() + "");
        wmsStockOutOrderReqDto.setOrganizationName(csLogicWarehouseEo.getCargoEscheatageName());
        List csPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(wmsStockOutOrderReqDto.getWarehouseCode());
        PhysicsWarehouseEo csPhysicsWarehouseEo = (PhysicsWarehouseEo)csPhysicsWarehouseEos.get(0);
        wmsStockOutOrderReqDto.setPhysicsOrganizationCode(csPhysicsWarehouseEo.getOrganizationCode());
        wmsStockOutOrderReqDto.setPhysicsOrganizationName(csPhysicsWarehouseEo.getOrganizationName());
        wmsStockOutOrderReqDto.setItemLines(itemLines);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)outNoticeOrderEo.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        businessOrderCallBackService.getContactsInfo(wmsStockOutOrderReqDto);
        wmsStockOutOrderReqDto.setRemark(outNoticeOrderEo.getRemark());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)wmsStockOutOrderReqDto));
        messageVo.setExtValue1((Object)outNoticeOrderEo.getOrderType());
        return messageVo;
    }

    private MessageVo joinInWmsSendInfo(InOutNoticeOrderEo outNoticeOrderEo, List<InOutNoticeOrderDetailEo> detailEoList) {
        WmsStockEntryOrderReqDto wmsStockEntryOrderReqDto = new WmsStockEntryOrderReqDto();
        WarehouseAddressEo csWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        if (null != csWarehouseAddressEo) {
            CubeBeanUtils.copyProperties((Object)wmsStockEntryOrderReqDto, (Object)csWarehouseAddressEo, (String[])new String[0]);
        }
        wmsStockEntryOrderReqDto.setExtensionExternal(this.getExtensionExternal(outNoticeOrderEo));
        wmsStockEntryOrderReqDto.setDocumentNo(outNoticeOrderEo.getDocumentNo());
        wmsStockEntryOrderReqDto.setRelevanceNo(outNoticeOrderEo.getRelevanceNo());
        wmsStockEntryOrderReqDto.setThirdOrderNo(outNoticeOrderEo.getExternalOrderNo());
        wmsStockEntryOrderReqDto.setOrderCreateTime(DateUtils.formatYMDHms(outNoticeOrderEo.getCreateTime()));
        wmsStockEntryOrderReqDto.setRemark(outNoticeOrderEo.getRemark());
        wmsStockEntryOrderReqDto.setOrderType(outNoticeOrderEo.getOrderType());
        wmsStockEntryOrderReqDto.setBusinessType(outNoticeOrderEo.getBusinessType());
        wmsStockEntryOrderReqDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        wmsStockEntryOrderReqDto.setLogicWarehouseCode(outNoticeOrderEo.getInLogicWarehouseCode());
        wmsStockEntryOrderReqDto.setEnableBatch(!YesNoEnum.YES.getValue().equals(outNoticeOrderEo.getNoBatch()));
        List<WmsItemLine> itemLines = this.getWmsItemLines(detailEoList);
        LogicWarehouseEo csLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(wmsStockEntryOrderReqDto.getLogicWarehouseCode());
        wmsStockEntryOrderReqDto.setOrganizationCode(csLogicWarehouseEo.getCargoEscheatageId() + "");
        wmsStockEntryOrderReqDto.setOrganizationName(csLogicWarehouseEo.getCargoEscheatageName());
        List csPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(wmsStockEntryOrderReqDto.getWarehouseCode());
        PhysicsWarehouseEo csPhysicsWarehouseEo = (PhysicsWarehouseEo)csPhysicsWarehouseEos.get(0);
        wmsStockEntryOrderReqDto.setPhysicsOrganizationCode(csPhysicsWarehouseEo.getOrganizationCode());
        wmsStockEntryOrderReqDto.setPhysicsOrganizationName(csPhysicsWarehouseEo.getOrganizationName());
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)outNoticeOrderEo.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        businessOrderCallBackService.getContactsInfo(wmsStockEntryOrderReqDto);
        wmsStockEntryOrderReqDto.setItemLines(itemLines);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString((Object)wmsStockEntryOrderReqDto));
        return messageVo;
    }

    private List<WmsItemLine> getWmsItemLines(List<InOutNoticeOrderDetailEo> detailEoList) {
        ArrayList<WmsItemLine> itemLines = new ArrayList<WmsItemLine>();
        for (InOutNoticeOrderDetailEo InOutNoticeOrderDetailEo2 : detailEoList) {
            WmsItemLine itemLine = new WmsItemLine();
            itemLine.setCargoCode(InOutNoticeOrderDetailEo2.getSkuCode());
            itemLine.setCargoName(InOutNoticeOrderDetailEo2.getSkuName());
            itemLine.setBatch(InOutNoticeOrderDetailEo2.getBatch());
            itemLine.setPlanQuantity(InOutNoticeOrderDetailEo2.getPlanQuantity());
            itemLine.setTradeOrderItemId(null != InOutNoticeOrderDetailEo2.getPreOrderItemId() ? InOutNoticeOrderDetailEo2.getPreOrderItemId().toString() : InOutNoticeOrderDetailEo2.getId().toString());
            itemLines.add(itemLine);
            String productDate = null != InOutNoticeOrderDetailEo2.getProduceTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo2.getProduceTime()) : null;
            String arrivalDate = null != InOutNoticeOrderDetailEo2.getExpireTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo2.getExpireTime()) : null;
            itemLine.setProductDate(productDate);
            itemLine.setArrivalDate(arrivalDate);
        }
        return itemLines;
    }

    private String getExtensionExternal(InOutNoticeOrderEo outNoticeOrderEo) {
        logger.info("\u83b7\u53d6\u51fa\u5e93\u7ed3\u679c\u5355\uff1a{}", (Object)JSON.toJSONString((Object)outNoticeOrderEo));
        List InOutResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(outNoticeOrderEo.getRelevanceNo());
        if (CollectionUtils.isNotEmpty((Collection)InOutResultOrderEos)) {
            return ((InOutResultOrderEo)InOutResultOrderEos.get(0)).getExtensionExternal();
        }
        return null;
    }

    @Override
    public void sendWms(String documentNo) {
        logger.info("\u4eba\u5de5\u5904\u7406\u91cd\u63a8\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5230wms,documentNo:{}", (Object)documentNo);
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderEo.class).eq(InOutNoticeOrderEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (null == outNoticeOrderEo) {
            return;
        }
        List detailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderDetailEo.class).eq(InOutNoticeOrderDetailEo::getDocumentNo, (Object)documentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        Boolean inFlag = !InOutTypeEnum.OUT.getCode().equals(outNoticeOrderEo.getOrderType());
        this.sendWms(outNoticeOrderEo, detailEoList, inFlag, true);
    }
}

