/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.inventory;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageExtDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.CreateDeliverInformOrderProcess;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ITcbjInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjAvilableReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCancelOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActBacktrackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCompareReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TbjcInventoryActLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjAvilableRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjProOccupyRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.OrderCargoBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.ItemInventoryQueryRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="tcbjInventoryApi")
public class TcbjInventoryApiImpl
implements ITcbjInventoryApi {
    @Resource
    ITcbjInventoryService tcbjInventoryService;
    @Resource
    private CreateDeliverInformOrderProcess createDeliverInformOrderProcess;

    public RestResponse<PageInfo<CargoStorageExtDto>> queryCargoStorage(CargoStorageDto queryDto) {
        return this.tcbjInventoryService.queryCargoStorage(queryDto);
    }

    public RestResponse<PageInfo<CargoStorageExtDto>> queryBatchByActivity(TcbjCombinationBatchReqDto queryDto) {
        return this.tcbjInventoryService.queryBatchByActivity(queryDto);
    }

    public RestResponse<PageInfo<CargoStorageExtDto>> queryBatch(CargoStorageDto queryDto) {
        return this.tcbjInventoryService.queryBatch(queryDto);
    }

    public RestResponse<PageInfo<TcbjInventoryRespDto>> page(TcbjInventoryReqDto queryDto) {
        return this.tcbjInventoryService.page(queryDto);
    }

    public RestResponse<PageInfo<TcbjInventoryLogRespDto>> log(TcbjInventoryLogReqDto queryDto) {
        return this.tcbjInventoryService.log(queryDto);
    }

    public RestResponse<String> preOccupy(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        AssertUtil.isTrue((boolean)Objects.nonNull(tcbjProOccupyReqDto.getOrderNo()), (String)"\u672a\u4f20\u5165\u5355\u53f7");
        return this.tcbjInventoryService.preOccupy(tcbjProOccupyReqDto);
    }

    public RestResponse<String> cancelPreOccupy(String orderNo) {
        AssertUtil.isTrue((!Strings.isNullOrEmpty((String)orderNo) ? 1 : 0) != 0, (String)"\u672a\u4f20\u5165\u5355\u53f7");
        return this.tcbjInventoryService.cancelPreOccupy(orderNo, null, true, false);
    }

    public RestResponse<String> cancelPreOccupyJson(TcbjCancelOccupyReqDto reqDto) {
        AssertUtil.isTrue((!Strings.isNullOrEmpty((String)reqDto.getOrderNo()) ? 1 : 0) != 0, (String)"\u672a\u4f20\u5165\u5355\u53f7");
        if (reqDto.getIsReturnAudit() == null) {
            reqDto.setIsReturnAudit(Boolean.valueOf(false));
        }
        return this.tcbjInventoryService.cancelPreOccupy(reqDto.getOrderNo(), null, true, reqDto.getIsReturnAudit());
    }

    public RestResponse<PageInfo<TcbjProOccupyRespDto>> preOccupyList(TcbjProOccupyListReqDto queryDto) {
        return this.tcbjInventoryService.preOccupyList(queryDto);
    }

    public RestResponse<List<TcbjAvilableRespDto>> avilable(TcbjAvilableReqDto queryDto) {
        AssertUtil.isTrue((!Strings.isNullOrEmpty((String)queryDto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        return this.tcbjInventoryService.avilable(queryDto);
    }

    public RestResponse<List<TcbjAvilableRespDto>> totalAvilable(TcbjAvilableReqDto queryDto) {
        AssertUtil.isTrue((!Strings.isNullOrEmpty((String)queryDto.getWarehouseCode()) ? 1 : 0) != 0, (String)"\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        return this.tcbjInventoryService.totalAvilable(queryDto);
    }

    public RestResponse<String> adjust(TcbjCompareReqDto queryDto) {
        return this.tcbjInventoryService.adjust(queryDto);
    }

    public RestResponse<String> diff() {
        return this.tcbjInventoryService.diff();
    }

    public RestResponse<List<ItemInventoryQueryRespDto>> queryBranchItemStorage(List<String> itemCodeList) {
        return new RestResponse(this.tcbjInventoryService.queryBranchItemStorage(itemCodeList));
    }

    public RestResponse<String> returnAuditOrderStatus(String preNo) {
        return this.tcbjInventoryService.returnAuditOrderStatus(preNo);
    }

    public RestResponse<String> changeOrderStatus(String preNo, Integer orderStatus) {
        return this.tcbjInventoryService.changeOrderStatus(preNo, orderStatus);
    }

    public void updateNotiBatch(List<OrderCargoBatchReqDto> orderCargoBatchReqDto) {
        this.tcbjInventoryService.updateNotiBatch(orderCargoBatchReqDto);
    }

    public RestResponse<Void> combinationActPreempt(TcbjCombinationActReqDto combinationActReqDto) {
        this.tcbjInventoryService.combinationActPreempt(combinationActReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> backtrackInventory(TcbjCombinationActBacktrackReqDto combinationActBacktrackReqDto) {
        this.tcbjInventoryService.backtrackInventory(combinationActBacktrackReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<List<TcbjInventoryActRespDto>> inventoryActQuery(TcbjInventoryActReqDto inventoryActReqDto) {
        List<TcbjInventoryActRespDto> tcbjInventoryActRespDtoList = this.tcbjInventoryService.inventoryActQuery(inventoryActReqDto);
        return new RestResponse(tcbjInventoryActRespDtoList);
    }

    public RestResponse<PageInfo<TbjcInventoryActLogRespDto>> inventoryActLogPageQuery(TcbjInventoryActLogReqDto inventoryActLogReqDto) {
        PageInfo<TbjcInventoryActLogRespDto> pageInfo = this.tcbjInventoryService.inventoryActLogPageQuery(inventoryActLogReqDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<Void> createDeliverInformOrder(String orderNo) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData(JSONObject.toJSON((Object)orderNo));
        this.createDeliverInformOrderProcess.process(messageVo);
        return RestResponse.VOID;
    }

    public RestResponse<List<CargoStorageDto>> queryCargoStorageByBatchesAndWarehouseCode(List<String> batchList, String warehouseCode) {
        return new RestResponse(this.tcbjInventoryService.queryCargoStorageByBatchesAndWarehouseCode(batchList, warehouseCode));
    }

    public RestResponse<List<TcbjAvilableRespDto>> avilableYingXiaoYun(TcbjAvilableReqDto queryDto) {
        return this.tcbjInventoryService.avilableYingXiaoYun(queryDto);
    }
}

