/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.warehouse.CsPhysicsWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsPhysicsWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsPhysicsWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csPhysicsWarehouseQueryService")
public class CsPhysicsWarehouseQueryServiceImpl
implements ICsPhysicsWarehouseQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseQueryServiceImpl.class);
    @Autowired
    private CsPhysicsWarehouseDas csPhysicsWarehouseDas;
    @Autowired
    private CsPhysicsWarehouseMapper csPhysicswarehouseMapper;
    @Autowired
    private TcbjWarehouseMapper tcbjWarehouseMapper;

    @Override
    public CsPhysicsWarehouseEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        return (CsPhysicsWarehouseEo)this.csPhysicsWarehouseDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsPhysicsWarehouseRespDto> queryByPage(CsPhysicsWarehouseQueryDto queryDto) {
        logger.info("queryByPage==>\u7269\u7406\u4ed3\u4ed3\u5e93\u5206\u9875\u67e5\u8be2,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        this.checkParams(queryDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
            queryWrapper.likeRight((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseName())) {
            queryWrapper.likeRight((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseStatus())) {
            queryWrapper.eq((Object)"warehouse_status", (Object)queryDto.getWarehouseStatus());
        }
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List csPhysicsWarehouseEoList = this.csPhysicswarehouseMapper.selectList((Wrapper)queryWrapper);
        List respDtoList = csPhysicsWarehouseEoList.stream().map(e -> {
            CsPhysicsWarehouseRespDto respDto = new CsPhysicsWarehouseRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
            return respDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(csPhysicsWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    @Override
    public List<WarehouseEo> queryOldWarehouseByOrganizationIdList(List<Long> organizationIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"organization_id", organizationIdList);
        List warehouseEoList = this.tcbjWarehouseMapper.selectList((Wrapper)queryWrapper);
        return warehouseEoList;
    }

    private void checkParams(CsPhysicsWarehouseQueryDto queryDto) {
        AssertUtil.isTrue(null != queryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != queryDto.getPageNum() && queryDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != queryDto.getPageSize() && queryDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
    }
}

