/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.annotion.Power;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryTotalQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsLogicInventoryTotalDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLogicInventoryTotalQueryService")
public class CsLogicInventoryTotalQueryServiceImpl
implements ICsLogicInventoryTotalQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicInventoryTotalQueryServiceImpl.class);
    @Autowired
    private CsLogicInventoryTotalDas csLogicInventoryTotalDas;

    @Override
    public CsLogicInventoryTotalEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return this.csLogicInventoryTotalDas.selectByPrimaryKey(id);
    }

    @Override
    public List<CsLogicInventoryTotalRespDto> queryWarehouseInventory(CsLogicInventoryTotalBatchQueryDto batchQueryDto) {
        logger.info("queryWarehouseInventory-->\u6279\u91cf\u67e5\u8be2\u4ed3\u5e93\u8d27\u54c1\u5e93\u5b58\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)batchQueryDto));
        ArrayList list = Lists.newArrayList();
        CsLogicInventoryTotalEo logicInventoryTotalEo = new CsLogicInventoryTotalEo();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)batchQueryDto.getWarehouseCode())) {
            logicInventoryTotalEo.setWarehouseCode(batchQueryDto.getWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)batchQueryDto.getWarehouseCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"warehouse_code", (Object)batchQueryDto.getWarehouseCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)batchQueryDto.getCargoCode())) {
            sqlFilterList.add(SqlFilter.like((String)"cargo_code", (Object)batchQueryDto.getCargoCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)batchQueryDto.getCargoCodeList())) {
            sqlFilterList.add(SqlFilter.in((String)"cargo_code", (Object)batchQueryDto.getCargoCodeList()));
        }
        if (YesNoEnum.YES.getValue().equals(batchQueryDto.getIsAvailable())) {
            sqlFilterList.add(SqlFilter.gt((String)"available", (Object)0));
        }
        logicInventoryTotalEo.setSqlFilters((List)sqlFilterList);
        logicInventoryTotalEo.setDr(YesNoEnum.NO.getValue());
        logicInventoryTotalEo.setOrderByDesc("update_time");
        List inventoryTotalEoList = this.csLogicInventoryTotalDas.select((BaseEo)logicInventoryTotalEo);
        if (CollectionUtils.isNotEmpty((Collection)inventoryTotalEoList)) {
            CubeBeanUtils.copyCollection((Collection)list, (Collection)inventoryTotalEoList, CsLogicInventoryTotalRespDto.class);
        }
        return list;
    }

    @Override
    @Power
    public PageInfo<CsLogicInventoryTotalRespDto> queryWarehouseInventoryPageInfo(CsInventoryPageQueryReqDto inventoryPageQueryReqDto) {
        logger.info("inventoryPageQueryReqDto==>\u5206\u9875\u67e5\u8be2\u903b\u8f91\u603b\u4ed3\u5e93\u5b58,inventoryPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(inventoryPageQueryReqDto));
        AssertUtil.isTrue(null != inventoryPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != inventoryPageQueryReqDto.getPageNum() && inventoryPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != inventoryPageQueryReqDto.getPageSize() && inventoryPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        CsLogicInventoryTotalEo csLogicInventoryTotalEo = new CsLogicInventoryTotalEo();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)inventoryPageQueryReqDto.getCargoName())) {
            sqlFilterList.add(SqlFilter.like((String)"cargo_name", (Object)("%" + inventoryPageQueryReqDto.getCargoName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryPageQueryReqDto.getCargoCode())) {
            sqlFilterList.add(SqlFilter.like((String)"cargo_code", (Object)("%" + inventoryPageQueryReqDto.getCargoCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryPageQueryReqDto.getArtNo())) {
            sqlFilterList.add(SqlFilter.like((String)"art_no", (Object)("%" + inventoryPageQueryReqDto.getArtNo() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryPageQueryReqDto.getWarehouseCode())) {
            sqlFilterList.add(SqlFilter.like((String)"warehouse_code", (Object)("%" + inventoryPageQueryReqDto.getWarehouseCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryPageQueryReqDto.getWarehouseName())) {
            sqlFilterList.add(SqlFilter.like((String)"warehouse_name", (Object)("%" + inventoryPageQueryReqDto.getWarehouseName() + "%")));
        }
        sqlFilterList.add(SqlFilter.in((String)"warehouse_id", (Object)inventoryPageQueryReqDto.getCurrentUserWarehouseIds()));
        sqlFilterList.add(SqlFilter.gt((String)"balance", (Object)0));
        csLogicInventoryTotalEo.setSqlFilters((List)sqlFilterList);
        PageInfo respDtoPageInfo = new PageInfo();
        PageInfo csLogicInventoryTotalEoPageInfo = this.csLogicInventoryTotalDas.selectPage((BaseEo)csLogicInventoryTotalEo, inventoryPageQueryReqDto.getPageNum(), inventoryPageQueryReqDto.getPageSize());
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)csLogicInventoryTotalEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List logicInventoryTotalEos = csLogicInventoryTotalEoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryTotalEos)) {
            ArrayList respDto = com.google.common.collect.Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)logicInventoryTotalEos, CsLogicInventoryTotalRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }
}

