/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.warehouse.CsLogicWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csLogicWarehouseService")
public class CsLogicWarehouseServiceImpl
implements ICsLogicWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseServiceImpl.class);
    @Autowired
    private CsLogicWarehouseDas csLogicWarehouseDas;
    @Autowired
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Autowired
    private ICsWarehouseAddressService csWarehouseAddressService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsLogicWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsLogicWarehouseEo insertEo = CsLogicWarehouseEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csLogicWarehouseDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(Long id, CsLogicWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsLogicWarehouseEo updateEo = CsLogicWarehouseEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csLogicWarehouseDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsLogicWarehouseRespDto dto = this.csLogicWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(dto != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csLogicWarehouseDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLogicWarehouse(CsLogicWarehouseAddReqDto addReqDto) {
        logger.info("addLogicWarehouse==>\u65b0\u589e\u903b\u8f91\u4ed3\u5e93,addReqDto:{}", (Object)LogUtils.buildLogContent(addReqDto));
        String warehouseCode = addReqDto.getWarehouseCode();
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.LOGIC_WAREHOUSE.getCode());
            String code = generateCodeService.getCode();
            addReqDto.setWarehouseCode(code);
        }
        Long logicWarehouseId = this.add(addReqDto);
        CsWarehouseAddressAddReqDto warehouseAddressAddReqDto = addReqDto.getWarehouseAddress();
        if (null != warehouseAddressAddReqDto) {
            warehouseAddressAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            warehouseAddressAddReqDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            warehouseAddressAddReqDto.setWarehouseId(logicWarehouseId);
            warehouseAddressAddReqDto.setWarehouseCode(warehouseCode);
            warehouseAddressAddReqDto.setWarehouseName(addReqDto.getWarehouseName());
            this.csWarehouseAddressService.add(warehouseAddressAddReqDto);
        }
        logger.info("addLogicWarehouse==>\u65b0\u589e\u903b\u8f91\u4ed3\u5e93,logicWarehouseId:{}", (Object)logicWarehouseId);
        return logicWarehouseId;
    }
}

