/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
@MQDesc(tag="YUNDT_CUBE_CENTER_TRADE_CREATE_SUCCESS_TOPIC2")
public class CreateDeliverInformOrderProcess2
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(CreateDeliverInformOrderProcess2.class);
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;

    public MessageResponse process(MessageVo messageVo) {
        logger.info("----->[\u4e00\u671f\u8fed\u4ee3\u4e8c]\u6d88\u8d39\u8ba2\u5355\u521b\u5efaMQ\u4fe1\u606f\uff0c\u5f00\u59cb\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
        try {
            String orderNoStr = messageVo.getData().toString();
            String orderNo = (String)JacksonUtil.readValue((String)orderNoStr, String.class);
            if (StringUtils.isEmpty((CharSequence)orderNo)) {
                logger.info("----->\u6d88\u8d39\u5f02\u5e38\uff0c\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
                return MessageResponse.ERROR;
            }
            ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
            attrs.add(OrderQueryEnum.ADDRESS);
            attrs.add(OrderQueryEnum.ITEM);
            OrderDetailRespDto orderDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(orderNo, StringUtils.join(attrs, (String)",")));
            logger.info("----->\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6\uff1a{}", (Object)JSONObject.toJSONString((Object)orderDto));
            if (ObjectUtil.isEmpty((Object)orderDto)) {
                logger.info("----->\u83b7\u53d6\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38\uff0c\u6ca1\u6709\u8ba2\u5355\u660e\u7ec6\uff1a{}", (Object)orderNo);
                return MessageResponse.ERROR;
            }
            OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
            if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
                orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
            }
            CsDeliveryNoticeOrderAddReqDto addReqDto = new CsDeliveryNoticeOrderAddReqDto();
            addReqDto.setPreOrderNo(orderDto.getOrderNo());
            addReqDto.setExternalOrderNo(orderDto.getThirdOrderNo());
            addReqDto.setWarehouseCode(orderDto.getWarehouseCode());
            addReqDto.setOrganizationId(orderDto.getOrganizationId());
            addReqDto.setOrganizationName(orderDto.getOrganizationName());
            ContactDto contactDto = new ContactDto();
            contactDto.setAddress(orderDelivery.getAddress());
            contactDto.setPlanTime(DateUtils.formatDate(orderDto.getPlaceTime(), "yyyy-MM-dd HH:mm:ss"));
            contactDto.setReciveName(orderDelivery.getDeliveryName());
            contactDto.setRecivePhone(orderDelivery.getDeliveryMobile());
            ArrayList detailAddReqDtoList = Lists.newArrayList();
            BigDecimal totalQuantity = BigDecimal.ZERO;
            for (TradeItemRespDto item : orderDto.getOrderItems()) {
                CsDeliveryNoticeOrderDetailAddReqDto dto = new CsDeliveryNoticeOrderDetailAddReqDto();
                dto.setBatch(item.getBatchNo());
                dto.setCargoCode(item.getCargoSerial());
                dto.setPlanQuantity(BigDecimal.valueOf(item.getItemNum().intValue()));
                try {
                    dto.setActivityId(item.getCombinedPackageActivityId());
                }
                catch (Exception ex) {
                    logger.error("\u5546\u54c1\u53c2\u4e0e\u6d3b\u52a8id\u5f02\u5e38\uff0c\u4e0d\u8d4b\u503c\uff1bactivityId:{}", (Object)item.getCombinedPackageActivityId());
                }
                totalQuantity = totalQuantity.add(dto.getPlanQuantity());
                dto.setTradeOrderItemId(item.getId());
                detailAddReqDtoList.add(dto);
            }
            addReqDto.setTotalQuantity(totalQuantity);
            addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
            addReqDto.setContactDto(contactDto);
            addReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode());
            logger.info("----->\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)addReqDto));
            this.csDeliveryNoticeOrderService.add(addReqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("----->\u6d88\u8d39\u8ba2\u5355\u521b\u5efaMQ\u4fe1\u606f\u5f02\u5e38:{}\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
            MessageResponse messageResponse = MessageResponse.ERROR;
            messageResponse.setResultMsg(e.getMessage());
            return messageResponse;
        }
        return MessageResponse.SUCCESS;
    }
}

