/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.warehouse.CsRelWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsRelWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsRelWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseUpdateReqDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csRelWarehouseService")
public class CsRelWarehouseServiceImpl
implements ICsRelWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(CsRelWarehouseServiceImpl.class);
    @Autowired
    private CsRelWarehouseDas csRelWarehouseDas;
    @Autowired
    private CsRelWarehouseMapper csRelWarehouseMapper;
    @Autowired
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;

    @Override
    public Long add(CsRelWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsRelWarehouseEo insertEo = CsRelWarehouseEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csRelWarehouseDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsRelWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsRelWarehouseEo updateEo = CsRelWarehouseEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csRelWarehouseDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsRelWarehouseEo eo = this.csRelWarehouseQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csRelWarehouseDas.logicDeleteById(id);
    }

    @Override
    public List<CsRelWarehouseEo> selectList(CsRelWarehouseEo csRelWarehouseEo) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(csRelWarehouseEo));
        return this.csRelWarehouseDas.selectList((BaseEo)csRelWarehouseEo);
    }
}

