/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInResultOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInResultOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInResultOrderService")
public class CsInResultOrderServiceImpl
implements ICsInResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsInResultOrderServiceImpl.class);
    @Autowired
    private CsInResultOrderDas csInResultOrderDas;
    @Autowired
    private ICsInResultOrderQueryService csInResultOrderQueryService;
    @Resource
    private CsInResultOrderMapper csInResultOrderMapper;
    @Resource
    private CsInResultOrderDetailMapper csInResultOrderDetailMapper;
    @Resource
    private CsLogicWarehouseMapper csLogicWarehouseMapper;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    private RepeatFilter repeatFilter;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsInResultOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u5165\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("InResult:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        CsInResultOrderEo inResultOrderEo = new CsInResultOrderEo();
        CubeBeanUtils.copyProperties((Object)inResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("502");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        inResultOrderEo.setDocumentNo(documentNo);
        inResultOrderEo.setOrderStatus(orderStatus);
        inResultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.csInResultOrderMapper.insert((Object)inResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsInResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsInResultOrderDetailEo detailEo = new CsInResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEoList.add(detailEo);
        }
        this.csInResultOrderDetailMapper.insertBatch((List)detailEoList);
        return inResultOrderEo.getId();
    }

    private void dataValid(CsInResultOrderAddReqDto addReqDto) {
        List logicWarehouseEos = this.csLogicWarehouseMapper.queryByWarehouseCode(addReqDto.getWarehouseCode());
        List<String> cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsInResultOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List<CargoEo> cargoEoList = this.csCommonService.queryCargo(cargoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoEoList), "\u8d27\u54c1\u672a\u914d\u7f6e");
        CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, CargoEo> cargoMap = cargoEoList.stream().collect(Collectors.toMap(StdCargoEo::getCode, entity -> entity));
        for (CsInResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CargoEo cargoEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == cargoEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(cargoEo.getId());
            detailAddReqDto.setCargoName(cargoEo.getName());
        }
    }

    private void preValid(CsInResultOrderAddReqDto addReqDto) {
        List oldList = this.csInResultOrderMapper.queryByRelevanceNo(addReqDto.getRelevanceNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsInResultOrderEo resultOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.RECEIVE_CANCEL.getCode().equals(resultOrderEo.getOrderStatus()), CsInventoryExceptionCode.SUCCESS_CODE.getCode(), CsInventoryExceptionCode.SUCCESS_CODE.getMsg());
            }
        }
    }

    @Override
    public void update(Long id, CsInResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInResultOrderEo updateEo = CsInResultOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csInResultOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsInResultOrderEo eo = this.csInResultOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csInResultOrderDas.logicDeleteById(id);
    }
}

