/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutNoticeOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutNoticeOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsRelWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutNoticeOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csOutNoticeOrderService")
public class CsOutNoticeOrderServiceImpl
implements ICsOutNoticeOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsOutNoticeOrderServiceImpl.class);
    @Resource
    private CsOutNoticeOrderDas csOutNoticeOrderDas;
    @Resource
    private CsOutNoticeOrderMapper csOutNoticeOrderMapper;
    @Resource
    private CsOutNoticeOrderDetailMapper csOutNoticeOrderDetailMapper;
    @Resource
    private ICsDeliveryResultOrderQueryService csDeliveryResultOrderQueryService;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private ICsOutNoticeOrderQueryService csOutNoticeOrderQueryService;
    @Resource
    private RepeatFilter repeatFilter;

    @Override
    public Long add(CsOutNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutNoticeOrderEo insertEo = CsOutNoticeOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csOutNoticeOrderDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsOutNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutNoticeOrderEo updateEo = CsOutNoticeOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csOutNoticeOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsOutNoticeOrderEo eo = this.csOutNoticeOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csOutNoticeOrderDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createOutNoticeOrder(String relevanceNo) {
        this.repeatFilter.checkRepeat("OutNotice:" + relevanceNo, () -> this.preValid(relevanceNo), true);
        CsDeliveryNoticeOrderRespDto dto = this.csDeliveryNoticeOrderQueryService.queryByDocumentNo(relevanceNo);
        List<CsRelWarehouseEo> csRelWarehouseEos = this.csRelWarehouseQueryService.queryByRefWarehouseCode(dto.getWarehouseCode(), dto.getWarehouseClassify());
        for (CsRelWarehouseEo relWarehouseEo : csRelWarehouseEos) {
            if (!CsWarehouseClassifyEnum.PHYSICS.getCode().equals(relWarehouseEo.getWarehouseClassify())) continue;
            dto.setWarehouseId(relWarehouseEo.getWarehouseId());
            dto.setWarehouseCode(relWarehouseEo.getWarehouseCode());
            dto.setWarehouseName(relWarehouseEo.getWarehouseName());
        }
        CsOutNoticeOrderEo csOutNoticeOrderEo = new CsOutNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)csOutNoticeOrderEo, (Object)dto, (String[])new String[]{"id"});
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("401");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csOutNoticeOrderEo.setDocumentNo(documentNo);
        csOutNoticeOrderEo.setOrderStatus(orderStatus);
        csOutNoticeOrderEo.setRelevanceNo(relevanceNo);
        csOutNoticeOrderEo.setExternalOrderNo(dto.getExternalOrderNo());
        csOutNoticeOrderEo.setExtension(JSON.toJSONString((Object)dto.getContactDto()));
        this.csOutNoticeOrderMapper.insert((Object)csOutNoticeOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsDeliveryNoticeOrderDetailRespDto detailRespDto : dto.getDeliveryNoticeOrderDetailRespDtoList()) {
            CsOutNoticeOrderDetailEo detailEo = new CsOutNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setRelevanceNo(relevanceNo);
            detailEoList.add(detailEo);
        }
        this.csOutNoticeOrderDetailMapper.insertBatch((List)detailEoList);
        return csOutNoticeOrderEo.getId();
    }

    @Override
    public void cancelOutNoticeOrderByPreOrderNo(String preOrderNo) {
        List csOutNoticeOrderEos = this.csOutNoticeOrderMapper.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEos)) {
            for (CsOutNoticeOrderEo csOutNoticeOrderEo : csOutNoticeOrderEos) {
                csOutNoticeOrderEo.setOrderStatus(CsOrderStatusEnum.DELIVERY_CANCEL.getCode());
                this.csOutNoticeOrderMapper.updateById((BaseEo)csOutNoticeOrderEo);
            }
        }
    }

    private void preValid(String relevanceNo) {
        List oldList = this.csOutNoticeOrderMapper.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsOutNoticeOrderEo outNoticeOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(outNoticeOrderEo.getOrderStatus()), "304", outNoticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

