/*
 Navicat Premium Data Transfer

 Source Server         : ioctest
 Source Server Type    : MySQL
 Source Server Version : 50725
 Source Host           : 192.168.34.40:32306
 Source Schema         : cube_dev_inventory

 Target Server Type    : MySQL
 Target Server Version : 50725
 File Encoding         : 65001

 Date: 10/06/2021 14:22:18
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for in_address
-- ----------------------------

CREATE TABLE `in_address`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `related_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联id',
  `related_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联人名称',
  `related_mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联人手机号',
  `related_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联人座机号',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '电子邮箱',
  `country_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家名称',
  `country_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家编码',
  `province_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省',
  `province_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '市',
  `city_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区',
  `area_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '街道',
  `street_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '街道名称',
  `detailed` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址全称',
  `postcode` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮编',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_tr_delivery_create_time`(`create_time`) USING BTREE,
  INDEX `idx_tr_delivery_update_time`(`update_time`) USING BTREE,
  INDEX `AK_idx_tr_delivery__order_no`(`related_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存关联地址' ROW_FORMAT = COMPACT;

-- ----------------------------
-- Table structure for in_bill
-- ----------------------------

CREATE TABLE `in_bill`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `bill_src_id` bigint(20) NULL DEFAULT NULL COMMENT '单据id',
  `bill_src` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据来源',
  `bill_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '单据编码',
  `business_id` bigint(20) NULL DEFAULT NULL COMMENT '业务单号',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1：待提交、2：待审核:3：待执行、4：审核不通过，5：已完结、6：取消、7：执行失败',
  `category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'CATEGORY_IN' COMMENT '1：预留，2：处置',
  `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0：普通，1：报废，2：领用',
  `audit_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `audit_time` datetime(0) NULL DEFAULT NULL COMMENT '审核时间',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `idx_order_no`(`bill_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存单据' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_bill_detail
-- ----------------------------

CREATE TABLE `in_bill_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `bill_id` bigint(20) NOT NULL COMMENT '单据ID',
  `bill_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '单据编号',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `position_id` bigint(20) NULL DEFAULT NULL COMMENT '仓位ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品ID',
  `num` bigint(20) NOT NULL COMMENT '货品数量',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'UNVERIFIED' COMMENT '0禁用，1启用',
  `package_id` bigint(20) NULL DEFAULT NULL COMMENT '包裹id',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_order_id`(`bill_id`) USING BTREE,
  INDEX `idx_order_no`(`bill_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '单据详情' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_cargo
-- ----------------------------

CREATE TABLE `in_cargo`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `group_id` bigint(20) NULL DEFAULT 0 COMMENT '分组ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '编码',
  `art_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品货号',
  `bar_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品条码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `unit` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位',
  `unit_id` bigint(20) NULL DEFAULT NULL COMMENT 'NC单位ID',
  `brand_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌编码',
  `brand_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌名称',
  `place_of_origin` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产地',
  `offline_safety_stock` decimal(11, 0) NULL DEFAULT 0 COMMENT '线下安全库存',
  `safety_stock_strategy` int(1) NULL DEFAULT 0 COMMENT '安全库存策略，0-关闭，1-开启',
  `if_available_offline` int(1) NULL DEFAULT 0 COMMENT '是否线下可售，0-否，1-是',
  `avoid_oversold_inventory` decimal(11, 0) NULL DEFAULT 0 COMMENT '防超卖库存数',
  `single_channel_share` decimal(11, 0) NULL DEFAULT 0 COMMENT '单渠道共享数',
  `single_channel_shop_id` bigint(20) NULL DEFAULT NULL COMMENT '单渠道共享指定店铺',
  `check_config_id` bigint(20) NULL DEFAULT NULL COMMENT '库存检查配置',
  `package_split_id` bigint(20) NULL DEFAULT NULL COMMENT '拆包配置',
  `quantity` decimal(10, 0) NULL DEFAULT NULL COMMENT '重量',
  `volume` decimal(10, 0) NULL DEFAULT NULL COMMENT '体积',
  `length` int(11) NULL DEFAULT NULL COMMENT '长',
  `width` int(11) NULL DEFAULT NULL COMMENT '宽',
  `height` int(11) NULL DEFAULT NULL COMMENT '高',
  `length_unit` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm',
  `height_unit` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm',
  `width_unit` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm',
  `quantity_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量单位',
  `customer_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属客户编码',
  `detail` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '货品详情',
  `shipping_tpl_id` bigint(20) NULL DEFAULT NULL COMMENT '运费模板(面向运营)',
  `tax_rate` int(11) NULL DEFAULT NULL COMMENT '增值税率',
  `gross_weight` decimal(10, 2) NULL DEFAULT NULL COMMENT '毛重',
  `gross_weight_unit` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '毛重单位',
  `net_weight` decimal(10, 2) NULL DEFAULT NULL COMMENT '净重',
  `net_weight_unit` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '净重单位',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '货品' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_cargo_storage
-- ----------------------------

CREATE TABLE `in_cargo_storage`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `group_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '分组ID',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `warehouse_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库编码',
  `warehouse_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库名称',
  `position_id` bigint(20) NULL DEFAULT NULL COMMENT '仓位ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品ID',
  `cargo_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品编码',
  `art_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品货号',
  `bar_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `cargo_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品名称',
  `balance` decimal(20, 2) NULL DEFAULT 0.00 COMMENT '库存总数',
  `preempt` decimal(20, 2) NULL DEFAULT 0.00 COMMENT '预占',
  `reserved` decimal(20, 2) NULL DEFAULT 0.00 COMMENT '预留',
  `available` decimal(20, 2) NULL DEFAULT 0.00 COMMENT '可用',
  `intransit` decimal(20, 2) NULL DEFAULT 0.00 COMMENT '在途',
  `futures_inventory` bigint(20) NULL DEFAULT 0 COMMENT '期货库存',
  `futures_issued` bigint(20) NULL DEFAULT 0 COMMENT '期货已发',
  `pending` bigint(20) NULL DEFAULT 0 COMMENT '待收',
  `inventory_share_status` int(11) NULL DEFAULT NULL COMMENT '库存共享状态： 0 不开启 ，1 开启',
  `warehouse_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓',
  `warehouse_sub_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '仓库子类型  物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS',
  `imperfections` bigint(20) NOT NULL DEFAULT 0 COMMENT '残次品',
  `indemnity` bigint(20) NOT NULL DEFAULT 0 COMMENT '陪付品',
  `organization_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `organization_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `idx_position_id`(`position_id`) USING BTREE,
  INDEX `cargo_id`(`cargo_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '货品库存' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_cargo_storage_share_task
-- ----------------------------

CREATE TABLE `in_cargo_storage_share_task`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `task_code` bigint(10) NOT NULL COMMENT '任务编号',
  `task_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务名称',
  `task_type` tinyint(4) NULL DEFAULT NULL COMMENT '任务类型：1：库存共享',
  `task_status` tinyint(4) NOT NULL COMMENT '任务状态：0：待执行；1：执行成功；2：执行失败',
  `task_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务备注：搜索条件+仓库分配比例',
  `task_result` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '任务结果（执行备注）',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_task_code`(`task_code`) USING BTREE COMMENT '任务编号'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '货品库存共享任务表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_change_log
-- ----------------------------

CREATE TABLE `in_change_log`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `relevance_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '关联单号',
  `cargo_id` bigint(20) NULL DEFAULT NULL COMMENT '货品ID',
  `cargo_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品编码',
  `cargo_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品名称',
  `cargo_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品货号',
  `cargo_bar_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品条码',
  `client_id` bigint(20) NULL DEFAULT NULL COMMENT '所属客户',
  `client_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属客户名称',
  `warehouse_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库ID',
  `warehouse_code` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库编码',
  `warehouse_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库名称',
  `warehouse_sub_type` tinyint(4) NULL DEFAULT NULL COMMENT '仓库子类型： 0 其他仓，1电商仓，2小程序仓',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '类型：1：销售订单、2：售后订单:3：配货单:4：补货单:5：调货单、6：返货单、7：库存调整',
  `old_num` decimal(20, 0) NULL DEFAULT NULL COMMENT '原库存数',
  `change_num` decimal(20, 0) NULL DEFAULT NULL COMMENT '更改库存数',
  `new_num` decimal(20, 0) NULL DEFAULT NULL COMMENT '新库存数',
  `organization_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `organization_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_storage_adjust_id`(`relevance_no`) USING BTREE,
  INDEX `Index_id`(`id`) USING BTREE,
  INDEX `Index_cargo_id`(`cargo_id`) USING BTREE,
  INDEX `Index_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `Index_client_id`(`client_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存流水' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_delivery_item
-- ----------------------------

CREATE TABLE `in_delivery_item`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '交易流水号',
  `deliverer_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送人员id',
  `delivery_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '所属发货记录流水号',
  `parent_delivery_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '父发货单号',
  `tr_order_item_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单商品明细id',
  `sku_serial` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT 'skuID\n ',
  `supplier_serial` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '供应商id ',
  `delivery_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '发货类型\n            普通发送,发补发, 换货重发',
  `delivery_sub_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '发货小类\n            比如补发 ,可以是漏发的补发,  损坏的补发, \n            一般可不使用',
  `item_num` int(11) NOT NULL COMMENT '数量',
  `cargo_serial` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '货品id',
  `item_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号（款号）',
  `sku_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'sku编码',
  `sku_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'sku规格描述',
  `item_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '商品价格',
  `retail_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '零售价',
  `item_img_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品图片',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '发货单商品表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_delivery_route_record
-- ----------------------------

CREATE TABLE `in_delivery_route_record`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `delivery_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货单号',
  `parent_delivery_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父发货单号',
  `order_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单号',
  `route_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路由类型，ASSIGN-指定路径, COMBINE-组合路径',
  `opt_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作记录操作编号',
  `opt_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作记录操作名称',
  `opt_code_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作记录操作名称',
  `pre_delivery_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作前发货单状态',
  `pre_delivery_status_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作前的发货单状态名称',
  `pre_delivery_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作前发货单状态名称',
  `delivery_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作后发货单状态',
  `delivery_status_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作后发货单状态名称',
  `shop_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '门店编码',
  `warehouse_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库编码',
  `warehouse_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库名称',
  `route_result` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `route_score` double(10, 2) NULL DEFAULT NULL COMMENT '路由得分',
  `detail_desc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细描述',
  `error_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '错误码',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_delivery_no`(`delivery_no`) USING BTREE,
  INDEX `idx_order_no`(`order_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '发货单路由记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_diff_order
-- ----------------------------

CREATE TABLE `in_diff_order`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '单据编号',
  `order_src_id` bigint(20) NULL DEFAULT 0 COMMENT '来源单号(调拨入库单)',
  `order_src` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据来源',
  `extension` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户id',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '实例id',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新人',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '收发差异单' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_diff_order_detail
-- ----------------------------

CREATE TABLE `in_diff_order_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `order_src_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '来源id',
  `order_id` bigint(20) NOT NULL COMMENT '收发差异单据ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品ID',
  `order_num` int(11) NOT NULL DEFAULT 0 COMMENT '计划数量',
  `result_num` int(11) NULL DEFAULT NULL COMMENT '实际入库数量',
  `status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态',
  `extension` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户id',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '实例id',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `update_person` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新人',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '收发差异单明细' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_electric_fence
-- ----------------------------

CREATE TABLE `in_electric_fence`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库_ID',
  `params_value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '电子围栏值value',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '电子围栏' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_order_delivery
-- ----------------------------
CREATE TABLE `in_order_delivery`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '交易流水号',
  `delivery_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '1' COMMENT '发货流水号',
  `parent_delivery_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '父订单号',
  `split_flag` int(11) NULL DEFAULT NULL COMMENT '是否已拆单，0-未拆单，1-已拆单',
  `deliverer_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送人员id',
  `shipping_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'express' COMMENT '配送方式：（express 快递 pickup 自提  intra-city 同城配送 ） 默认是 express',
  `warehouse_serial` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货仓库id',
  `pickup_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自提类型：订单order  包裹pack 商品 goods',
  `delivery_status` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货状态 :INIT:待发货, ACCEPT:已提交库存系统, DELIVERING: 已出库, SUCC: 全部包裹已确认收货',
  `delivery_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收货人名称',
  `address` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '详细地址全称',
  `delivery_mobile` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '收货人手机号',
  `delivery_phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '收货人座机号',
  `country_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '国家地区',
  `province_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '省',
  `province_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省名称',
  `city_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '市',
  `city_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '市名称',
  `area_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '区',
  `area_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区名称',
  `street_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '街道',
  `street_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '街道名称',
  `detailed` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `postcode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '邮编',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  `cancel_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '取消方式: 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消',
  `cancel_time` datetime(0) NULL DEFAULT '1970-01-01 00:00:00' COMMENT '取消完成的时间',
  `cancel_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '取消原因',
  `delivery_order_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出库单号',
  `order_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '出库单类型，JYCK=一般交易出库单, HHCK=换货出库 单, BFCK=补发出库单，QTCK=其他出库单',
  `warehouse_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库编码，统仓统配等无需 ERP 指定仓储编码 的情况填 OTHER',
  `warehouse_sub_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货仓库子类型',
  `shop_code` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货门店编码（如果是门店发货才有值）',
  `operator_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作员 (审核员) 编码',
  `operator_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作员 (审核员) 名称',
  `total_amount` decimal(65, 2) NULL DEFAULT NULL COMMENT '订单总金额',
  `item_amount` decimal(65, 2) NULL DEFAULT NULL COMMENT '商品总金额 (元)',
  `discount_amount` decimal(65, 2) NULL DEFAULT NULL COMMENT '订单折扣金额 (元)',
  `freight_amount` decimal(65, 2) NULL DEFAULT NULL COMMENT '快递费用 (元)',
  `ar_amount` decimal(65, 2) NULL DEFAULT NULL COMMENT '应收金额 (元)，消费者还需要支付多少（货到付款时消费者还需要支付多少约定使用这个字段）',
  `got_amount` decimal(65, 2) NULL DEFAULT NULL COMMENT '已收金额 (元)，消费者已经支付多少',
  `shipping_company_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)',
  `shipping_company` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流公司名称',
  `shipping_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流公司运单号（存储母单号）',
  `schedule_type` int(255) NULL DEFAULT NULL COMMENT '投递时延要求，1=工作日,2=节假日,101=当日达,102=次晨达,103=次日达,104=预约达',
  `schedule_day` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要求送达日期，要求送达日期，YYYY-MM-DD',
  `schedule_start_time` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '投递时间范围要求(开始时间)，HH:MM:SS',
  `schedule_end_time` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '投递时间范围要求(结束时间)，HH:MM:SS',
  `delivery_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货服务类型，PTPS（普通配送），LLPS（冷链配送），HBP(环保 配)',
  `company` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人公司名称',
  `identity_type` int(255) NULL DEFAULT NULL COMMENT '收货人收件人证件类型，1-身份证 2-军官证 3-护照 4-其他',
  `identity_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收货人收件人证件号码',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收货人电子邮箱',
  `delivery_time` datetime(0) NULL DEFAULT NULL COMMENT '发货时间',
  `third_pay_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方支付交易号',
  `warehouse_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货仓库名称',
  `receive_time` datetime(0) NULL DEFAULT NULL COMMENT '收货时间',
  `assign_time` datetime(0) NULL DEFAULT NULL COMMENT '指派时间',
  `country_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家地区名称',
  `express_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运单号',
  `delivery_method` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货服务方式，PTPS（普通配送），LLPS（冷链配送），HBP(环保 配)',
  `biz_type` int(10) NULL DEFAULT NULL COMMENT '业务类型，1-商城，2-全渠道',
  `channel` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道编码，对应渠道表渠道',
  `organization_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `organization_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `warehouse_organization_id` bigint(20) NULL DEFAULT NULL COMMENT '路由仓库对应所属组织ID',
  `warehouse_organization_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路由仓库对应所属组织名称',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_delivery`(`delivery_no`) USING BTREE,
  INDEX `idx_trade`(`trade_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '发货单表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_order_route_rule
-- ----------------------------

CREATE TABLE `in_order_route_rule`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `route_rule_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '路由规则名称',
  `applicable_channel` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '适用渠道',
  `route_type` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路由类型',
  `route_status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '路由状态（0 启用，1 禁用）',
  `split_flag` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否拆单（0是，1否）',
  `gift_delivery_warehouse` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '赠品发货仓库',
  `delivery_warehouse_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货仓库编码',
  `inventory_priority` tinyint(4) NULL DEFAULT 1 COMMENT '库存优先级（0库存优先，1路由得分优先）',
  `inventory_priority_item` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存规则信息（json格式存放）',
  `weight_item` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则因素信息（json格式存放权重项）',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_route_rule_name`(`route_rule_name`) USING BTREE,
  INDEX `idx_update_time`(`update_time`) USING BTREE,
  INDEX `idx_route_status`(`route_status`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '订单路由规则表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_package
-- ----------------------------

CREATE TABLE `in_package`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `delivery_order_id` bigint(20) NULL DEFAULT NULL COMMENT '发货单ID',
  `delivery_order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货单编码',
  `order_id` bigint(20) NULL DEFAULT NULL COMMENT '交易订单ID',
  `order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '交易订单编号',
  `package_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '包裹编码',
  `shipping_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流单号',
  `shipping_company_id` bigint(20) NULL DEFAULT NULL COMMENT '快递公司id',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'INIT' COMMENT 'INIT初始化 PACKED已打包  SEND_OUT已发货 SIGNED已签收',
  `compute_mode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'BY_PIECE' COMMENT 'BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量 BY_ORDER按订单',
  `spec` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '包裹规格',
  `freight` decimal(20, 2) NULL DEFAULT NULL COMMENT '运费',
  `recipients` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人',
  `prov_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省编码',
  `city_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '市编码',
  `area_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区编码',
  `address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `pt_config_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '渠道配置',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_package_no`(`package_no`) USING BTREE,
  INDEX `idx_shipping_no`(`shipping_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '包裹' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_package_detail
-- ----------------------------

CREATE TABLE `in_package_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `package_id` bigint(20) NOT NULL,
  `package_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `cargo_id` bigint(20) NOT NULL,
  `num` bigint(20) NOT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_package_id`(`package_id`) USING BTREE,
  INDEX `idx_package_no`(`package_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '包裹明细' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_package_split_config
-- ----------------------------

CREATE TABLE `in_package_split_config`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `group_id` bigint(20) NOT NULL COMMENT '分组ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拆包配置名称',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '拆包配置' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_position
-- ----------------------------

CREATE TABLE `in_position`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '仓位编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '仓位名称',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'REAL' COMMENT 'REAL 实体仓位   NETWORK网络仓位',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仓位' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_r_area_warehouse
-- ----------------------------

CREATE TABLE `in_r_area_warehouse`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `group_id` bigint(20) NULL DEFAULT NULL COMMENT '分组ID',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `service_area_id` bigint(20) NOT NULL COMMENT '服务区ID',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `idx_service_area`(`service_area_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仓库和服务区关联' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_r_service_area
-- ----------------------------

CREATE TABLE `in_r_service_area`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `group_id` bigint(20) NULL DEFAULT NULL COMMENT '分组ID',
  `service_area_id` bigint(20) NOT NULL COMMENT '服务区ID',
  `prov_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省编码',
  `prov_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `city_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '市编码',
  `city_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `area_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区编码',
  `area_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_service_area_id`(`service_area_id`) USING BTREE,
  INDEX `idx_prov_code`(`prov_code`) USING BTREE,
  INDEX `idx_city_code`(`city_code`) USING BTREE,
  INDEX `idx_area_code`(`area_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '服务区和区域关联' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_r_template_area
-- ----------------------------

CREATE TABLE `in_r_template_area`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `shipping_tpl_id` bigint(20) NOT NULL COMMENT '运费模板id',
  `prov_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省编码',
  `city_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '市编码',
  `area_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区编码',
  `service_area_id` bigint(20) NULL DEFAULT NULL COMMENT '服务区编码',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运费模板和地区关联' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_ref_delivery_order
-- ----------------------------

CREATE TABLE `in_ref_delivery_order`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `delivery_no` varchar(50) NULL DEFAULT NULL COMMENT '发货单号',
  `order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单号',
  `orign_order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原订单号',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_delivery_no`(`delivery_no`) USING BTREE,
  INDEX `idx_order_no`(`order_no`) USING BTREE,
  INDEX `idx_orign_order_no`(`orign_order_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '发货单订单关联表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_ref_warehouse
-- ----------------------------

CREATE TABLE `in_ref_warehouse`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `cargo_id` bigint(20) NULL DEFAULT NULL COMMENT '货品ID',
  `cargo_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品编码',
  `cargo_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品名称',
  `warehouse_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库ID',
  `warehouse_code` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库编码',
  `warehouse_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库名称',
  `warehouse_type` tinyint(4) NULL DEFAULT NULL COMMENT '0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓',
  `warehouse_sub_type` tinyint(4) NULL DEFAULT NULL COMMENT '物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS',
  `ref_warehouse_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联仓库ID',
  `ref_warehouse_code` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联仓库编码',
  `ref_warehouse_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联仓库名称',
  `ref_warehouse_type` tinyint(4) NULL DEFAULT NULL COMMENT '0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓',
  `ref_warehouse_sub_type` tinyint(4) NULL DEFAULT NULL COMMENT '物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '1：仓库关联，2： 货品关联',
  `proportion` decimal(24, 4) NULL DEFAULT NULL COMMENT '比例',
  `sort` int(11) NULL DEFAULT 0 COMMENT '序号',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `Index_id`(`id`) USING BTREE,
  INDEX `Index_cargo_id`(`cargo_id`) USING BTREE,
  INDEX `Index_warehouse_id`(`warehouse_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仓库关联表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_rule
-- ----------------------------

CREATE TABLE `in_rule`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '名称',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '状态：0-禁用 1-启用',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '类型：0组合规则，1 组织规则',
  `rule_relationship` tinyint(4) NOT NULL DEFAULT 2 COMMENT '规则关系：0 AND，1 OR',
  `rule_value` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '6' COMMENT '规则值',
  `in_object_id` bigint(20) NULL DEFAULT NULL COMMENT '库存对象id',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `Index_id`(`id`) USING BTREE,
  INDEX `Index_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存规则' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_service_area
-- ----------------------------

CREATE TABLE `in_service_area`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '服务区编码',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '服务区名称',
  `group_id` bigint(20) NULL DEFAULT NULL COMMENT '分组ID',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_campony
-- ----------------------------

CREATE TABLE `in_shipping_campony`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '物流公司编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '物流公司名称',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流公司管理' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_log
-- ----------------------------

CREATE TABLE `in_shipping_log`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `shipping_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '运单号',
  `trace_log` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '物流信息',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_shipping_no`(`shipping_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_partner
-- ----------------------------

CREATE TABLE `in_shipping_partner`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '渠道编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '渠道名称',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ENABLED' COMMENT 'ENABLED启用 DISABLED禁用',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流渠道' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_partner_company
-- ----------------------------

CREATE TABLE `in_shipping_partner_company`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'ENABLED' COMMENT 'ENABLED启用 DISABLED禁用',
  `partner_shipping_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流渠道自己的物流编码',
  `shipping_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '物流公司编码',
  `partner_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '物流渠道编码',
  `shipping_company_id` bigint(20) NOT NULL COMMENT '物流公司id',
  `shipping_partner_id` bigint(20) NOT NULL COMMENT '物流渠道id',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '渠道和物流公司关联关系表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_partner_config
-- ----------------------------

CREATE TABLE `in_shipping_partner_config`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `partner_id` bigint(20) NOT NULL COMMENT '渠道ID',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ENABLED' COMMENT 'DISABLED禁用 ENABLED启用',
  `pt_merchant_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道商户ID',
  `pt_app_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道应用ID',
  `lc_priv_key` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `lc_pub_key` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `pt_pub_key` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `pt_query_key` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `ext_config` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '额外配置',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流渠道配置' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_rule
-- ----------------------------

CREATE TABLE `in_shipping_rule`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `shipping_tpl_id` bigint(20) NOT NULL COMMENT '运费模板id',
  `base_cost` decimal(10, 0) NOT NULL COMMENT '基础费用',
  `base_spec` decimal(10, 0) NOT NULL COMMENT '基础规格',
  `incr_cost` decimal(10, 0) NOT NULL COMMENT '超出费用',
  `incr_spec` decimal(10, 0) NOT NULL COMMENT '超出规格',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_shipping_tpl_id`(`shipping_tpl_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运费规则' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_shipping_template
-- ----------------------------

CREATE TABLE `in_shipping_template`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '名称',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'CUSTOMER' COMMENT 'CUSTOMER 面向顾客 OPERATER ',
  `compute_mode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'BY_PIECE' COMMENT 'BY_PIECE按件 BY_VOLUME按体积 BY_WEIGHT按重量 BY_ORDER按订单',
  `group_id` bigint(20) NOT NULL COMMENT '分组ID',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '运费模板' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_adjust
-- ----------------------------

CREATE TABLE `in_storage_adjust`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `storage_adjust_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '单据编号',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `position_id` bigint(20) NULL DEFAULT NULL COMMENT '仓位ID',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'WAIT_PUBLISH' COMMENT '单据状态(WAIT_PUBLISH:待发布、WAIT_AUDIT:待审核、AUDIT_PASS：审核通过、AUDIT_NO_PASS:审核不通过、DISCARD:废弃)',
  `adjust_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'SYSTEM_ADJUST' COMMENT '调整类型(COMMON_ADJUST:普通调整、SYSTEM_ADJUST:系统调整)',
  `adjust_method` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '调整方式(COVER:覆盖、CUMULATIVE：累加)',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `direction` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '比如 wms->中台',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `idx_adjust_type`(`adjust_type`) USING BTREE,
  INDEX `idx_status`(`status`) USING BTREE,
  INDEX `idx_create_time`(`create_time`) USING BTREE,
  INDEX `idx_update_time`(`update_time`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存调整表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_adjust_cargo
-- ----------------------------

CREATE TABLE `in_storage_adjust_cargo`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `storage_adjust_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库存调整单号',
  `cargo_id` bigint(20) NULL DEFAULT NULL COMMENT '货品ID',
  `cargo_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品编码',
  `cargo_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品名称',
  `cargo_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品货号',
  `cargo_bar_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '货品条码',
  `client_id` bigint(20) NULL DEFAULT NULL COMMENT '所属客户',
  `client_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属客户名称',
  `adjust_num` decimal(20, 0) NULL DEFAULT NULL COMMENT '数量',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_storage_adjust_id`(`storage_adjust_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存调整货品信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_change_log
-- ----------------------------

CREATE TABLE `in_storage_change_log`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `change_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'ORDER_CHANGE' COMMENT 'ORDER_CHANGE 订单变更\r\n            STORAGE_OUT 出库变更\r\n            STORAGE_IN 入库变更',
  `action_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动作执行类型： \r\nAPPENDING 预占 STORAGE_IN 入库  STORAGE_OUT 出库',
  `action_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动作执行状态： \r\nWAIT_ROLL_BACK 等待回滚 ROLL_BACK_SUCCESS 回滚成功  INIT 初始化 SUCCESS 执行成功',
  `order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '单据编码',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `position_id` bigint(20) NOT NULL COMMENT '货位ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品ID',
  `balance` bigint(20) NOT NULL DEFAULT 0 COMMENT '库存总数',
  `preempt` bigint(20) NULL DEFAULT 0 COMMENT '预占数量',
  `available` bigint(20) NULL DEFAULT 0 COMMENT '可用',
  `appending` bigint(20) NULL DEFAULT 0 COMMENT '预占数量',
  `allocate` bigint(20) NULL DEFAULT 0 COMMENT '已支配',
  `intransit` bigint(20) NULL DEFAULT 0 COMMENT '在途数量',
  `presell` bigint(20) NULL DEFAULT 0 COMMENT '预售',
  `activity` bigint(20) NULL DEFAULT 0 COMMENT '预售',
  `activity_appending` bigint(20) NULL DEFAULT 0 COMMENT '活动库存预占',
  `imperfections` bigint(20) NULL DEFAULT 0 COMMENT '残次品',
  `indemnity` bigint(20) NULL DEFAULT 0 COMMENT '陪付品',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'APPENDED' COMMENT 'APPENDED已预占 CONFIRM已确认（订单完成）ROLLBACK已回滚(取消订单) STORAGE_IN.入库成功 STORAGE_IN.出库成功  FAIL.操作失败(针对4、5的失败状态) ',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_order_no`(`order_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存变更日志' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_check
-- ----------------------------

CREATE TABLE `in_storage_check`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `batch_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '批次',
  `check_begin_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '盘点开始时间',
  `check_end_time` timestamp(0) NOT NULL DEFAULT '1971-01-01 09:01:01' COMMENT '盘点结束时间',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品id',
  `available` bigint(20) NOT NULL DEFAULT 0 COMMENT '可用货品数量',
  `balance` bigint(20) NOT NULL DEFAULT 0 COMMENT '库存总数',
  `appending` bigint(20) NOT NULL DEFAULT 0 COMMENT '已占用',
  `allocate` bigint(20) NOT NULL DEFAULT 0 COMMENT '已支配',
  `intransit` bigint(20) NOT NULL DEFAULT 0 COMMENT '在途',
  `presell` bigint(20) NOT NULL DEFAULT 0 COMMENT '预售',
  `activity` bigint(20) NOT NULL DEFAULT 0 COMMENT '活动库存',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '盘点汇总信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_check_config
-- ----------------------------

CREATE TABLE `in_storage_check_config`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `group_id` bigint(20) NOT NULL COMMENT '分组ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '配置编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置名称',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'GENERAL' COMMENT 'GENERAL总仓检查 SEPERATE分仓检查 WHOLE全局仓库检查',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存检查配置' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_check_detail
-- ----------------------------

CREATE TABLE `in_storage_check_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `check_begin_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '盘点开始时间',
  `check_end_time` timestamp(0) NOT NULL DEFAULT '1971-01-01 09:01:01' COMMENT '盘点结束时间',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `batch_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '批次编号',
  `cargo_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `available` bigint(20) NOT NULL DEFAULT 0 COMMENT '可用货品数量',
  `position_id` bigint(20) NOT NULL COMMENT '仓位ID',
  `balance` bigint(20) NOT NULL DEFAULT 0 COMMENT '库存数',
  `appending` bigint(20) NOT NULL DEFAULT 0 COMMENT '已占用',
  `allocate` bigint(20) NOT NULL DEFAULT 0 COMMENT '已分配',
  `intransit` bigint(20) NOT NULL DEFAULT 0 COMMENT '在途(调拨)',
  `presell` bigint(20) NOT NULL DEFAULT 0 COMMENT '预售',
  `activity` bigint(20) NOT NULL DEFAULT 0 COMMENT '活动库存',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '盘点明细' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_object
-- ----------------------------

CREATE TABLE `in_storage_object`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `storage_obj_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库存对象名称',
  `storage_obj_table` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库存对象库表',
  `storage_obj_attr` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库存属性',
  `remark` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_storage_obj_name`(`storage_obj_name`) USING BTREE,
  INDEX `idx_update_time`(`update_time`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '库存对象管理表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_order
-- ----------------------------

CREATE TABLE `in_storage_order`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `logic_warehouse_id` bigint(20) NULL DEFAULT -1,
  `order_src_id` bigint(20) NULL DEFAULT NULL COMMENT '单据id',
  `order_src` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据来源',
  `order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '单据编码',
  `business_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务单号',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1：待提交、2：待审核:3：待出库、4：待入库，5：审核不通过、6：待发货、7：已完结、8：取消',
  `category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'CATEGORY_IN' COMMENT 'CATEGORY_IN 入库 CATEGORY_OUT 出库 ',
  `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1：线上销售、 2：线下销售、 3：订货销售、 4：调配、 5：盘亏、 6：移库出库、 7：处置、 8：线上销售退货、 9：线下销售退货、 10：订货销售退货、 11：调配、 12：盘盈、 13：移库入库',
  `audit_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人',
  `audit_time` datetime(0) NULL DEFAULT NULL COMMENT '审核时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE,
  INDEX `idx_order_no`(`order_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '出入库单据' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_storage_order_detail
-- ----------------------------

CREATE TABLE `in_storage_order_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `order_id` bigint(20) NOT NULL COMMENT '单据ID',
  `order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '单据编号',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `position_id` bigint(20) NULL DEFAULT NULL COMMENT '仓位ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品ID',
  `num` bigint(20) NOT NULL COMMENT '货品数量',
  `actual_num` bigint(20) NULL DEFAULT 0 COMMENT '实际数量',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'UNVERIFIED' COMMENT 'UNVERIFIED未核实 VERIFIED已核实 ABNORMAL异常',
  `package_id` bigint(20) NULL DEFAULT NULL COMMENT '包裹id',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_order_id`(`order_id`) USING BTREE,
  INDEX `idx_order_no`(`order_no`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '单据明细' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_transfer_order
-- ----------------------------

CREATE TABLE `in_transfer_order`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `order_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '业务单号',
  `source_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '来源单号',
  `out_physical_warehouse_id` bigint(20) NULL DEFAULT 0 COMMENT '发货物理仓ID',
  `in_physical_warehouse_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '收货物理仓ID',
  `out_logic_warehouse_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '发货逻辑仓ID',
  `in_logic_warehouse_id` bigint(20) NULL DEFAULT 0 COMMENT '收货逻辑仓ID',
  `out_storage_id` bigint(20) NULL DEFAULT 0 COMMENT '出库单ID',
  `in_storage_id` bigint(20) NULL DEFAULT 0 COMMENT '入库单ID',
  `diff_order_id` bigint(20) NULL DEFAULT 0 COMMENT '收发差异单ID',
  `audit_desc` varchar(510) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '‘’' COMMENT '审核说明',
  `audit_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '审核人',
  `audit_time` datetime(0) NULL DEFAULT NULL COMMENT '审核时间',
  `status` tinyint(2) NULL DEFAULT 0 COMMENT '待提交、待审核、待执行、执行中、已完成、已取消',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `type` tinyint(2) NULL DEFAULT 0 COMMENT '物理仓调拨、虚拟仓调拨',
  `extension` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户id',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '实例id',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新人',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '调拨单' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_transfer_order_detail
-- ----------------------------

CREATE TABLE `in_transfer_order_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `order_id` bigint(20) NOT NULL COMMENT '调拨单ID',
  `cargo_id` bigint(20) NOT NULL COMMENT '货品ID',
  `available` decimal(20, 2) NOT NULL DEFAULT 0.00 COMMENT '可用库存',
  `num` decimal(20, 2) NOT NULL DEFAULT 0.00 COMMENT '计划数量',
  `extension` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展值',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户id',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '实例id',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `update_person` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '更新人',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '调拨单明细' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_warehouse
-- ----------------------------

CREATE TABLE `in_warehouse`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父级仓库id（物理仓）',
  `channel_ids` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属渠道,逗号隔开',
  `warehouse_ext_id` bigint(20) NULL DEFAULT NULL COMMENT 'NC的仓库ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓',
  `sub_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '仓库子类型  物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS',
  `status` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'NORMAL' COMMENT '状态：NORMAL-正常 BANNED-封禁 CORRECTION-整改 ABANDON-废弃',
  `route_status` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'NORMAL' COMMENT '路由状态：NORMAL 正常、BANNED 禁用',
  `inventory_share_status` tinyint(2) NOT NULL DEFAULT 0 COMMENT '库存共享状态： 0 不开启 ，1 开启',
  `inventory_share_type` tinyint(2) NOT NULL DEFAULT 1 COMMENT '库存共享类型：0单组织，1全局',
  `business_form` tinyint(4) NULL DEFAULT NULL COMMENT '业务形态：0 零售，1 大货，2 全部',
  `main_warehouse` tinyint(2) NULL DEFAULT NULL COMMENT '是否主仓：0否1是',
  `prov_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `city_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `area_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `addr` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `group_id` bigint(20) NULL DEFAULT NULL,
  `credit_value` int(20) NULL DEFAULT 100 COMMENT '信用值',
  `brand_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌范围',
  `brand_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌名称',
  `coordinates` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库坐标',
  `longitude` decimal(20, 8) NULL DEFAULT NULL COMMENT '仓库坐标经度',
  `latitude` decimal(20, 8) NULL DEFAULT NULL COMMENT '仓库坐标纬度',
  `remark` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `express_delivery_status` tinyint(2) NULL DEFAULT 0 COMMENT '快递启用状态： 1 启用 0 不启用',
  `city_delivery_status` tinyint(2) NULL DEFAULT 0 COMMENT '同城配送启用状态：1 启用 0 不启用',
  `delivery_party_type` tinyint(2) NULL DEFAULT 1 COMMENT '配送方类型： 1 商家配送 2 第三方配送',
  `organization_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `organization_code` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织code',
  `organization_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属组织名称',
  `contact_person` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '负责人名字',
  `contact_phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系方式',
  `deliver_threshold_value` int(11) NULL DEFAULT NULL COMMENT '发货阈值',
  `deliver_threshold_left_value` int(11) NULL DEFAULT NULL COMMENT '剩余发货阈值',
  `threshold_value` int(11) NULL DEFAULT NULL COMMENT '阈值分，每发一件货会减少对应的分，初始值为100',
  `deliver_time_limit` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '发货时效',
  `continue_reject_order` int(11) NULL DEFAULT 0 COMMENT '连续拒单次数',
  `continue_receive_order` int(11) NULL DEFAULT 0 COMMENT '连续接单次数',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_id`(`group_id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仓库' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for in_warehouse_delivery
-- ----------------------------

CREATE TABLE `in_warehouse_delivery`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `warehouse_id` bigint(20) NOT NULL COMMENT '仓库ID',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '配送方code',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '配送方name',
  `merchant_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '在第三方注册的商户编号',
  `shop_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '在第三方注册的店铺编号',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '是否启用：1 启用 0 未启用',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_warehouse_id`(`warehouse_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '仓库配送方信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for meta_attribute
-- ----------------------------

CREATE TABLE `meta_attribute`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `entity_id` bigint(20) NOT NULL COMMENT '所属实体id',
  `code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性编码',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名称',
  `data_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据类型',
  `length` int(11) NULL DEFAULT NULL COMMENT '数据长度',
  `is_pk` int(11) NULL DEFAULT NULL COMMENT '是否主键',
  `is_idx` int(11) NULL DEFAULT NULL COMMENT '是否索引',
  `is_nullable` int(11) NULL DEFAULT NULL COMMENT '是否允许为空',
  `default_value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认值',
  `is_calc_factor` int(11) NULL DEFAULT 0 COMMENT '是否计算因子（0=否 1=是）',
  `source_domain` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值来源关联领域',
  `source_entity` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值来源关联实体',
  `source_attr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值来源关联属性',
  `source_display_attr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值来源关联属性对应的展示名称的列',
  `project` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属项目',
  `source_dict` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值来源关联字典',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '实体属性' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for meta_entity
-- ----------------------------

CREATE TABLE `meta_entity`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `domain_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '所属领域编码',
  `code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实体编码',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实体名称',
  `remark` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实体描述',
  `bundle_code` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用或功能包编码',
  `group_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组名',
  `artifact_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目名',
  `version` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '版本号',
  `domain_id` bigint(20) NULL DEFAULT NULL COMMENT '所属领域id',
  `is_controlled` int(11) NULL DEFAULT 0 COMMENT '是否受控（0=否 1=是）',
  `project` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属项目',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '实体' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for meta_func
-- ----------------------------

CREATE TABLE `meta_func`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `bean_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '当前bean名称',
  `func_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据权限函数名称',
  `func_desc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接口描述',
  `request_param` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求参数',
  `response_param` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '响应参数',
  `group_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分组id',
  `artifact_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目标识',
  `version` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '版本号',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '扩展字段',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `update_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_func`(`bean_name`, `func_name`) USING BTREE,
  INDEX `idx_art_version`(`group_id`, `artifact_id`, `version`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据权限函数' ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;
