/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.adjustmentInventoryStatusCountRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/adjustmentInventory"})
public class AdjustmentInventoryRest
implements IAdjustmentInventoryApi {
    private static Logger logger = LoggerFactory.getLogger(AdjustmentInventoryRest.class);
    @Resource(name="${yunxi.dg.base.project}_AdjustmentInventoryApi")
    IAdjustmentInventoryApi adjustmentInventoryApi;

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Long> addAdjustmentInventory(@RequestBody AdjustmentInventoryReqDto addReqDto) {
        return this.adjustmentInventoryApi.addAdjustmentInventory(addReqDto);
    }

    public RestResponse<Void> modifyAdjustmentInventory(@RequestBody AdjustmentInventoryReqDto modifyReqDto) {
        return this.adjustmentInventoryApi.modifyAdjustmentInventory(modifyReqDto);
    }

    public RestResponse<Void> removeAdjustmentInventory(@PathVariable(value="ids") String ids, @RequestParam(value="instanceId") Long instanceId) {
        return this.adjustmentInventoryApi.removeAdjustmentInventory(ids, instanceId);
    }

    public RestResponse<AdjustmentInventoryRespDto> queryById(@PathVariable(value="id") Long id) {
        return this.adjustmentInventoryApi.queryById(id);
    }

    public RestResponse<AdjustmentInventoryRespDto> queryByAdjustmentNo(@RequestParam(value="adjustmentNo") String adjustmentNo) {
        logger.info("\u6839\u636e\u5e93\u5b58\u8c03\u6574\u5355\u53f7\u67e5\u8be2\u5e93\u5b58\u8c03\u6574\u5355\u8be6\u60c5:{}", (Object)adjustmentNo);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentNo), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.adjustmentInventoryApi.queryByAdjustmentNo(adjustmentNo);
    }

    public RestResponse<PageInfo<AdjustmentInventoryRespDto>> queryByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.adjustmentInventoryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<adjustmentInventoryStatusCountRespDto> adjustmentInventoryStatusCount(@RequestParam(value="filter") String filter) {
        return this.adjustmentInventoryApi.adjustmentInventoryStatusCount(filter);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> closeAdjustmentInventory(@RequestParam Long id, @RequestParam(value="remark") String remark) {
        return this.adjustmentInventoryApi.closeAdjustmentInventory(id, remark);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> auditAdjustmentInventory(@RequestBody AdjustmentInventoryAuditRespDto dto) {
        return this.adjustmentInventoryApi.auditAdjustmentInventory(dto);
    }
}

