/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.WarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicSupplyWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"V2:\u903b\u8f91\u4ed3\u5e93\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/v2/csLogicWarehouse"})
public class CsLogicWarehouseRest
implements ICsLogicWarehouseApi {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseRest.class);
    @Resource(name="${yunxi.dg.base.project}_LogicWarehouseApi")
    ICsLogicWarehouseApi csLogicWarehouseApi;

    public RestResponse<Long> add(@Validated @RequestBody CsLogicWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)addReqDto));
        return this.csLogicWarehouseApi.add(addReqDto);
    }

    public RestResponse<Void> update(@PathVariable(value="id") Long id, @Validated @RequestBody CsLogicWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent((Object)updateReqDto));
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csLogicWarehouseApi.update(id, updateReqDto);
    }

    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csLogicWarehouseApi.delete(id);
    }

    public RestResponse<Long> addLogicWarehouse(@Validated @RequestBody CsLogicWarehouseAddReqDto addReqDto) {
        return this.csLogicWarehouseApi.addLogicWarehouse(addReqDto);
    }

    public RestResponse<Long> addLogicAndPhysicsWarehouse(@Validated @RequestBody WarehouseAddReqDto addReqDto) {
        return this.csLogicWarehouseApi.addLogicAndPhysicsWarehouse(addReqDto);
    }

    public RestResponse<Void> batchAddLogicAndPhysicsWarehouse(@RequestBody List<WarehouseAddReqDto> addReqDtos) {
        return this.csLogicWarehouseApi.batchAddLogicAndPhysicsWarehouse(addReqDtos);
    }

    public RestResponse<CsLogicWarehouseRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csLogicWarehouseApi.queryByPrimaryKey(id);
    }

    public RestResponse<PageInfo<CsLogicWarehouseRespDto>> queryByPage(@Validated @RequestBody CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        return this.csLogicWarehouseApi.queryByPage(queryDto);
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryByParam(@Validated @RequestBody CsLogicWarehouseQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto));
        return this.csLogicWarehouseApi.queryByParam(queryDto);
    }

    public RestResponse<CsLogicWarehouseRespDto> queryReturnWarehouseByOrganizationId(@RequestParam(value="organizationId") Long organizationId) {
        return this.csLogicWarehouseApi.queryReturnWarehouseByOrganizationId(organizationId);
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryList(@RequestBody List<String> warehouseCodes) {
        return this.csLogicWarehouseApi.queryList(warehouseCodes);
    }

    public RestResponse<List<CsLogicWarehouseRespDto>> queryListAll() {
        return this.csLogicWarehouseApi.queryListAll();
    }

    public RestResponse<CsLogicWarehouseRespDto> queryByCodeAndFlag(String warehouseCode) {
        return this.csLogicWarehouseApi.queryByCodeAndFlag(warehouseCode);
    }

    public RestResponse<PageInfo<CsLogicSupplyWarehouseRespDto>> querySupplyByPage(@Validated @RequestBody CsLogicWarehouseQueryDto queryDto) {
        return this.csLogicWarehouseApi.querySupplyByPage(queryDto);
    }
}

