/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.order;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderDetailInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.QueryInTransitQualifiedNoticeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"V2:\u51fa\u5e93\u901a\u77e5\u5355\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/v2/csOutNoticeOrder"})
public class CsOutNoticeOrderRest
implements ICsOutNoticeOrderApi,
ICsOutNoticeOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(CsOutNoticeOrderRest.class);
    @Resource(name="${yunxi.dg.base.project}_ICsOutNoticeOrderApi")
    ICsOutNoticeOrderApi csOutNoticeOrderApi;
    @Resource(name="${yunxi.dg.base.project}_ICsOutNoticeOrderQueryApi")
    ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Autowired
    ILockService lockService;

    public RestResponse<Long> createOutNoticeOrder(@RequestParam(value="relevanceNo") String relevanceNo) {
        return this.csOutNoticeOrderApi.createOutNoticeOrder(relevanceNo);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> sendWms(@RequestParam(value="documentNo") String documentNo) {
        return this.csOutNoticeOrderApi.sendWms(documentNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> delivery(@PathVariable(value="transferNo") String transferNo, @PathVariable(value="shippingCompanyCode") String shippingCompanyCode, @PathVariable(value="shippingCompany") String shippingCompany) {
        Mutex mutex = this.lockService.lock("CsOutNoticeOrderRest_delivery", transferNo, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.csOutNoticeOrderApi.delivery(transferNo, shippingCompanyCode, shippingCompany);
            return restResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> receive(@PathVariable(value="transferNo") String transferNo) {
        Mutex mutex = this.lockService.lock("CsOutNoticeOrderRest_receive", transferNo, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.csOutNoticeOrderApi.receive(transferNo);
            return restResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
    }

    public RestResponse<Void> doNextSaleTransferOrder(@PathVariable(value="transferNo") String transferNo) {
        return this.csOutNoticeOrderApi.doNextSaleTransferOrder(transferNo);
    }

    public RestResponse<String> getConsignmentNo(@PathVariable(value="transferNo") String transferNo) {
        return this.csOutNoticeOrderApi.getConsignmentNo(transferNo);
    }

    public RestResponse<CsOutNoticeOrderRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csOutNoticeOrderQueryApi.queryByPrimaryKey(id);
    }

    public RestResponse<CsOutNoticeOrderRespDto> queryByDocumentNo(@PathVariable(value="documentNo") String documentNo) {
        log.info("\u6839\u636e\u5355\u636e\u53f7\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)documentNo);
        AssertUtil.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{documentNo}), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return this.csOutNoticeOrderQueryApi.queryByDocumentNo(documentNo);
    }

    public RestResponse<CsOutNoticeOrderRespDto> queryDocumentNo(@PathVariable(value="documentNo") String documentNo) {
        return this.csOutNoticeOrderQueryApi.queryDocumentNo(documentNo);
    }

    public RestResponse<PageInfo<CsOutNoticeOrderDetailRespDto>> queryDetailByPage(@RequestBody CsOutNoticeOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        return this.csOutNoticeOrderQueryApi.queryDetailByPage(queryDto);
    }

    public RestResponse<PageInfo<CsOutNoticeOrderRespDto>> queryByPage(@Validated @RequestBody CsOutNoticeOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        return this.csOutNoticeOrderQueryApi.queryByPage(queryDto);
    }

    public RestResponse<List<CsOutNoticeOrderRespDto>> queryByParam(@Validated @RequestBody CsOutNoticeOrderQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto));
        return this.csOutNoticeOrderQueryApi.queryByParam(queryDto);
    }

    public RestResponse<PageInfo<CsOutNoticeOrderDetailRespDto>> groupingPage(@Validated @RequestBody CsOutNoticeOrderDetailInfoQueryReqDto queryDto) {
        return this.csOutNoticeOrderQueryApi.groupingPage(queryDto);
    }

    public RestResponse<PageInfo<OutNoticeOrderDetailRespVo>> queryInTransitQualifiedNotice(QueryInTransitQualifiedNoticeReqDto reqDto) {
        return this.csOutNoticeOrderQueryApi.queryInTransitQualifiedNotice(reqDto);
    }

    public RestResponse<List<CsOutNoticeOrderRespDto>> queryByRelevanceNoList(@RequestBody List<String> relevanceNoList) {
        return this.csOutNoticeOrderQueryApi.queryByRelevanceNoList(relevanceNoList);
    }

    public RestResponse<List<OutNoticeOrderDetailRespVo>> queryTransferInNoticeDetails(@PathVariable(value="longCode") String longCode, @PathVariable(value="batch") String batch) {
        return this.csOutNoticeOrderQueryApi.queryTransferInNoticeDetails(longCode, batch);
    }
}

