/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInNoticeOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"V2:\u5165\u5e93\u901a\u77e5\u5355\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/v2/csInNoticeOrder"})
public class CsInNoticeOrderRest
implements ICsInNoticeOrderApi,
ICsInNoticeOrderQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsInNoticeOrderRest.class);
    @Autowired
    private ICsInNoticeOrderApi csInNoticeOrderApi;
    @Autowired
    private ICsInNoticeOrderQueryApi csInNoticeOrderQueryApi;

    public RestResponse<Long> add(@Validated @RequestBody CsInNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)addReqDto));
        return this.csInNoticeOrderApi.add(addReqDto);
    }

    public RestResponse<Void> update(@PathVariable(value="id") Long id, @Validated @RequestBody CsInNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent((Object)updateReqDto));
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csInNoticeOrderApi.update(id, updateReqDto);
    }

    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csInNoticeOrderApi.delete(id);
    }

    public RestResponse<Long> createInNoticeOrder(String relevanceNo) {
        logger.info("\u6839\u636e\u6536\u8d27\u901a\u77e5\u5355\u53f7\uff0c\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\uff1a[relevanceNo:{}]", (Object)relevanceNo);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)relevanceNo), (String)"\u53c2\u6570\u6709\u8bef");
        return this.csInNoticeOrderApi.createInNoticeOrder(relevanceNo);
    }

    public RestResponse<CsInNoticeOrderRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csInNoticeOrderQueryApi.queryByPrimaryKey(id);
    }

    public RestResponse<PageInfo<CsInNoticeOrderRespDto>> queryByPage(@Validated @RequestBody CsInNoticeOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        return this.csInNoticeOrderQueryApi.queryByPage(queryDto);
    }

    public RestResponse<List<CsInNoticeOrderRespDto>> queryByParam(@Validated @RequestBody CsInNoticeOrderQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto));
        return this.csInNoticeOrderQueryApi.queryByParam(queryDto);
    }
}

