package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.CategoryAttributesReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 产品型号核算品类关系服务接口
*
* @author yiyun
* @since 2022-07-19
*/
@Api(tags = {"产品型号核算品类关系服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-center-item-api-ICategoryAttributesApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/categoryAttributes",
    url = "${yundt.cube.center.item.api:}"
)
public interface ICategoryAttributesApi {

/**
* 新增产品型号核算品类关系
*
* @param addReqDto 产品型号核算品类关系请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增产品型号核算品类关系", notes = "新增产品型号核算品类关系")
RestResponse<Long> addCategoryAttributes(@RequestBody CategoryAttributesReqDto addReqDto);

    /**
    * 修改产品型号核算品类关系
    *
    * @param modifyReqDto 产品型号核算品类关系请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改产品型号核算品类关系", notes = "修改产品型号核算品类关系")
    RestResponse<Void> modifyCategoryAttributes(@RequestBody CategoryAttributesReqDto modifyReqDto);

    /**
    * 删除产品型号核算品类关系
    *
    * @param ids        产品型号核算品类关系删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除产品型号核算品类关系", notes = "删除产品型号核算品类关系")
    RestResponse<Void> removeCategoryAttributes(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

}
