/*
 * @(#)IICategoryApi.java 1.0 2021年11月15日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSapFrontlClassDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSapMaterialClassDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>Title:IICategoryApi</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/11/15 10:20
 * @since 0.1.0
 */
@Api(tags = {"商品中心：目录服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-IICategoryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/category/item",
        url = "${yundt.cube.center.item.api:}"
)
public interface IICategoryApi {

    /**
     * 后台类目初始化
     * @param materialClassDtos
     * @return
     */
    @PostMapping(value = "/materialClassSync")
    @ApiOperation(value = "后台类目初始化", notes = "后台类目初始化")
    RestResponse<Void> materialClassSync(@RequestBody List<ItemSapMaterialClassDto> materialClassDtos);

    /**
     * 批量初始化后台类目
     * @param materialClassDtos
     * @return
     */
    @PostMapping(value = "/syncDirCategoryClass")
    @ApiOperation(value = "批量初始化后台类目", notes = "批量初始化后台类目")
    RestResponse<Void> syncDirCategoryClass(@RequestBody(required = false) List<ItemSapMaterialClassDto> materialClassDtos);

    /**
     * 批量初始化后台类目
     * @param frontlClassDtos
     * @return
     */
    @PostMapping(value = "/syncDirFrontClass")
    @ApiOperation(value = "批量初始化后台类目", notes = "批量初始化后台类目")
    RestResponse<Void> syncDirFrontClass(@RequestBody(required = false) List<ItemSapFrontlClassDto> frontlClassDtos);


}
