package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemInvoiceDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * 商品开票信息接口
 *
 * @author yuangui
 * @since 2022-05-23
 */
@Api(tags = {"商品开票信息"})
@FeignClient(
        contextId = "com-yx-tcbj-center-api-IItemInvoiceApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemInvoice",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemInvoiceApi {
    /**
     * 新增商品开票信息
     *
     * @param addReqDto 新增商品开票信息请求对象
     * @return 处理结果
     */
    @PostMapping("addItemInvoice")
    @ApiOperation(value = "新增商品开票信息", notes = "新增商品开票信息")
    RestResponse<Long> addItemInvoice(@Valid  @RequestBody ItemInvoiceDto addReqDto);
    /**
     * 批量新增商品开票信息
     *
     * @param addReqDtos 批量新增商品开票信息
     * @return 处理结果
     */
    @PostMapping("batchAddItemInvoice")
    @ApiOperation(value = "批量新增商品开票信息", notes = "批量新增商品开票信息")
    RestResponse<Void> batchAddItemInvoice(@Valid @RequestBody List<ItemInvoiceDto> addReqDtos);
    /**
     * 修改货品
     *
     * @param addReqDto 货品请求对象
     * @return 处理结果
     */
    @PostMapping("modifyItemInvoice")
    @ApiOperation(value = "修改商品开票信息", notes = "修改商品开票信息")
    RestResponse<Void> modifyItemInvoice(@Valid @RequestBody ItemInvoiceDto addReqDto);

    /**
     * 根据ids删除商品开票信息
     *
     * @param ids        根据ids删除商品开票信息
     *
     * @return 处理结果
     */
    @PostMapping("/removeByIds")
    @ApiOperation(value = "根据ids删除商品开票信息", notes = "根据ids删除商品开票信息")
    RestResponse<Void> removeByIds(@RequestBody List<Long> ids);
    /**
     * 导入商品开票信息
     * @param importDto
     * @return
     */
    @PostMapping("/importItemInvoice")
    @ApiOperation(value = "导入商品开票信息", notes = "导入商品开票信息")
    RestResponse<String> importItemInvoice(@RequestBody @Validated ImportDto importDto);
}
