package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPriceLogReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 价格管理记录表服务接口
*
* @author author
* @since 2022-08-10
*/
@Api(tags = {"价格管理记录表服务"})
@FeignClient(name = "${hsh.center.item.name:hsh-center-item}",
        path = "/v1/itemPriceLog",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPriceLogApi {

    /**
    * 新增价格管理记录表
    *
    * @param addReqDto 价格管理记录表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增价格管理记录表", notes = "新增价格管理记录表")
    RestResponse<Long> addItemPriceLog(@RequestBody ItemPriceLogReqDto addReqDto);

    /**
    * 修改价格管理记录表
    *
    * @param modifyReqDto 价格管理记录表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改价格管理记录表", notes = "修改价格管理记录表")
    RestResponse<Void> modifyItemPriceLog(@RequestBody ItemPriceLogReqDto modifyReqDto);

    /**
    * 删除价格管理记录表
    *
    * @param ids        价格管理记录表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除价格管理记录表", notes = "删除价格管理记录表")
    RestResponse<Void> removeItemPriceLog(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
