package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;

import com.dtyunxi.yundt.cube.center.item.api.dto.WmsStockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
* 货品服务接口
*
* @author yuangui
* @since 2022-05-23
*/
@Api(tags = {"货品服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-IPcpItemApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/pcpItem",
    url = "${yundt.cube.center.item.api:}"
)
public interface IPcpItemApi {

/**
* 新增货品
*
* @param addReqDto 货品请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增货品", notes = "新增货品")
RestResponse<Long> addPcpItem(@RequestBody PcpItemReqDto addReqDto);

    /**
    * 修改货品
    *
    * @param pcpItemReqDto 货品请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改货品", notes = "修改货品")
    RestResponse<Void> modifyPcpItem(@RequestBody PcpItemReqDto pcpItemReqDto);

    /**
    * 删除货品
    *
    * @param ids        货品删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除货品", notes = "删除货品")
    RestResponse<Void> removePcpItem(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    @PostMapping("/pushWms")
    @ApiOperation(value = "商品wms推送", notes = "商品wms推送")
    RestResponse<Void> pushWms(@RequestBody List<String> itemLongCodes);

    @PostMapping("/manualPushWms")
    @ApiOperation(value = "商品手工推送wms", notes = "商品手工推送wms")
    RestResponse<List<WmsStockReqDto>> manualPushWms(@RequestBody List<String> itemLongCodes);



}
