package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ApiModel(value = "CustomerAuthItemPageReqDto", description = "查询已授权商品列表请求dto")
public class CustomerAuthItemPageReqDto {
    /**
     * 店铺ID
     */
    @NotNull(message = "店铺ID不能为空")
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 客户Id
     */
    @NotNull(message = "客户Id不能为空")
    @ApiModelProperty(name = "customerId", value = "客户Id")
    private Long customerId;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * 商品编号
     */
    @ApiModelProperty(name = "itemCode", value = "商品编号")
    private String itemCode;
    /**
     * sku编码
     */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    /**
     * 后台类目
     */
    @ApiModelProperty(name = "dirIds", value = "后台类目")
    private List<Long> dirIds;
    /**
     * 商品品牌
     */
    @ApiModelProperty(name = "brandId", value = "商品品牌")
    private Long brandId;
    /**
     * 商品类型
     */
    @ApiModelProperty(name = "subType", value = "商品类型")
    private Integer subType;
    /**
     * 启售禁售状态（仅支持已授权商品）
     */
    @ApiModelProperty(name = "prohibiteStatus", value = "1.启售，2.禁售（仅支持已授权商品）")
    private Integer prohibiteStatus;

    private Long organizationId;
    /**
     * 1.已授权商品，2.未授权商品
     */
    @ApiModelProperty(name = "selectType", value = "1.已授权商品，2.未授权商品")
    private Integer selectType = 1;

    private Integer PageNum = 1;

    private Integer PageSize = 10;

    /**
     * 1.需要分页，2.不需要分页
     */
    private Integer needLimit = 1;

    /**
     * 是否授权skuId集合
     */
    private List<Long> matchSkuIds = Lists.newArrayList();
}
