/*
 * @(#)ItemSkuReqDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * sku查询
 * @author  惜笔 | 林五弟
 * @date  2021/11/18 17:23
 * @version 1.0.0
 */
@Data
@ApiModel(value = "ItemSkuQueryReqDto", description = "sku查询信息dto")
public class ItemSkuQueryReqDto extends BaseReqDto {

    @ApiModelProperty(name = "keyword", value = "支持商品名字，商品编码搜索，模糊匹配")
    private String keyword;

    @ApiModelProperty(name = "itemOrgId", value = "商品所属组织")
    private Long itemOrgId;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "skuCodeList", value = "sku编码")
    private List<String> skuCodeList;

    @ApiModelProperty(name = "itemName", value = "商品名字")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "brandId", value = "品牌")
    private Long brandId;

    @ApiModelProperty(name = "dirIdList", value = "类目id")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "dirId", value = "类目，支持下级查询")
    private Long dirId;

    @ApiModelProperty(name = "outSkuIdList", value = "移除的skuId")
    private List<Long> outSkuIdList;

    @ApiModelProperty(name = "inSkuIdList", value = "指定的skuId")
    private List<Long> inSkuIdList;

    @ApiModelProperty(name = "channel", value = "渠道，1-平台端，2-大B端", required = true)
    private Integer channel;

    @ApiModelProperty(name = "shopIdList", value = "channel为2时，限制查询sku范围的店铺范围(必填)", hidden = true)
    private List<Long> shopIdList;

    @ApiModelProperty(name = "orgId", value = "登录者组织id", hidden = true)
    private Long orgId;

    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;

    @ApiModelProperty(name = "itemLongCodeList", value = "商品长编码")
    private List<String> itemLongCodeList;

    @ApiModelProperty(name = "itemOrgIdList", value = "商品组织id")
    private List<Long> itemOrgIdList;

    @ApiModelProperty(name = "itemCodeList", value = "商品编码集合")
    private List<String> itemCodeList;

    @ApiModelProperty(name = "giftBox", value = "商品礼盒，0-是，1-否")
    private Integer giftBox;

    private List<Long> brandIds;
}
