/**
 * @(#) ItemStorageReqDto.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 商品库存请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemStorageReqDto", description = "商品库存请求Dto")
public class ItemStorageReqDto extends BaseReqDto {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    private Long shopId;
    /**
     * skuId
     */
    @NotNull(message = "skuId不允许为空")
    @ApiModelProperty(name = "skuId", value = "skuId，必填")
    private Long skuId;
    /**
     * 库存数
     */
    @NotNull(message = "库存数(balance)不能为空，必填")
    @ApiModelProperty(name = "balance", value = "库存数，该数据值为增量(原库存100，新增100库存，数值传100而不是200)，为负数时为商品库存扣减。在操作库存页面时，可能会有商品库存扣减，所以需要传增量数据")
    private Long balance;
    /**
     * 已占用数
     */
    @ApiModelProperty(name = "presell", value = "已占用数，选填")
    private Long presell;
    /**
     * 活动数
     */
    @ApiModelProperty(name = "activity", value = "活动数，选填")
    private Long activity;
    /**
     * 库存有效日期
     */
    @ApiModelProperty(name = "inventoryEffectiveDate", value = "库存有效日期，选填")
    private Date inventoryEffectiveDate;
    @ApiModelProperty(name = "orderNo", value = "订单号，选填")
    private String orderNo;
    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    private Long composeItemId;
}
