/**
 * @(#) IItemStorageQueryApi.java 1.0 2018-12-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemStorageDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商品库存查询接口
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"商品中心：商品库存接口服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IItemStorageQueryApi",
        path = "/v1/item/storage",
        url = "${yundt.cube.center.item.api:}")
public interface IItemStorageQueryApi {

    /**
     * 消费端:查询店铺下skuId可用的货品库存
     *
     * @param filter 查询过滤条件
     * @return 可用货品库存集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "消费端:查询店铺下skuId可用的货品库存", notes = "消费端:查询店铺下skuId可用的货品库存(filter支持单数或复数查询filter={...} or filter=[{...},{...}])，filter=ItemStorageQueryReqDto(支持集合)")
    RestResponse<List<ItemStorageQueryRespDto>> queryItemStorage(@RequestParam("filter") String filter);

    /**
     * 消费端:批量查询库存信息
     *
     * @param itemStorageBranchQueryReqDto  查询过滤条件
     * @return 可用货品库存集合
     */
    @PostMapping("/list/branch")
    @ApiOperation(value = "消费端:批量查询库存信息", notes = "消费端:批量查询库存信息")
    RestResponse<List<ItemStorageQueryRespDto>> queryBranchItemStorage(@RequestBody ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto);

    /**
     * 管理端:查询店铺下商品库存信息
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 符合条件的数据集合
     */
    @GetMapping("/detail/page")
    @ApiOperation(value = "管理端:查询店铺下商品库存信息", notes = "管理端:查询店铺下商品库存信息，filter=ItemStorageDetailQueryReqDto")
    RestResponse<PageInfo<ItemStorageDetailQueryRespDto>> queryItemStorageDetail(@RequestParam("filter") String filter,
                                                                                 @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                 @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据店铺商品库存ID查询商品库存详情信息
     *
     * @param id     店铺商品库存ID
     * @param filter 过滤条件
     * @return 店铺商品库存
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据店铺商品库存ID查询商品库存详情信息", notes = "根据店铺商品库存ID查询商品库存详情信息，filter=BaseReqDto")
    RestResponse<ItemStorageDetailQueryRespDto> queryItemStorageDetail(@NotNull(message = "店铺商品库存ID不允许为空") @PathVariable("id") Long id,
                                                                       @RequestParam("filter") String filter);

    @GetMapping(value = "/bundle/{itemId}")
    @ApiOperation(value = "查询组合商品所在店铺的库存信息", notes = "查询组合商品所在店铺的库存信息")
    RestResponse<List<BundleItemStorageDto>> queryBundleItemStorage(@PathVariable("itemId") Long itemId, @RequestParam("shopId") Long shopId);
}
